// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AO16/16AO16_Linux_2.x.x.x_DN/samples/txrate/main.h $
// $Rev: 53291 $
// $Date: 2023-06-28 14:20:13 -0500 (Wed, 28 Jun 2023) $

// 16AO16: Sample Application: header file

#ifndef	__MAIN_H__
#define	__MAIN_H__

#include <ctype.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/timeb.h>

#include "16ao16_main.h"



// macros *********************************************************************

#define	SIZEOF_ARRAY(a)			(sizeof((a)) / sizeof((a)[0]))



// data types *****************************************************************

typedef struct
{
	// Application Settings

	s32	continuous;		// > 0 = ignore errors, < 0 = stop on errors
	s32	index;			// device index
	s32	minute_limit;	// for continuous testing
	int	qty;			// Number of devices detected.
	s32	seconds;		// Tx data for this number of seconds.
	s32	test_limit;		// for continuous testing
	s32	tx_mb;

	int	fd;				// File descriptor for device to access.

	// Device Settings

	s32	io_mode;
} args_t;



// prototypes *****************************************************************

int	perform_tests(const args_t* args);



#endif
