// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AO16/16AO16_Linux_2.x.x.x_DN/samples/signals/perform.c $
// $Rev: 53290 $
// $Date: 2023-06-28 14:19:58 -0500 (Wed, 28 Jun 2023) $

// 16AO16: Sample Application: source file

#include "main.h"




//*****************************************************************************
int perform_tests(const args_t* args)
{
	int	errs	= 0;

	//===============================================================
	gsc_label("Setup");
	printf("\n");
	gsc_label_level_inc();

	errs	+= ao16_initialize		(args->fd, -1, 1);
	errs	+= ao16_clock_src		(args->fd, -1, 1, AO16_CLOCK_SRC_INT, NULL);
	errs	+= ao16_xcvr_type		(args->fd, -1, 1, args->xcvr, NULL);
	errs	+= ao16_clock_ref_src	(args->fd, -1, 1, args->ref_src, NULL);

	gsc_label_level_dec();

	//===============================================================
	gsc_label("Clock Output");
	printf("\n");
	gsc_label_level_inc();

	errs	+= ao16_clock_enable(args->fd, -1, 1, AO16_CLOCK_ENABLE_YES, NULL);

	gsc_label_level_dec();

	//===============================================================
	gsc_label("Waiting");
	printf("%d seconds ... ", args->seconds);
	fflush(stdout);
	os_sleep_ms(args->seconds * 1000);
	printf("Done\n");

	errs	+= ao16_initialize(args->fd, -1, 1);

	return(errs);
}



