// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AO16/16AO16_Linux_2.x.x.x_DN/samples/sbtest/watchdog_enable.c $
// $Rev: 54911 $
// $Date: 2024-08-01 09:00:52 -0500 (Thu, 01 Aug 2024) $

// 16AO16: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AO16_IOCTL_WATCHDOG_ENABLE,
			/* arg		*/	AO16_WATCHDOG_ENABLE_NO,
			/* reg		*/	AO16_GSC_BCR,
			/* mask		*/	0x400000,
			/* value	*/	0x000000
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AO16_IOCTL_WATCHDOG_ENABLE,
			/* arg		*/	AO16_WATCHDOG_ENABLE_YES,
			/* reg		*/	AO16_GSC_BCR,
			/* mask		*/	0x400000,
			/* value	*/	0x400000
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= ao16_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_reg_list(fd, __LINE__, list);
	errs	+= service_ioctl_reg_get_list(fd, __LINE__, list);

	errs	+= service_ioctl_set_reg_list(fd, __LINE__, list);
	errs	+= service_ioctl_reg_get_list(fd, __LINE__, list);

	errs	+= ao16_initialize(fd, -1, 0);
	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	// We do nothing here as this requires additional equipment.
	return(0);
}



/******************************************************************************
*
*	Function:	watchdog_enable_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AO16_IOCTL_WATCHDOG_ENABLE.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int watchdog_enable_test(int fd)
{
	int	errs;
	s32	watchdog;

	gsc_label("AO16_IOCTL_WATCHDOG_ENABLE");

	errs	= ao16_query(fd, -1, 0, AO16_QUERY_WATCHDOG, &watchdog);

	if (errs)
	{
		printf("FAIL <---  (Watchdog query.)\n");
	}
	else if (watchdog == 0)
	{
		printf("SKIPPED  (Feature not supported.)\n");
	}
	else
	{
		errs	+= _service_test(fd);
		errs	+= _function_test(fd);

		if (errs == 0)
			printf("PASS\n");
	}

	return(errs);
}


