// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AO16/16AO16_Linux_2.x.x.x_DN/samples/sbtest/range.c $
// $Rev: 54911 $
// $Date: 2024-08-01 09:00:52 -0500 (Thu, 01 Aug 2024) $

// 16AO16: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd, s32 model, s32 capacity, s32 range)
{
	static const service_data_t	list_low[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AO16_IOCTL_RANGE,
			/* arg		*/	AO16_RANGE_1_25,
			/* reg		*/	AO16_GSC_BCR,
			/* mask		*/	0x30000,
			/* value	*/	0x00000
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AO16_IOCTL_RANGE,
			/* arg		*/	AO16_RANGE_2_5,
			/* reg		*/	AO16_GSC_BCR,
			/* mask		*/	0x30000,
			/* value	*/	0x10000
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AO16_IOCTL_RANGE,
			/* arg		*/	AO16_RANGE_5,
			/* reg		*/	AO16_GSC_BCR,
			/* mask		*/	0x30000,
			/* value	*/	0x20000
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AO16_IOCTL_RANGE,
			/* arg		*/	AO16_RANGE_10,
			/* reg		*/	AO16_GSC_BCR,
			/* mask		*/	0x30000,
			/* value	*/	0x30000
		},

		{ SERVICE_END_LIST }
	};

	static const service_data_t	list_high[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AO16_IOCTL_RANGE,
			/* arg		*/	AO16_RANGE_5,
			/* reg		*/	AO16_GSC_BCR,
			/* mask		*/	0x30000,
			/* value	*/	0x10000
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AO16_IOCTL_RANGE,
			/* arg		*/	AO16_RANGE_10,
			/* reg		*/	AO16_GSC_BCR,
			/* mask		*/	0x30000,
			/* value	*/	0x20000
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AO16_IOCTL_RANGE,
			/* arg		*/	AO16_RANGE_20,
			/* reg		*/	AO16_GSC_BCR,
			/* mask		*/	0x30000,
			/* value	*/	0x30000
		},

		{ SERVICE_END_LIST }
	};

	static const service_data_t	list_flv_high_current[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AO16_IOCTL_RANGE,
			/* arg		*/	AO16_RANGE_1_5,
			/* reg		*/	AO16_GSC_BCR,
			/* mask		*/	0x10000,
			/* value	*/	0x00000
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AO16_IOCTL_RANGE,
			/* arg		*/	AO16_RANGE_2_5,
			/* reg		*/	AO16_GSC_BCR,
			/* mask		*/	0x10000,
			/* value	*/	0x10000
		},

		{ SERVICE_END_LIST }
	};

	static const service_data_t	list_flv_high_level[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AO16_IOCTL_RANGE,
			/* arg		*/	AO16_RANGE_5,
			/* reg		*/	AO16_GSC_BCR,
			/* mask		*/	0x10000,
			/* value	*/	0x00000
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AO16_IOCTL_RANGE,
			/* arg		*/	AO16_RANGE_10,
			/* reg		*/	AO16_GSC_BCR,
			/* mask		*/	0x10000,
			/* value	*/	0x10000
		},

		{ SERVICE_END_LIST }
	};

	int						errs	= 0;
	const service_data_t*	list;

	if (model == AO16_MODEL_16AO16)
	{
		if (range == AO16_VOLT_RANGE_LOW)
			list	= list_low;
		else
			list	= list_high;
	}
	else
	{
		if (capacity == AO16_OUTPUT_CAPACITY_HI_CURRENT)
			list	= list_flv_high_current;
		else
			list	= list_flv_high_level;
	}

	errs	+= ao16_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_reg_list(fd, __LINE__, list);
	errs	+= service_ioctl_reg_get_list(fd, __LINE__, list);

	errs	+= service_ioctl_set_reg_list(fd, __LINE__, list);
	errs	+= service_ioctl_reg_get_list(fd, __LINE__, list);

	errs	+= ao16_initialize(fd, -1, 0);
	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	// This requires additional equipment to test.
	return(0);
}



/******************************************************************************
*
*	Function:	range_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AO16_IOCTL_RANGE.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int range_test(int fd)
{
	s32	capacity;
	int	errs	= 0;
	s32	model;
	s32	range	= 0;

	gsc_label("AO16_IOCTL_RANGE");

	errs	+= ao16_query(fd, -1, 0, AO16_QUERY_MODEL, &model);
	errs	+= ao16_query(fd, -1, 0, AO16_QUERY_OUTPUT_CAPACITY, &capacity);
	errs	+= ao16_query(fd, -1, 0, AO16_QUERY_VOLT_RANGE, &range);

	if (errs)
	{
		printf("FAIL <---  (Queries)\n");
	}
	else
	{
		errs	+= _service_test(fd, model, capacity, range);
		errs	+= _function_test(fd);

		if (errs == 0)
			printf("PASS\n");
	}

	return(errs);
}



