// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AO16/16AO16_Linux_2.x.x.x_DN/samples/sbtest/query.c $
// $Rev: 52418 $
// $Date: 2023-01-23 16:38:16 -0600 (Mon, 23 Jan 2023) $

// 16AO16: Sample Application: source file

#include "main.h"



/******************************************************************************
*
*	Function:	query_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AO16_IOCTL_QUERY.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int query_test(int fd)
{
	s32	data;
	s32	count;
	int	errs;
	int	i;
	int	ret;

	gsc_label("AO16_IOCTL_QUERY");
	errs	= ao16_query(fd, -1, 0, AO16_QUERY_COUNT, &count);

	if (count != AO16_QUERY_LAST)
	{
		errs	= 1;
		printf(	"FAIL <---  (%d. expected %ld, got %ld, rebuild application)\n",
				__LINE__,
				(long) AO16_QUERY_LAST,
				(long) count);
	}
	else
	{
		for (i = 0; i < AO16_QUERY_LAST; i++)
		{
			ret		= ao16_query(fd, -1, 0, i, &data);
			errs	+= ret;

			if (ret)
				printf("FAIL <---  (item %d)\n", i);
		}

		if (errs == 0)
			printf("PASS\n");
	}

	return(errs);
}



