// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AO16/16AO16_Linux_2.x.x.x_DN/samples/sbtest/output_mode.c $
// $Rev: 54911 $
// $Date: 2024-08-01 09:00:52 -0500 (Thu, 01 Aug 2024) $

// 16AO16: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AO16_IOCTL_OUTPUT_MODE,
			/* arg		*/	AO16_OUTPUT_MODE_SEQ,
			/* reg		*/	AO16_GSC_BCR,
			/* mask		*/	0x80,
			/* value	*/	0x00
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AO16_IOCTL_OUTPUT_MODE,
			/* arg		*/	AO16_OUTPUT_MODE_SIM,
			/* reg		*/	AO16_GSC_BCR,
			/* mask		*/	0x80,
			/* value	*/	0x80
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= ao16_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_reg_list(fd, __LINE__, list);
	errs	+= service_ioctl_reg_get_list(fd, __LINE__, list);

	errs	+= service_ioctl_set_reg_list(fd, __LINE__, list);
	errs	+= service_ioctl_reg_get_list(fd, __LINE__, list);

	errs	+= ao16_initialize(fd, -1, 0);
	return(errs);
}



//*****************************************************************************
static int _function_test_option(int fd, int fsamp, int mode)
{
	#define	SAMPLES	600	// sequential = 3 secs, simultaneous = 1.5 secs

	s32	chans	= (mode == AO16_OUTPUT_MODE_SIM) ? 2 : 1;
	s32	empty;
	s32	empty_not;
	u32	buf[SAMPLES];
	int	delta	= 500;	// 500 ms window before and after empty mark
	int	errs	= 0;
	int	ms;
	int	send	= (int) sizeof(buf);
	int	sent;

	for (;;)	// A convenience loop.
	{
		ms	= 1000 * SAMPLES / chans / fsamp;

		// We check the FIFO status before and after the empty mark
		memset(buf, 0, sizeof(buf));
		errs	+= ao16_config_ao	(fd, -1, 0, fsamp);
		errs	+= ao16_channel_sel	(fd, -1, 0, 0x03, NULL);
		errs	+= ao16_output_mode	(fd, -1, 0, mode, NULL);
		errs	+= ao16_clock_enable(fd, -1, 0, AO16_CLOCK_ENABLE_NO, NULL);
		errs	+= ao16_buffer_clear(fd, -1, 0);
		sent	= ao16_write(fd, buf, send);
		errs	+= ao16_clock_enable(fd, -1, 0, AO16_CLOCK_ENABLE_YES, NULL);
		gsc_time_sleep_ms(ms - delta);
		errs	+= ao16_buffer_status(fd, -1, 0, &empty_not);
		gsc_time_sleep_ms(delta * 2);
		errs	+= ao16_buffer_status(fd, -1, 0, &empty);
		errs	+= ao16_initialize(fd, -1, 0);

		if (errs)
		{
			printf("FAIL <---  (Service error.)\n");
			break;
		}

		if (sent != send)
		{
			errs++;
			printf(	"ERROR: %d. write: sent %ld bytes, expected %ld)\n",
					__LINE__,
					(long) sent,
					(long) send);
			break;
		}

		if (empty_not == AO16_BUFFER_STATUS_EMPTY)
		{
			errs++;
			printf("FAIL <--- (Chans: %d, FIFO should not be empty)\n", chans);
		}
		else if (empty != AO16_BUFFER_STATUS_EMPTY)
		{
			errs++;
			printf("FAIL <--- (Chans: %d, FIFO not EMPTY.)\n", chans);
		}

		break;
	}

	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	// The procedure is to select a sample rate and data volume so we can use
	// the time it takes for the buffer to empty. This is done using both
	// modes. The time needed to empty the buffer is then 1X and 2X, making it
	// easy to test this feature. This test was modified to support the plain
	// 16AO16 and the 16AO16FLV, which have different reference clock
	// frequencies.

	#define	FSAMP	200	// very low rate supported by all devices

	int	errs	= 0;

	errs	+= _function_test_option(fd, FSAMP, AO16_OUTPUT_MODE_SEQ);
	errs	+= _function_test_option(fd, FSAMP, AO16_OUTPUT_MODE_SIM);

	return(errs);
}



/******************************************************************************
*
*	Function:	output_mode_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AO16_IOCTL_OUTPUT_MODE.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int output_mode_test(int fd)
{
	int	errs	= 0;

	gsc_label("AO16_IOCTL_OUTPUT_MODE");
	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}



