// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AO16/16AO16_Linux_2.x.x.x_DN/samples/sbtest/output_filter.c $
// $Rev: 54911 $
// $Date: 2024-08-01 09:00:52 -0500 (Thu, 01 Aug 2024) $

// 16AO16: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AO16_IOCTL_OUTPUT_FILTER,
			/* arg		*/	AO16_OUTPUT_FILTER_NONE,
			/* reg		*/	AO16_GSC_BCR,
			/* mask		*/	0xC0000,
			/* value	*/	0x00000
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AO16_IOCTL_OUTPUT_FILTER,
			/* arg		*/	AO16_OUTPUT_FILTER_A,
			/* reg		*/	AO16_GSC_BCR,
			/* mask		*/	0xC0000,
			/* value	*/	0x80000
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AO16_IOCTL_OUTPUT_FILTER,
			/* arg		*/	AO16_OUTPUT_FILTER_B,
			/* reg		*/	AO16_GSC_BCR,
			/* mask		*/	0xC0000,
			/* value	*/	0xC0000
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= ao16_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_reg_list(fd, __LINE__, list);
	errs	+= service_ioctl_reg_get_list(fd, __LINE__, list);

	errs	+= service_ioctl_set_reg_list(fd, __LINE__, list);
	errs	+= service_ioctl_reg_get_list(fd, __LINE__, list);

	errs	+= ao16_initialize(fd, -1, 0);
	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	// We do nothing here as this requires additional equipment.
	return(0);
}



/******************************************************************************
*
*	Function:	output_filter_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AO16_IOCTL_OUTPUT_FILTER.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int output_filter_test(int fd)
{
	int	errs;
	s32	filter;

	gsc_label("AO16_IOCTL_OUTPUT_FILTER");

	errs	= ao16_query(fd, -1, 0, AO16_QUERY_OUTPUT_FILTER, &filter);

	if (errs)
	{
		printf("FAIL <---  (Output Filter query.)\n");
	}
	else if (filter == 0)
	{
		printf("SKIPPED  (Feature not supported.)\n");
	}
	else
	{
		errs	+= _service_test(fd);
		errs	+= _function_test(fd);

		if (errs == 0)
			printf("PASS\n");
	}

	return(errs);
}


