// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AO16/16AO16_Linux_2.x.x.x_DN/samples/sbtest/nrate.c $
// $Rev: 56212 $
// $Date: 2025-02-06 13:31:11 -0600 (Thu, 06 Feb 2025) $

// 16AO16: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AO16_IOCTL_NRATE,
			/* arg		*/	0x3FFFF,
			/* reg		*/	AO16_GSC_SRR,
			/* mask		*/	0x3FFFF,
			/* value	*/	0x3FFFF
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AO16_IOCTL_NRATE,
			/* arg		*/	0x30000,
			/* reg		*/	AO16_GSC_SRR,
			/* mask		*/	0x3FFFF,
			/* value	*/	0x30000
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AO16_IOCTL_NRATE,
			/* arg		*/	0x0F000,
			/* reg		*/	AO16_GSC_SRR,
			/* mask		*/	0x3FFFF,
			/* value	*/	0x0F000
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AO16_IOCTL_NRATE,
			/* arg		*/	0x00F00,
			/* reg		*/	AO16_GSC_SRR,
			/* mask		*/	0x3FFFF,
			/* value	*/	0x00F00
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AO16_IOCTL_NRATE,
			/* arg		*/	0x000F0,
			/* reg		*/	AO16_GSC_SRR,
			/* mask		*/	0x3FFFF,
			/* value	*/	0x000F0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AO16_IOCTL_NRATE,
			/* arg		*/	0x006E,
			/* reg		*/	AO16_GSC_SRR,
			/* mask		*/	0x3FFFF,
			/* value	*/	0x006E
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= ao16_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_reg_list(fd, __LINE__, list);
	errs	+= service_ioctl_reg_get_list(fd, __LINE__, list);

	errs	+= service_ioctl_set_reg_list(fd, __LINE__, list);
	errs	+= service_ioctl_reg_get_list(fd, __LINE__, list);

	errs	+= ao16_initialize(fd, -1, 0);
	return(errs);
}



//*****************************************************************************
static int _select_fsamp(int fd, int* fsamp)
{
	int		errs	= 0;
	int		f;
	int		fsamp_1	= 0;
	int		fsamp_2;
	s32		max;
	s32		min;
	double	rate_1;
	double	rate_2;
	s32		ref_src_1;
	s32		ref_src_2;

	errs	+= ao16_query(fd, -1, 0, AO16_QUERY_FSAMP_MAX, &max);
	errs	+= ao16_query(fd, -1, 0, AO16_QUERY_FSAMP_MIN, &min);
	max	/= 2;

	for (f = min; errs == 0; f++)
	{
		if (f > max)
			errs++;

		errs	+= ao16_fsamp_compute(fd, -1, 0, f, &ref_src_1, NULL, NULL, &rate_1);
		errs	+= ao16_fsamp_compute(fd, -1, 0, f * 2, &ref_src_2, NULL, NULL, &rate_2);
		fsamp_1	= (int) rate_1;
		fsamp_2	= (int) rate_2;

		if ((ref_src_1 == AO16_CLOCK_REF_SRC_PRI) &&
			(ref_src_2 == AO16_CLOCK_REF_SRC_PRI) &&
			(fsamp_2 == (fsamp_1 * 2)))
		{
			break;
		}
	}

	if (errs == 0)
		fsamp[0]	= fsamp_1;

	return(errs);
}



//*****************************************************************************
static int _function_test_option(int fd, int instance, int fsamp)
{
	#define	SAMPLES	600

	s32	empty;
	s32	empty_not;
	u32	buf[SAMPLES];
	int	delta	= 500;	// 500 ms window before and after empty mark
	int	errs	= 0;
	int	mask	= 0x01;
	int	ms;
	int	send	= (int) sizeof(buf);
	int	sent;

	for (;;)	// A convenience loop.
	{
		ms	= 1000 * SAMPLES / fsamp;

		// We check the FIFO status before and after the empty mark
		memset(buf, 0, sizeof(buf));
		errs	+= ao16_config_ao	(fd, -1, 0, fsamp);
		errs	+= ao16_channel_sel	(fd, -1, 0, mask, NULL);
		errs	+= ao16_clock_enable(fd, -1, 0, AO16_CLOCK_ENABLE_NO, NULL);
		errs	+= ao16_buffer_clear(fd, -1, 0);
		sent	= ao16_write(fd, buf, send);
		errs	+= ao16_clock_enable(fd, -1, 0, AO16_CLOCK_ENABLE_YES, NULL);
		gsc_time_sleep_ms(ms - delta);
		errs	+= ao16_buffer_status(fd, -1, 0, &empty_not);
		gsc_time_sleep_ms(delta * 2);
		errs	+= ao16_buffer_status(fd, -1, 0, &empty);

		if (errs)
		{
			printf("FAIL <---  (%d: Service error.)\n", instance);
			break;
		}

		if (sent != send)
		{
			errs++;
			printf(	"FAIL <---  (%d: write: sent %d bytes, expected %d)\n",
					instance,
					sent,
					send);
			break;
		}

		if (empty_not == AO16_BUFFER_STATUS_EMPTY)
		{
			errs++;
			printf("FAIL <--- (%d: FIFO should not be empty)\n", instance);
			errs	+= ao16_fsamp_report(fd, -1, 1, 0, NULL);
		}
		else if (empty != AO16_BUFFER_STATUS_EMPTY)
		{
			errs++;
			printf("FAIL <--- (%d: FIFO not EMPTY.)\n", instance);
			errs	+= ao16_fsamp_report(fd, -1, 1, 0, NULL);
		}

		ao16_initialize(fd, -1, 0);
		break;
	}

	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	// The procedure is to select two sample rates and data volume so we can
	// use the time it takes for the buffer to empty. This is done using two
	// sample rates based on the primary reference clock, such that one is
	// twice the other. The time needed to empty the buffer is then 1X and 2X,
	// making it easy to test this feature. This test was modified to support
	// the plain 16AO16 and the 16AO16FLV, which have different reference clock
	// frequencies.

	int	errs;
	int	fsamp;

	errs	= _select_fsamp(fd, &fsamp);

	if (errs == 0)
	{
		errs	+= _function_test_option(fd, 1, fsamp);
		errs	+= _function_test_option(fd, 2, fsamp * 2);
	}

	return(errs);
}



/******************************************************************************
*
*	Function:	nrate_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AO16_IOCTL_NRATE.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int nrate_test(int fd)
{
	int	errs	= 0;

	gsc_label("AO16_IOCTL_NRATE");
	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}



