// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AO16/16AO16_Linux_2.x.x.x_DN/samples/sbtest/nclk.c $
// $Rev: 54911 $
// $Date: 2024-08-01 09:00:52 -0500 (Thu, 01 Aug 2024) $

// 16AO16: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AO16_IOCTL_NCLK,
			/* arg		*/	0x1FF,
			/* reg		*/	AO16_GSC_ACR,
			/* mask		*/	0x1FF,
			/* value	*/	0x1FF
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AO16_IOCTL_NCLK,
			/* arg		*/	0x100,
			/* reg		*/	AO16_GSC_ACR,
			/* mask		*/	0x1FF,
			/* value	*/	0x100
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AO16_IOCTL_NCLK,
			/* arg		*/	0x0F0,
			/* reg		*/	AO16_GSC_ACR,
			/* mask		*/	0x1FF,
			/* value	*/	0x0F0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AO16_IOCTL_NCLK,
			/* arg		*/	0x00F,
			/* reg		*/	AO16_GSC_ACR,
			/* mask		*/	0x1FF,
			/* value	*/	0x00F
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AO16_IOCTL_NCLK,
			/* arg		*/	0x000,
			/* reg		*/	AO16_GSC_ACR,
			/* mask		*/	0x1FF,
			/* value	*/	0x000
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= ao16_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_reg_list(fd, __LINE__, list);
	errs	+= service_ioctl_reg_get_list(fd, __LINE__, list);

	errs	+= service_ioctl_set_reg_list(fd, __LINE__, list);
	errs	+= service_ioctl_reg_get_list(fd, __LINE__, list);

	errs	+= ao16_initialize(fd, -1, 0);
	return(errs);
}



//*****************************************************************************
static int _select_fsamp(int fd, int* fsamp)
{
	int		errs	= 0;
	int		f;
	int		fsamp_1	= 0;
	int		fsamp_2;
	s32		max;
	s32		min;
	s32		nrate_1;
	s32		nrate_2;
	double	rate_1;
	double	rate_2;
	s32		ref_src_1;
	s32		ref_src_2;

	errs	+= ao16_query(fd, -1, 0, AO16_QUERY_FSAMP_MAX, &max);
	errs	+= ao16_query(fd, -1, 0, AO16_QUERY_FSAMP_MIN, &min);
	max	/= 2;

	for (f = min; errs == 0; f++)
	{
		if (f > max)
			errs++;

		errs	+= ao16_fsamp_compute(fd, -1, 0, f, &ref_src_1, &nrate_1, NULL, &rate_1);
		errs	+= ao16_fsamp_compute(fd, -1, 0, f * 2, &ref_src_2, &nrate_2, NULL, &rate_2);
		fsamp_1	= (int) rate_1;
		fsamp_2	= (int) rate_2;

		if ((ref_src_1 == AO16_CLOCK_REF_SRC_ALT)	&&
			(ref_src_2 == AO16_CLOCK_REF_SRC_ALT)	&&
			(nrate_1 == nrate_2)					&&
			(fsamp_2 == (fsamp_1 * 2)))
		{
			break;
		}
	}

	if (errs == 0)
		fsamp[0]	= fsamp_1;

	return(errs);
}



//*****************************************************************************
static int _function_test_option(int fd, int instance, int fsamp)
{
	#define	SAMPLES	600

	s32	empty;
	s32	empty_not;
	u32	buf[SAMPLES];
	int	delta	= 500;	// 500 ms window before and after empty mark
	int	errs	= 0;
	int	mask	= 0x01;
	int	ms;
	int	send	= (int) sizeof(buf);
	int	sent;

	for (;;)	// A convenience loop.
	{
		ms	= 1000 * SAMPLES / fsamp;

		// We check the FIFO status before and after the empty mark
		memset(buf, 0, sizeof(buf));
		errs	+= ao16_config_ao	(fd, -1, 0, fsamp);
		errs	+= ao16_channel_sel	(fd, -1, 0, mask, NULL);
		errs	+= ao16_clock_enable(fd, -1, 0, AO16_CLOCK_ENABLE_NO, NULL);
		errs	+= ao16_buffer_clear(fd, -1, 0);
		sent	= ao16_write(fd, buf, send);
		errs	+= ao16_clock_enable(fd, -1, 0, AO16_CLOCK_ENABLE_YES, NULL);
		gsc_time_sleep_ms(ms - delta);
		errs	+= ao16_buffer_status(fd, -1, 0, &empty_not);
		gsc_time_sleep_ms(delta * 2);
		errs	+= ao16_buffer_status(fd, -1, 0, &empty);

		if (errs)
		{
			printf("FAIL <---  (%d: Service error.)\n", instance);
			break;
		}

		if (sent != send)
		{
			errs++;
			printf(	"FAIL <---  (%d: write: sent %d bytes, expected %d)\n",
					instance,
					sent,
					send);
			break;
		}

		if (empty_not == AO16_BUFFER_STATUS_EMPTY)
		{
			errs++;
			printf("FAIL <--- (%d: FIFO should not be empty)\n", instance);
			errs	+= ao16_fsamp_report(fd, -1, 1, 0, NULL);
		}
		else if (empty != AO16_BUFFER_STATUS_EMPTY)
		{
			errs++;
			printf("FAIL <--- (%d: FIFO not EMPTY.)\n", instance);
			errs	+= ao16_fsamp_report(fd, -1, 1, 0, NULL);
		}

		ao16_initialize(fd, -1, 0);
		break;
	}

	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	// The procedure is to select two sample rates and data volume so we can
	// use the time it takes for the buffer to empty. This is done using two
	// sample rates based on the alternate reference clock, such that one is
	// twice the other. The time needed to empty the buffer is then 1X and 2X,
	// making it easy to test this feature. This test was modified to support
	// the plain 16AO16 and the 16AO16FLV, which have different reference clock
	// frequencies.

	int	errs;
	int	fsamp;

	errs	= _select_fsamp(fd, &fsamp);

	if (errs == 0)
	{
		errs	+= _function_test_option(fd, 1, fsamp);
		errs	+= _function_test_option(fd, 2, fsamp * 2);
	}

	return(errs);
}



/******************************************************************************
*
*	Function:	nclk_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AO16_IOCTL_NCLK.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int nclk_test(int fd)
{
	int	errs	= 0;

	gsc_label("AO16_IOCTL_NCLK");
	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}



