// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AO16/16AO16_Linux_2.x.x.x_DN/samples/sbtest/main.h $
// $Rev: 54911 $
// $Date: 2024-08-01 09:00:52 -0500 (Thu, 01 Aug 2024) $

// 16AO16: Sample Application: header file

#ifndef	__MAIN_H__
#define	__MAIN_H__

#include <errno.h>
#include <semaphore.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "16ao16_main.h"



// macros *********************************************************************

#define	SIZEOF_ARRAY(a)			(sizeof((a)) / sizeof((a)[0]))



// data types *****************************************************************

typedef struct
{
	// Application Settings

	s32	continuous;		// > 0 = ignore errors, < 0 = stop on errors
	s32	index;			// device index
	s32	minute_limit;	// for continuous testing
	int	qty;			// Number of devices detected.
	s32	test_limit;		// for continuous testing

	int	fd;				// File descriptor for the device to access.

	// Device Settings

} args_t;

typedef enum
{
	SERVICE_END_LIST,	// Ends list of service_data_t structures.
	SERVICE_NONE,		// Do nothing.
	SERVICE_NORMAL,
	SERVICE_REG_MOD,
	SERVICE_REG_READ,
	SERVICE_REG_SHOW,
	SERVICE_REG_TEST,
	SERVICE_REG_WRITE,	// arg = # of times to write
	SERVICE_SLEEP,		// arg = # of seconds to sleep
	SERVICE_SLEEP_MS,	// arg = # of milliseconds to sleep
	SERVICE_IOCTL_GET,
	SERVICE_IOCTL_SET
} service_t;

typedef struct
{
	service_t		service;	// service_t
	int				cmd;		// IOCTL code
	s32				arg;		// The IOCTL data argument.
	u32				reg;		// The register to access. Use -1 to ignore.
	u32				mask;		// The register bits of interest.
	u32				value;		// The value expected for the bits of interest.
} service_data_t;



// prototypes *****************************************************************

int	autocal_status_test(int fd);		// AO16_IOCTL_AUTOCAL_STATUS
int	autocal_test(int fd);				// AO16_IOCTL_AUTOCAL

int	buffer_clear_test(int fd);			// AO16_IOCTL_BUFFER_CLEAR
int	buffer_mode_test(int fd);			// AO16_IOCTL_BUFFER_MODE
int	buffer_over_data_test(int fd);		// AO16_IOCTL_BUFFER_OVER_DATA
int	buffer_over_frame_test(int fd);		// AO16_IOCTL_BUFFER_OVER_FRAME
int	buffer_size_test(int fd);			// AO16_IOCTL_BUFFER_SIZE
int	buffer_status_test(int fd);			// AO16_IOCTL_BUFFER_STATUS
int	burst_enable_test(int fd);			// AO16_IOCTL_BURST_ENABLE
int	burst_ready_test(int fd);			// AO16_IOCTL_BURST_READY
int	burst_trig_src_test(int fd);		// AO16_IOCTL_BURST_TRIG_SRC
int	burst_trigger_test(int fd);			// AO16_IOCTL_BURST_TRIGGER

int	cbl_iso_clock_io_test(int fd);		// AO16_IOCTL_CBL_ISO_CLOCK_IO
int	cbl_iso_dac_clk_out_test(int fd);	// AO16_IOCTL_CBL_ISO_DAC_CLK_OUT
int	cbl_iso_trig_out_test(int fd);		// AO16_IOCTL_CBL_ISO_TRIG_OUT
int	cbl_pol_clock_io_test(int fd);		// AO16_IOCTL_CBL_POL_CLOCK_IO
int	cbl_pol_dac_clk_out_test(int fd);	// AO16_IOCTL_CBL_POL_DAC_CLK_OUT
int	cbl_pol_trig_in_test(int fd);		// AO16_IOCTL_CBL_POL_TRIG_IN
int	cbl_pol_trig_out_test(int fd);		// AO16_IOCTL_CBL_POL_TRIG_OUT
int	channel_sel_test(int fd);			// AO16_IOCTL_CHANNEL_SEL
int	clock_enable_test(int fd);			// AO16_IOCTL_CLOCK_ENABLE
int	clock_ready_test(int fd);			// AO16_IOCTL_CLOCK_READY
int	clock_ref_src_test(int fd);			// AO16_IOCTL_CLOCK_REF_SRC
int	clock_src_test(int fd);				// AO16_IOCTL_CLOCK_SRC
int	clock_sw_test(int fd);				// AO16_IOCTL_CLOCK_SW

int	data_format_test(int fd);			// AO16_IOCTL_DATA_FORMAT

int	ground_sense_test(int fd);			// AO16_IOCTL_GROUND_SENSE

int	initialize_test(int fd);			// AO16_IOCTL_INITIALIZE
int	irq_sel_test(int fd);				// AO16_IOCTL_IRQ_SEL

int	load_ready_test(int fd);			// AO16_IOCTL_LOAD_READY
int	load_request_test(int fd);			// AO16_IOCTL_LOAD_REQUEST

int	nclk_test(int fd);					// AO16_IOCTL_NCLK
int	nrate_test(int fd);					// AO16_IOCTL_NRATE

int	output_filter_test(int fd);			// AO16_IOCTL_OUTPUT_FILTER
int	output_mode_test(int fd);			// AO16_IOCTL_OUTPUT_MODE

int	perform_tests(const args_t* args);

int	query_test(int fd);					// AO16_IOCTL_QUERY

int	range_test(int fd);					// AO16_IOCTL_RANGE
int	reg_mod_test(int fd);				// AO16_IOCTL_REG_MOD
int	reg_read_test(int fd);				// AO16_IOCTL_REG_READ
int	reg_write_test(int fd);				// AO16_IOCTL_REG_WRITE

int	service_ioctl_reg_get_list(int fd, int line, const service_data_t* list);
int	service_ioctl_set_get_list(int fd, int line, const service_data_t* list);
int	service_ioctl_set_reg_list(int fd, int line, const service_data_t* list);

int	tx_io_abort_test(int fd);			// AO16_IOCTL_TX_IO_ABORT
int	tx_io_mode_test(int fd);			// AO16_IOCTL_TX_IO_MODE
int	tx_io_over_data_test(int fd);		// AO16_IOCTL_TX_IO_OVER_DATA
int	tx_io_over_frame_test(int fd);		// AO16_IOCTL_TX_IO_OVER_FRAME
int	tx_io_timeout_test(int fd);			// AO16_IOCTL_TX_IO_TIMEOUT

int	wait_cancel_test(int fd);			// AO16_IOCTL_WAIT_CANCEL
int	wait_event_test(int fd);			// AO16_IOCTL_WAIT_EVENT
int	wait_status_test(int fd);			// AO16_IOCTL_WAIT_STATUS
int	watchdog_enable_test(int fd);		// AO16_IOCTL_WATCHDOG_ENABLE
int	watchdog_output_test(int fd);		// AO16_IOCTL_WATCHDOG_OUTPUT

int	xcvr_test(int fd);



#endif
