// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AO16/16AO16_Linux_2.x.x.x_DN/samples/id/perform.c $
// $Rev: 53287 $
// $Date: 2023-06-28 14:19:06 -0500 (Wed, 28 Jun 2023) $

// 16AO16: Sample Application: source file

#include "main.h"



//*****************************************************************************
static void _buffer_modes(void)
{
	gsc_label("Buffer Modes");
	printf("Circular, Open\n");
}



//*****************************************************************************
static void _clocking_modes(void)
{
	gsc_label("Clocking Modes");
	printf("Sequential, Simultaneous\n");
}



//*****************************************************************************
static void _clocking_sources(void)
{
	gsc_label("Clocking Sources");
	printf("Internal, External, Software\n");
}



//*****************************************************************************
static void _output_modes(void)
{
	gsc_label("Output Modes");
	printf("Differential, Single Ended\n");
}



//*****************************************************************************
static void _rate_generators(void)
{
	gsc_label("Rate Generators");
	printf("1\n");
}



//*****************************************************************************
static void _sampling_modes(void)
{
	gsc_label("Sampling Modes");
	printf("Continuous, Burst, Single Shot\n");
}



//*****************************************************************************
static void _xcvr_options(void)
{
	gsc_label("Transceiver Options");
	printf("LVDS, TTL\n");
}



//*****************************************************************************
static int _id_device_reg(const args_t* args)
{
	int						errs;
	gsc_reg_def_t			list[2]	= { { NULL }, { NULL } };
	const gsc_reg_def_t*	ptr;

	printf("\n");
	ptr	= ao16_reg_get_def_id(AO16_GSC_FOR);

	if (ptr)
	{
		list[0]	= ptr[0];
		errs	= gsc_reg_list(args->fd, list, 1, ao16_reg_read);
	}
	else
	{
		errs	= 1;
		printf(	"FAIL <---  (%d. ao16_reg_get_def_id, AO16_GSC_FOR)\n",
				__LINE__);
	}

	return(errs);
}



//*****************************************************************************
static int _register_map(const args_t* args)
{
	int	errs;

	printf("\n");
	errs	= ao16_reg_list(args->fd, args->detail);
	return(errs);
}



//*****************************************************************************
int perform_tests(const args_t* args)
{
	int	errs	= 0;
	int	i;

	gsc_label("Device Features");
	printf("\n");

	gsc_label_level_inc();

	_output_modes();
	_rate_generators();
	_clocking_sources();
	_clocking_modes();
	_sampling_modes();
	_buffer_modes();
	_xcvr_options();

	for (i = 0; i < AO16_QUERY_LAST; i++)
		errs	+= ao16_query(args->fd, -1, 1, i, NULL);

	gsc_label_level_dec();

	errs	+= _id_device_reg(args);
	errs	+= _register_map(args);
	printf("\n");

	return(errs);
}


