// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AO16/16AO16_Linux_2.x.x.x_DN/samples/fsamp/perform.c $
// $Rev: 56211 $
// $Date: 2025-02-06 13:30:26 -0600 (Thu, 06 Feb 2025) $

// 16AO16: Sample Application: source file

#include "main.h"



// macros *********************************************************************

#define	FILE_NAME				"fsamp.txt"
#define	LIMIT_MAX(v,max)		(((v) > (max)) ? (max) : (v))
#define	LIMIT_MIN(v,min)		(((v) < (min)) ? (min) : (v))
#define	LIMIT_RANGE(v,min,max)	(LIMIT_MIN((LIMIT_MAX((v),(max))),(min)))



//*****************************************************************************
static int _hold_secs(const args_t* args, s32 fsamp)
{
	char	buf[80];
	int		errs	= 0;

	gsc_label("Config");
	errs	+= ao16_config_ao	(args->fd, -1, 0, fsamp);
	errs	+= ao16_xcvr_type	(args->fd, -1, 0, args->xcvr, NULL);
	printf("%s\n", errs ? "FAIL <---" : "PASS");

	if (args->hold_reg_dump)
		ao16_reg_list(args->fd, 1);

	strcpy(buf, "Holding ");
	gsc_label_long_comma_buf(args->hold_secs, buf + strlen(buf));
	strcat(buf, " secs");
	gsc_label(buf);

	if (errs == 0)
	{
		os_sleep_ms(args->hold_secs * 1000);
		printf("Done\n");
	}
	else
	{
		printf("Aborting due to error.\n");
	}

	return(errs);
}



//*****************************************************************************
static int _limits(const args_t* args, s32 start, s32 stop)
{
	int			errs	= 0;
	FILE*		file	= NULL;
	s32			fref;
	s32			fsamp;
	s32			max		= args->fsamp;
	s32			min		= args->fsamp;
	const char*	name	= FILE_NAME;
	double		rate;

	errs	+= ao16_query(args->fd, -1, 1, AO16_QUERY_FREF_DEFAULT, &fref);
	errs	+= ao16_query(args->fd, -1, 1, AO16_QUERY_FSAMP_MIN, &min);
	errs	+= ao16_query(args->fd, -1, 1, AO16_QUERY_FSAMP_MAX, &max);

	gsc_label("Fsamp Computation");
	gsc_label_level_inc();

	if (start < 0)
		start	= min;

	if (stop < 0)
		stop	= max;

	start	= LIMIT_RANGE(start, min, max);
	stop	= LIMIT_RANGE(stop, min, max);

	if (start == stop)
	{
		gsc_label_long_comma(start);
		printf(" S/S\n");
	}
	else
	{
		gsc_label_long_comma(start);
		printf(" S/S - ");
		gsc_label_long_comma(stop);
		printf(" S/S\n");
	}

	if (args->save)
	{
		file	= fopen(name, "w+b");

		if (file == NULL)
		{
			printf("FAIL <---  (unable to create %s)\n", name);
			errs	= 1;
		}
		else
		{
			fprintf(file, "# 16AO16 Sample Rates\n");
			fprintf(file, "# Request  Produced\n");
			fprintf(file, "# =======  ==========\n");
		}
	}

	for (fsamp = start; fsamp <= stop; fsamp++)
	{
		errs	+= ao16_fsamp_compute(args->fd, -1, 1, fsamp, NULL, NULL, NULL, &rate);

		if (args->hold_secs)
			errs	+= _hold_secs(args, fsamp);

		if (file)
			fprintf(file, "%9ld  %10.3f\n", (long) fsamp, (float) rate);
	}

	if (file)
		fclose(file);

	gsc_label_level_dec();
	return(errs);
}



//*****************************************************************************
int perform_tests(const args_t* args)
{
	int	errs;
	s32	max;
	s32	min;

	if (args->plus_minus >= 0)
	{
		max		= args->fsamp + args->plus_minus;
		min		= args->fsamp - args->plus_minus;
		errs	= _limits(args, min, max);
	}
	else if (args->range)
	{
		errs	= _limits(args, -1, -1);
	}
	else
	{
		errs	= _limits(args, args->fsamp, args->fsamp);
	}

	return(errs);
}


