// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AO16/16AO16_Linux_2.x.x.x_DN/samples/fsamp/main.h $
// $Rev: 56211 $
// $Date: 2025-02-06 13:30:26 -0600 (Thu, 06 Feb 2025) $

// 16AO16: Sample Application: header file

#ifndef	__MAIN_H__
#define	__MAIN_H__

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "16ao16_main.h"



// macros *********************************************************************

#define	SIZEOF_ARRAY(a)			(sizeof((a)) / sizeof((a)[0]))



// data types *****************************************************************

typedef struct
{
	// Application Settings

	s32	continuous;		// > 0 = ignore errors, < 0 = stop on errors
	s32	fsamp;			// The desired sample rate.
	s32	hold_secs;		// Apply the settings and hold it for # seconds.
	s32	hold_reg_dump;	// Generate a detailed register dump after each hold.
	s32	index;			// device index
	s32	minute_limit;	// for continuous testing
	s32	plus_minus;		// show configurations within +-x s/s of -fsamp.
	int	qty;			// Number of devices detected.
	s32	range;			// Go from Fsamp min to max.
	s32	range_begin;	// Begin range at # S/S.
	s32	range_end;		// End range at # S/S.
	s32	save;			// Save scan data to disk?
	s32	test_limit;		// for continuous testing

	int	fd;				// File descriptor for device to access.

	// Device Settings

	s32	xcvr;			// Transceiver selection

} args_t;



// prototypes *****************************************************************

int	perform_tests(const args_t* args);



#endif
