// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AO16/16AO16_Linux_2.x.x.x_DN/samples/aout/main.h $
// $Rev: 56210 $
// $Date: 2025-02-06 13:30:01 -0600 (Thu, 06 Feb 2025) $

// 16AO16: Sample Application: header file

#ifndef	__MAIN_H__
#define	__MAIN_H__

#include <ctype.h>
#include <errno.h>
#include <limits.h>
#include <math.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/timeb.h>

#include "16ao16_main.h"



// macros *********************************************************************

#define	DATA_FILE				"data.txt"
#define	LOG_FILE				"log.txt"
#define	SIZEOF_ARRAY(a)			(sizeof((a)) / sizeof((a)[0]))

#define	D12						(0x1 << 12)
#define	D13						(0x1 << 13)
#define	D14						(0x1 << 14)
#define	D15						(0x1 << 15)



// data types *****************************************************************

typedef struct
{
	// Application Settings

	s32	chan_qty;		// Generate output on # channels.
	s32	continuous;		// > 0 = ignore errors, < 0 = stop on errors
	s32	decimal;		// Save the data in decimal format?
	s32	empty_qty;		// Stop if the buffer runs empty # times (required -ml).
	s32	indefinate;		// Write data without limit until there is a problem.
	s32	index;			// device index
	s32	log_prefill;	// Log the prefill activity?
	s32	log_qty;		// Stop after logging # entries (requires -ml).
	s32	minute_limit;	// for continuous testing
	s32	minutes;		// Output data for this long.
	s32	monitor;		// Monitor and log timing and performance.
	int	qty;			// Number of devices detected.
	s32	reg_dump;		// When us_stop or empty_qty kick in, generate a register dump.
	s32	save;			// Save the pattern data to a file.
	s32	save_force;		// Force save even if there are errors.
	s32	scan_limit;		// Limit output to # scans per write call
	s32	seconds;		// Output data for this long.
	s32	test_limit;		// for continuous testing
	s32	us_stop;		// Stop of write take # us or longer

	int	fd;				// File descriptor for device to access.

	// Device Settings

	s32	fsamp;
	s32	io_mode;
} args_t;



// prototypes *****************************************************************

FILE*	file_close(FILE* file);
FILE*	file_create(const char* name);
int		file_eof(FILE* file, int* eof);
FILE*	file_open(const char* name);
long	file_read_line(FILE* file, char* dst, size_t size);
int		file_seek(FILE* file, long pos, int wence);
long	file_tell(FILE* file);
long	file_write_str(FILE* file, const char* src);

int		perform_tests(const args_t* args);



#endif
