// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/utils/write_bdo.c $
// $Rev: 45183 $
// $Date: 2019-07-01 16:58:19 -0500 (Mon, 01 Jul 2019) $

// 16AISS2AO2A2M: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aiss2ao2a2m_write_bdo_util
*
*	Purpose:
*
*		Implement a visual wrapper around the device write Buffered Digital Out stream call.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the board to access. Ignore if < 0.
*
*		verbose	0: errors only, !0: all output
*
*		src		The source for the data to write.
*
*		bytes	The voume of data to write.
*
*	Returned:
*
*		>= 0	The volume of data written.
*		< 0		The negative of the number of errors seen.
*
******************************************************************************/

int aiss2ao2a2m_write_bdo_util(int fd, int index, int verbose, const void* src, size_t bytes)
{
	int	ret;

	if (verbose)
		gsc_label_index("Writing BDO", index);

	ret	= aiss2ao2a2m_write_bdo(fd, src, bytes);

	if (verbose == 0)
	{
	}
	else if (ret >= 0)
	{
		printf("PASS  (%d bytes)\n", ret);
	}
	else
	{
		printf("FAIL <---\n");
	}

	return(ret);
}


