// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/utils/wait_status.c $
// $Rev: 43419 $
// $Date: 2018-08-24 17:33:36 -0500 (Fri, 24 Aug 2018) $

// 16AISS2AO2A2M: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aiss2ao2a2m_wait_status
*
*	Purpose:
*
*		Provide a visual wrapper for the AISS2AO2A2M_IOCTL_WAIT_STATUS service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the board to access. Ignore if < 0.
*
*		verbose	0: errors only, !0: all output
*
*		wait	The criteria to utilize.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int aiss2ao2a2m_wait_status(int fd, int index, int verbose, gsc_wait_t* wait)
{
	int	errs;
	int	ret;

	if (verbose)
		gsc_label_index("Wait Status", index);

	if (wait)
	{
		ret		= aiss2ao2a2m_ioctl(fd, AISS2AO2A2M_IOCTL_WAIT_STATUS, wait);
		errs	= ret ? 1 : 0;

		if (verbose)
		{
			printf(	"%s  (%ld matching wait%s)\n",
					errs ? "FAIL <---" : "PASS",
					(long) wait->count,
					(wait->count == 1) ? "" : "s");
		}
	}
	else
	{
		errs	= 1;

		if (verbose)
			printf(	"FAIL <---  (NULL pointer)\n");
	}

	return(errs);
}


