// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/utils/reg_write.c $
// $Rev: 43419 $
// $Date: 2018-08-24 17:33:36 -0500 (Fri, 24 Aug 2018) $

// 16AISS2AO2A2M: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aiss2ao2a2m_reg_write
*
*	Purpose:
*
*		Provide a visual wrapper for the AISS2AO2A2M_IOCTL_REG_WRITE service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		reg		The register to access.
*
*		set		This is the value to apply.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int aiss2ao2a2m_reg_write(int fd, int index, int verbose, u32 reg, u32 set)
{
	gsc_reg_t	arg;
	int			errs;
	int			ret;
	const char*	name;

	if (verbose)
		gsc_label_index("Register Write", index);

	arg.reg		= reg;
	arg.value	= set;
	arg.mask	= 0;	// unused here
	ret			= aiss2ao2a2m_ioctl(fd, AISS2AO2A2M_IOCTL_REG_WRITE, &arg);
	errs		= ret ? 1 : 0;

	if (verbose)
	{
		name	= aiss2ao2a2m_reg_get_name(reg);
		printf(	"%s  (val 0x%08lX, %s)\n",
				errs ? "FAIL <---" : "PASS",
				(unsigned long) arg.value,
				name ? name : "UNKNOWN");
	}

	return(errs);
}


