// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/utils/reg.c $
// $Rev: 43419 $
// $Date: 2018-08-24 17:33:36 -0500 (Fri, 24 Aug 2018) $

// 16AISS2AO2A2M: Utilities: source file

#include "main.h"



// #defines *******************************************************************

#define	_GSC_REG(a)				"GSC " #a, AISS2AO2A2M_GSC_##a, 0, 0
#define	SHOW_FIELD(b,e,eof,n,d)	gsc_reg_field_show(width + 10,WIDTH,value,(b),(e),(eof),(n),(d))
#define	WIDTH					24
#define	SIZEOF_ARRAY(a)			(sizeof((a)) / sizeof((a)[0]))



//*****************************************************************************
static int _bcr_detail(int fd, int supported, u32 value, int width)
{
	static const char*	aim[]	=
	{
		"Differential",
		"Single-Ended",
		"Zero Selftest",
		"Vref Selftest",
		"Output Channel 0 Loopback",
		"Output Channel 1 Loopback",
		"RESERVED",
		"RESERVED"
	};

	static const char*	range[]	=
	{
		"+-2.5 Volts",
		"+-5 Volts",
		"+-10 Volts",
		"RESERVED"
	};

	static const char*	clear[]		= { "Clear",			"Set"			};
	static const char*	disabled[]	= { "Disabled",			"Enabled"		};
	static const char*	fail[]		= { "Fail",				"Pass"			};
	static const char*	idle[]		= { "Idle",				"Active"		};
	static const char*	no[]		= { "No",				"Yes"			};
	static const char*	regs[]		= { "Registers",		"Buffered"		};
	static const char*	seq[]		= { "Sequential",		"Simultaneous"	};
	static const char*	target[]	= { "Target",			"Initiator"		};
	static const char*	twos[]		= { "Twos Compliment",	"Offset Binary"	};

	SHOW_FIELD( 2,  0, 1, aim,		"Input Mode"		);
	SHOW_FIELD( 3,  3, 1, idle,		"AI Autocal"		);
	SHOW_FIELD( 5,  4, 1, range,	"AI Chan 0 Range"	);
	SHOW_FIELD( 7,  6, 1, range,	"AI Chan 1 Range"	);
	SHOW_FIELD( 8,  8, 1, idle,		"AI SW Clock"		);
	SHOW_FIELD( 9,  9, 1, disabled,	"AI Bursting"		);
	SHOW_FIELD(10, 10, 1, idle,		"AI Burst"			);
	SHOW_FIELD(11, 11, 1, idle,		"AI SW Trigger"		);
	SHOW_FIELD(12, 12, 1, disabled,	"AI Buffer"			);
	SHOW_FIELD(13, 13, 1, idle,		"AI Buffer Clear"	);
	SHOW_FIELD(14, 14, 1, clear,	"AI Threshold"		);
	SHOW_FIELD(15, 15, 1, no,		"AI Overflow"		);
	SHOW_FIELD(17, 16, 1, range,	"Output Range"		);
	SHOW_FIELD(18, 18, 1, seq,		"AO Timing"			);
	SHOW_FIELD(19, 19, 1, regs,		"AO Mode"			);
	SHOW_FIELD(20, 20, 1, idle,		"AO SW Clock"		);
	SHOW_FIELD(21, 21, 1, target,	"Trigger Mode"		);
	SHOW_FIELD(22, 22, 1, disabled,	"Rate-C Generator"	);
	SHOW_FIELD(23, 23, 1, no,		"AI Underflow"		);
	SHOW_FIELD(24, 24, 1, target,	"AI Clock Mode"		);
	SHOW_FIELD(25, 25, 1, twos,		"Data Format"		);
	SHOW_FIELD(26, 26, 1, disabled,	"Rate-A Generator"	);
	SHOW_FIELD(27, 27, 1, disabled,	"Rate-B Generator"	);
	SHOW_FIELD(28, 28, 1, idle,		"Autocal"			);
	SHOW_FIELD(29, 29, 1, fail,		"AutoCal Status"	);
	SHOW_FIELD(30, 30, 1, no,		"DMDMA Swap"		);
	SHOW_FIELD(31, 31, 1, idle,		"Initialize"		);
	return(0);
}



//*****************************************************************************
static int _diopr_detail(int fd, int supported, u32 value, int width)
{
	static const char*	dir[]	= { "Input",	"Output"	};

	SHOW_FIELD( 7,  0, 1, NULL,	"Bits 0-7"		);
	SHOW_FIELD( 8,  8, 1, dir,	"Direction"		);
	SHOW_FIELD(31,  9, 1, NULL,	"Reserved"		);
	return(0);
}



//*****************************************************************************
static int _aocr_detail(int fd, int supported, u32 value, int width)
{
	SHOW_FIELD(15,  0, 1, NULL,	"Data"		);
	SHOW_FIELD(31, 16, 1, NULL,	"Reserved"	);
	return(0);
}



//*****************************************************************************
static int _aibr_detail(int fd, int supported, u32 value, int width)
{
	static const char*	no[]	= { "No",	"Yes"	};

	SHOW_FIELD(15,  0, 1, NULL,	"Data"				);
	SHOW_FIELD(16, 16, 1, no,	"1st Channel Tag"	);
	SHOW_FIELD(17, 17, 1, no,	"Enf Of Burst"		);
	SHOW_FIELD(31, 18, 1, NULL,	"Reserved"			);
	return(0);
}



//*****************************************************************************
static int _rgr_detail(int fd, int supported, u32 value, int width)
{
	SHOW_FIELD(23,  0, 1, NULL,	"Ndiv"		);
	SHOW_FIELD(31, 24, 1, NULL,	"Reserved"	);
	return(0);
}



//*****************************************************************************
static int _icr_detail(int fd, int supported, u32 value, int width)
{
	static const char*	disable[]	= { "Disabled",	"Enabled"	};

	SHOW_FIELD(23,  0, 1, NULL,		"Burst Block Size"	);
	SHOW_FIELD(24, 24, 1, disable,	"AI 0 Enable"		);
	SHOW_FIELD(25, 25, 1, disable,	"AI 1 Enable"		);
	SHOW_FIELD(31, 26, 1, NULL,	"Reserved"	);
	return(0);
}



//*****************************************************************************
static int _bsr_detail(int fd, int supported, u32 value, int width)
{
	SHOW_FIELD(21,  0, 1, NULL,	"Buffer Size"	);
	SHOW_FIELD(31, 23, 1, NULL,	"Reserved"		);
	return(0);
}



//*****************************************************************************
static int _btr_detail(int fd, int supported, u32 value, int width)
{
	static const char*	clear[]	= { "Clear (qty <=)",	"Set (qty >)"	};

	SHOW_FIELD(21,  0, 1, NULL,		"Buffer Threshold"	);
	SHOW_FIELD(23, 22, 1, NULL,		"Reserved"			);
	SHOW_FIELD(24, 24, 1, clear,	"Threshold Flag"	);
	SHOW_FIELD(31, 25, 1, NULL,		"Reserved"			);
	return(0);
}



//*****************************************************************************
static int _psr_detail(int fd, int supported, u32 value, int width)
{
	static const char*	clear[]		= { "Clear",	"Set"		};
	static const char*	negate[]	= { "Negated",	"Asserted"	};

	SHOW_FIELD( 0,  0, 1, clear,	"Autocal Completed"		);
	SHOW_FIELD( 1,  1, 1, clear,	"AI Threshold H-L"		);
	SHOW_FIELD( 2,  2, 1, clear,	"AI Threshold L-H"		);
	SHOW_FIELD( 3,  3, 1, clear,	"AI Buffer Fault"		);
	SHOW_FIELD( 4,  4, 1, clear,	"AI Burst Start (L-H)"	);
	SHOW_FIELD( 5,  5, 1, clear,	"AI Burst Stop (H-L)"	);
	SHOW_FIELD( 6,  6, 1, clear,	"BDO Threshold H-L"		);
	SHOW_FIELD( 7,  7, 1, clear,	"BDO Threshold L-H"		);
	SHOW_FIELD( 8,  8, 1, clear,	"DIO 0 L-H"				);
	SHOW_FIELD( 9,  9, 1, clear,	"AO Threshold H-L"		);
	SHOW_FIELD(10, 10, 1, clear,	"AO Threshold L-H"		);
	SHOW_FIELD(11, 11, 1, clear,	"AO Load Ready H-L"		);
	SHOW_FIELD(12, 12, 1, clear,	"AO Load Ready L-H"		);
	SHOW_FIELD(13, 13, 1, clear,	"AO Burst Ready"		);
	SHOW_FIELD(14, 14, 1, clear,	"AO Buffer Fault"		);
	SHOW_FIELD(15, 15, 1, NULL,		"Reserved"				);
	SHOW_FIELD(16, 16, 1, negate,	"Autocal Completed"		);
	SHOW_FIELD(17, 17, 1, negate,	"AI Threshold H-L"		);
	SHOW_FIELD(18, 18, 1, negate,	"AI Threshold L-H"		);
	SHOW_FIELD(19, 19, 1, negate,	"AI Buffer Fault"		);
	SHOW_FIELD(20, 20, 1, negate,	"AI Burst Start (L-H)"	);
	SHOW_FIELD(21, 21, 1, negate,	"AI Burst Stop (H-L)"	);
	SHOW_FIELD(22, 22, 1, negate,	"BDO Threshold H-L"		);
	SHOW_FIELD(23, 23, 1, negate,	"BDO Threshold L-H"		);
	SHOW_FIELD(24, 24, 1, negate,	"DIO 0 L-H"				);
	SHOW_FIELD(25, 25, 1, negate,	"AO Threshold H-L"		);
	SHOW_FIELD(26, 26, 1, negate,	"AO Threshold L-H"		);
	SHOW_FIELD(27, 27, 1, negate,	"AO Load Ready H-L"		);
	SHOW_FIELD(28, 28, 1, negate,	"AO Load Ready L-H"		);
	SHOW_FIELD(29, 29, 1, negate,	"AO Burst Ready"		);
	SHOW_FIELD(30, 30, 1, negate,	"AO Buffer Fault"		);
	SHOW_FIELD(31, 31, 1, NULL,		"Reserved"				);

	return(0);
}



//*****************************************************************************
static int _acfgr_detail(int fd, int supported, u32 value, int width)
{
	static const char*	osc[]	=
	{
		"40.320MHz",
		"RESERVED",
		"RESERVED",
		"RESERVED"
	};

	static const char*	ai[]	= { "2",	"1"	};
	static const char*	ao[]	= { "2",	"0"	};

	u32	field;

	SHOW_FIELD(11,  0, 0, NULL,	"Firmware Revision"	);
	field	= GSC_FIELD_DECODE(value, 11, 0);
	printf("%03lX\n", (long) field);

	SHOW_FIELD(15, 12, 1, NULL,	"Reserved"			);
	SHOW_FIELD(16, 16, 1, ai,	"AI Channels"		);
	SHOW_FIELD(17, 17, 1, ao,	"AO Channels"		);
	SHOW_FIELD(19, 18, 1, osc,	"Master Clock"		);
	SHOW_FIELD(31, 20, 1, NULL,	"Reserved"			);
	return(0);
}



//*****************************************************************************
static int _boor_detail(int fd, int supported, u32 value, int width)
{
	static const char*	ao_clk[]	= { "Cable AO Clock",	"Rate-C Generator"	};
	static const char*	clear[]		= { "Clear",			"Set"				};
	static const char*	disabled[]	= { "Disabled",			"Enabled"			};
	static const char*	idle[]		= { "Idle",				"Active"			};
	static const char*	no[]		= { "No",				"Yes"				};
	static const char*	open[]		= { "Open",				"Circular"			};

	SHOW_FIELD( 0,  0, 1, disabled,	"AO Channel 0"			);
	SHOW_FIELD( 1,  1, 1, disabled,	"AO Channel 1"			);
	SHOW_FIELD( 3,  2, 1, NULL,		"Reserved"				);
	SHOW_FIELD( 4,  4, 1, ao_clk,	"AO Clock Src"			);
	SHOW_FIELD( 5,  5, 1, disabled,	"AO Clocking"			);
	SHOW_FIELD( 6,  6, 1, no,		"AO Clock Ready"		);
	SHOW_FIELD( 7,  7, 1, idle,		"AO SW Clock"			);
	SHOW_FIELD( 8,  8, 1, open,		"AO Buffer Mode"		);
	SHOW_FIELD( 9,  9, 1, idle,		"AO Load Request"		);
	SHOW_FIELD(10, 10, 1, no,		"AO Load Ready"			);
	SHOW_FIELD(11, 11, 1, idle,		"AO Buffer Clear"		);
	SHOW_FIELD(12, 12, 1, no,		"AO Buffer Empty"		);
	SHOW_FIELD(13, 13, 1, clear,	"AO Threshold Status"	);
	SHOW_FIELD(14, 14, 1, disabled,	"AO Buffer"				);
	SHOW_FIELD(15, 15, 1, no,		"AO Buffer Full"		);
	SHOW_FIELD(16, 16, 1, no,		"AO Buffer Overflow"	);
	SHOW_FIELD(17, 17, 1, no,		"AO Frame Overflow"		);
	SHOW_FIELD(18, 18, 1, no,		"Burst Ready"			);
	SHOW_FIELD(19, 19, 1, disabled,	"AO Bursting"			);
	SHOW_FIELD(20, 20, 1, idle,		"AO SW Trigger"			);
	SHOW_FIELD(21, 21, 1, disabled,	"AO/AI Sync"			);
	SHOW_FIELD(31, 22, 1, NULL,		"Reserved"				);
	return(0);
}



//*****************************************************************************
static int _aobr_detail(int fd, int supported, u32 value, int width)
{
	static const char*	no[]	= { "No",	"Yes"	};

	SHOW_FIELD(15,  0, 1, NULL,		"Data"		);
	SHOW_FIELD(16, 16, 1, no,		"EOF Flag"	);
	SHOW_FIELD(31, 17, 1, NULL,		"Reserved"	);
	return(0);
}



//*****************************************************************************
static int _bdobsr_detail(int fd, int supported, u32 value, int width)
{
	SHOW_FIELD(17,  0, 1, NULL,		"Fill Level"	);
	SHOW_FIELD(31, 18, 1, NULL,		"Reserved"		);
	return(0);
}



//*****************************************************************************
static int _bdobcr_detail(int fd, int supported, u32 value, int width)
{
	static const char*	bdo_mode[]	= { "Buffered",				"Register (Unbufferred)"	};
	static const char*	bdo_src[]	= { "BDO Rate Generator",	"Cable Clock I/O"			};
	static const char*	clear[]		= { "Clear",				"Set"						};
	static const char*	disabled[]	= { "Disabled",				"Enabled"					};
	static const char*	idle[]		= { "Idle",					"Active"					};
	static const char*	no[]		= { "No",					"Yes"						};

	SHOW_FIELD(19,  0, 1, NULL,		"Do Threshold"			);
	SHOW_FIELD(20, 20, 1, idle,		"BDO Buffer Clear"		);
	SHOW_FIELD(21, 21, 1, disabled,	"BDO Buffer Enable"		);
	SHOW_FIELD(22, 22, 1, disabled,	"BDO Buffer Clocking"	);
	SHOW_FIELD(23, 23, 1, idle,		"BDO SW Clock"			);
	SHOW_FIELD(24, 24, 1, clear,	"BDO Threshold Status"	);
	SHOW_FIELD(25, 25, 1, bdo_src,	"BDO Clock Source"		);
	SHOW_FIELD(26, 26, 1, disabled,	"BDO Rate Generator"	);
	SHOW_FIELD(27, 27, 1, bdo_mode,	"BDO Mode"				);
	SHOW_FIELD(28, 28, 1, no,		"BDO Buffer Underflow"	);
	SHOW_FIELD(29, 29, 1, no,		"BDO Buffer Overflow"	);
	SHOW_FIELD(31, 30, 1, NULL,		"Reserved"				);
	return(0);
}



//*****************************************************************************
static int _bdobr_detail(int fd, int supported, u32 value, int width)
{
	SHOW_FIELD( 7, 0, 1, NULL,	"D0-D7"		);
	SHOW_FIELD(31, 8, 1, NULL,	"Reserved"	);
	return(0);
}



//*****************************************************************************
static int _acr_detail(int fd, int supported, u32 value, int width)
{
	static const char*	normal[]	= { "Normal Bahavior",	"Output Low"	};

	SHOW_FIELD( 0, 0, 1, normal,	"Cable Input Clock"		);
	SHOW_FIELD( 1, 1, 1, normal,	"Cable Trigger"			);
	SHOW_FIELD( 2, 2, 1, normal,	"Cable Output Clock"	);
	SHOW_FIELD(31, 3, 1, NULL,		"Reserved"	);
	return(0);
}



// variables ******************************************************************

static gsc_reg_def_t	_gsc[]	=
{
	{ _GSC_REG(BCR),	0,	_bcr_detail,	"Board Control Register"					},
	{ _GSC_REG(DIOPR),	0,	_diopr_detail,	"Digital I/O Port Register"					},
	{ _GSC_REG(AOC0R),	0,	_aocr_detail,	"Anlog Output Channel 0 Register"			},
	{ _GSC_REG(AOC1R),	0,	_aocr_detail,	"Anlog Output Channel 1 Register"			},
	{ _GSC_REG(AIBR),	0,	_aibr_detail,	"Analog Input Buffer Register"				},
	{ _GSC_REG(RAGR),	0,	_rgr_detail,	"Rate-A Generator Register"					},
	{ _GSC_REG(RBGR),	0,	_rgr_detail,	"Rate-B Generator Register"					},
	{ _GSC_REG(ICR),	0,	_icr_detail,	"Input Configuration Register"				},
	{ _GSC_REG(IBSR),	0,	_bsr_detail,	"Input Buffer Size Register"				},
	{ _GSC_REG(IBTR),	0,	_btr_detail,	"Input Buffer Threshold Register"			},
	{ _GSC_REG(PSR),	0,	_psr_detail,	"Primary Status Register"					},
	{ _GSC_REG(ACFGR),	0,	_acfgr_detail,	"Assymbly Configuration Register"			},
	{ _GSC_REG(AVR),	0,	NULL,			"Autocal Values Register"					},
	{ _GSC_REG(BOOR),	0,	_boor_detail,	"Buffered Output Operations Register"		},
	{ _GSC_REG(OBTR),	0,	_btr_detail,	"Output Buffer Threshold Register"			},
	{ _GSC_REG(OBSR),	0,	_bsr_detail,	"Output Buffer Size Register"				},
	{ _GSC_REG(AOBR),	0,	_aobr_detail,	"Analog Output Buffer Register"				},
	{ _GSC_REG(RCGR),	0,	_rgr_detail,	"Rate-C Generator Register"					},
	{ _GSC_REG(BDOBSR),	0,	_bdobsr_detail,	"BDO Buffer Size Register"					},
	{ _GSC_REG(BDOBCR),	0,	_bdobcr_detail,	"BDO Buffer Control Register"				},
	{ _GSC_REG(BDOBR),	0,	_bdobr_detail,	"BDO Buffer Register"						},
	{ _GSC_REG(BDORGR),	0,	_rgr_detail,	"BDO Rate Generator Register"				},
	{ _GSC_REG(ACR),	0,	_acr_detail,	"Ancillary Control Register"				},
	{ NULL, 0, 0, 0,	0,	NULL,			NULL										}
};



//*****************************************************************************
static const gsc_reg_def_t* _find_reg(u32 reg, const gsc_reg_def_t* list)
{
	const gsc_reg_def_t*	def	= NULL;
	int						i;

	for (i = 0; list[i].name; i++)
	{
		if (reg == list[i].reg)
		{
			def	= &list[i];
			break;
		}
	}

	return(def);
}



/******************************************************************************
*
*	Function:	aiss2ao2a2m_reg_get_def_id
*
*	Purpose:
*
*		Retrieve the register definition structure given the register id.
*
*	Arguments:
*
*		reg		The id of the register to access.
*
*	Returned:
*
*		NULL	The register id wasn't found.
*		else	A pointer to the register definition.
*
******************************************************************************/

const gsc_reg_def_t* aiss2ao2a2m_reg_get_def_id(u32 reg)
{
	const gsc_reg_def_t*	def;

	def	= _find_reg(reg, _gsc);
	return(def);
}



/******************************************************************************
*
*	Function:	aiss2ao2a2m_reg_get_def_index
*
*	Purpose:
*
*		Retrieve the register definition structure based on an index.
*
*	Arguments:
*
*		index	The index of the register to access.
*
*	Returned:
*
*		NULL	The index doesn't correspond to a known register.
*		else	A pointer to the register definition.
*
******************************************************************************/

const gsc_reg_def_t* aiss2ao2a2m_reg_get_def_index(int index)
{
	const gsc_reg_def_t*	def;

	if (index < 0)
		def	= NULL;
	else if (index >= (SIZEOF_ARRAY(_gsc) - 1))
		def	= NULL;
	else
		def	= &_gsc[index];

	return(def);
}



/******************************************************************************
*
*	Function:	aiss2ao2a2m_reg_get_desc
*
*	Purpose:
*
*		Retrieve the description of the specified register.
*
*	Arguments:
*
*		reg		The register whose description is desired.
*
*	Returned:
*
*		!NULL	The register's name.
*
******************************************************************************/

const char* aiss2ao2a2m_reg_get_desc(u32 reg)
{
	const gsc_reg_def_t*	def;
	const char*				desc;

	def	= _find_reg(reg, _gsc);

	if (def)
		desc	= def->desc;
	else
		desc	= "UNKNOWN";

	return(desc);
}



/******************************************************************************
*
*	Function:	aiss2ao2a2m_reg_get_name
*
*	Purpose:
*
*		Retrieve the name of the specified register.
*
*	Arguments:
*
*		reg		The register whose name is desired.
*
*	Returned:
*
*		!NULL	The register's name.
*
******************************************************************************/

const char* aiss2ao2a2m_reg_get_name(u32 reg)
{
	const gsc_reg_def_t*	def;
	const char*				name;

	def	= _find_reg(reg, _gsc);

	if (def)
		name	= def->name;
	else
		name	= "UNKNOWN";

	return(name);
}



/******************************************************************************
*
*	Function:	aiss2ao2a2m_reg_list
*
*	Purpose:
*
*		List the GSC registers and their values.
*
*	Arguments:
*
*		fd		The handle to access the device.
*
*		detail	List the register details?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int aiss2ao2a2m_reg_list(int fd, int detail)
{
	int	errs;

	errs	= gsc_reg_list(fd, _gsc, detail, aiss2ao2a2m_reg_read);
	return(errs);
}


