// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/utils/read_ai.c $
// $Rev: 45183 $
// $Date: 2019-07-01 16:58:19 -0500 (Mon, 01 Jul 2019) $

// 16AISS2AO2A2M: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aiss2ao2a2m_read_ai_util
*
*	Purpose:
*
*		Implement a visual wrapper around the device read call.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	0: errors only, !0: all output
*
*		dst		The data read is placed here.
*
*		bytes	The voume of data to read.
*
*	Returned:
*
*		>= 0	The volume of data read.
*		< 0		The negative of the number of errors seen.
*
******************************************************************************/

int aiss2ao2a2m_read_ai_util(int fd, int index, int verbose, void* dst, size_t bytes)
{
	int	ret;

	if (verbose)
		gsc_label_index("Reading", index);

	ret	= aiss2ao2a2m_read_ai(fd, dst, bytes);

	if (verbose == 0)
	{
	}
	else if (ret >= 0)
	{
		printf("PASS  (%d bytes)\n", ret);
	}
	else
	{
		printf("FAIL <---  (requested %ld bytes, ret = %ld)\n", (long) bytes, (long) ret);
	}

	return(ret);
}


