// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/utils/rate_a_gen_ndiv.c $
// $Rev: 43419 $
// $Date: 2018-08-24 17:33:36 -0500 (Fri, 24 Aug 2018) $

// 16AISS2AO2A2M: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aiss2ao2a2m_rate_a_gen_ndiv
*
*	Purpose:
*
*		Provide a visual wrapper for the AISS2AO2A2M_IOCTL_RATE_A_GEN_NDIV service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the board to access. Ignore if < 0.
*
*		verbose	0: errors only, !0: all output
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int aiss2ao2a2m_rate_a_gen_ndiv(int fd, int index, int verbose, s32 set, s32* get)
{
	int	errs;
	s32	ret;

	if (verbose)
		gsc_label_index("Rate-A Ndiv", index);

	ret		= aiss2ao2a2m_ioctl(fd, AISS2AO2A2M_IOCTL_RATE_A_GEN_NDIV, &set);
	errs	= ret ? 1 : 0;

	if (verbose)
		printf("%s  (%ld)\n", errs ? "FAIL <---" : "PASS", (long) set);

	if (get)
		get[0]	= set;

	return(errs);
}


