// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/utils/query.c $
// $Rev: 43419 $
// $Date: 2018-08-24 17:33:36 -0500 (Fri, 24 Aug 2018) $

// 16AISS2AO2A2M: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aiss2ao2a2m_query
*
*	Purpose:
*
*		Provide a visual wrapper for the AISS2AO2A2M_IOCTL_QUERY service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the board to access. Ignore if < 0.
*
*		verbose	0: errors only, !0: all output
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int aiss2ao2a2m_query(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs	= 0;
	const char*	ptr;
	s32			query	= set;
	int			ret;
	s32			tmp;

	switch (query)
	{
		default:

			errs	= 1;
			ptr		= buf;
			printf(buf, "Query Error (#%ld)", (long) query);
			break;

		case AISS2AO2A2M_QUERY_AI_CHANS_MAX:	ptr = "AI Channels Max";	break;
		case AISS2AO2A2M_QUERY_AI_CHANS_QTY:	ptr = "AI Channels";		break;
		case AISS2AO2A2M_QUERY_AI_FIFO_SIZE:	ptr	= "AI FIFO Size";		break;
		case AISS2AO2A2M_QUERY_AI_FSAMP_MAX:	ptr	= "AI Fsamp Max";		break;
		case AISS2AO2A2M_QUERY_AI_FSAMP_MIN:	ptr	= "AI Fsamp Min";		break;
		case AISS2AO2A2M_QUERY_AI_NDIV_MAX:		ptr = "AI Ndiv Max";		break;
		case AISS2AO2A2M_QUERY_AI_NDIV_MIN:		ptr = "AI Ndiv Min";		break;
		case AISS2AO2A2M_QUERY_AO_CHANS_MAX:	ptr = "AO Channels Max";	break;
		case AISS2AO2A2M_QUERY_AO_CHANS_QTY:	ptr = "AO Channels";		break;
		case AISS2AO2A2M_QUERY_AO_FIFO_SIZE:	ptr	= "AO FIFO Size";		break;
		case AISS2AO2A2M_QUERY_AO_FSAMP_MAX:	ptr	= "AO Fsamp Max";		break;
		case AISS2AO2A2M_QUERY_AO_FSAMP_MIN:	ptr	= "AO Fsamp Min";		break;
		case AISS2AO2A2M_QUERY_AO_NDIV_MAX:		ptr = "AO Ndiv Max";		break;
		case AISS2AO2A2M_QUERY_AO_NDIV_MIN:		ptr = "AO Ndiv Min";		break;
		case AISS2AO2A2M_QUERY_AUTOCAL_MS:		ptr	= "Auto-Cal Period";	break;
		case AISS2AO2A2M_QUERY_BDO_FIFO_SIZE:	ptr	= "BDO FIFO Size";		break;
		case AISS2AO2A2M_QUERY_BDO_FSAMP_MAX:	ptr	= "BDO Fsamp Max";		break;
		case AISS2AO2A2M_QUERY_BDO_FSAMP_MIN:	ptr	= "BDO Fsamp Min";		break;
		case AISS2AO2A2M_QUERY_BDO_NDIV_MAX:	ptr = "BDO Ndiv Max";		break;
		case AISS2AO2A2M_QUERY_BDO_NDIV_MIN:	ptr = "BDO Ndiv Min";		break;
		case AISS2AO2A2M_QUERY_COUNT:			ptr	= "Query Options";		break;
		case AISS2AO2A2M_QUERY_DEVICE_TYPE:		ptr	= "Device Type";		break;
		case AISS2AO2A2M_QUERY_INITIALIZE_MS:	ptr	= "Initialize Period";	break;
		case AISS2AO2A2M_QUERY_MASTER_CLOCK:	ptr	= "Master Clock";		break;
		case AISS2AO2A2M_QUERY_RATE_GEN_QTY:	ptr	= "Rate Generators";	break;
	}

	if (verbose)
		gsc_label_index(ptr, index);

	ret		= aiss2ao2a2m_ioctl(fd, AISS2AO2A2M_IOCTL_QUERY, &set);
	errs	= ret ? 1 : errs;

	switch (query)
	{
		default:

			errs	= 1;

		case AISS2AO2A2M_QUERY_AI_NDIV_MAX:
		case AISS2AO2A2M_QUERY_AI_NDIV_MIN:
		case AISS2AO2A2M_QUERY_AO_NDIV_MAX:
		case AISS2AO2A2M_QUERY_AO_NDIV_MIN:
		case AISS2AO2A2M_QUERY_BDO_NDIV_MAX:
		case AISS2AO2A2M_QUERY_BDO_NDIV_MIN:
		case AISS2AO2A2M_QUERY_COUNT:
		case AISS2AO2A2M_QUERY_RATE_GEN_QTY:

			gsc_label_long_comma_buf(set, buf);
			break;

		case AISS2AO2A2M_QUERY_AI_CHANS_MAX:
		case AISS2AO2A2M_QUERY_AI_CHANS_QTY:
		case AISS2AO2A2M_QUERY_AO_CHANS_MAX:
		case AISS2AO2A2M_QUERY_AO_CHANS_QTY:

			gsc_label_long_comma_buf(set, buf);
			sprintf(buf + strlen(buf), " Channel%s", (set == 1) ? "" : "s");
			break;

		case AISS2AO2A2M_QUERY_MASTER_CLOCK:

			gsc_label_long_comma_buf(set, buf);
			strcat(buf, " Hz");
			break;

		case AISS2AO2A2M_QUERY_AUTOCAL_MS:
		case AISS2AO2A2M_QUERY_INITIALIZE_MS:

			gsc_label_long_comma_buf(set, buf);
			strcat(buf, " ms");
			break;

		case AISS2AO2A2M_QUERY_AI_FSAMP_MAX:
		case AISS2AO2A2M_QUERY_AI_FSAMP_MIN:
		case AISS2AO2A2M_QUERY_AO_FSAMP_MAX:
		case AISS2AO2A2M_QUERY_AO_FSAMP_MIN:
		case AISS2AO2A2M_QUERY_BDO_FSAMP_MAX:
		case AISS2AO2A2M_QUERY_BDO_FSAMP_MIN:

			gsc_label_long_comma_buf(set, buf);
			strcat(buf, " S/S");
			break;

		case AISS2AO2A2M_QUERY_AI_FIFO_SIZE:
		case AISS2AO2A2M_QUERY_AO_FIFO_SIZE:
		case AISS2AO2A2M_QUERY_BDO_FIFO_SIZE:

			ptr	= "";
			tmp	= set;

			if ((tmp) && ((tmp % 1024) == 0))
			{
				ptr	= "K";
				tmp	/= 1024;
			}

			if ((tmp) && ((tmp % 1024) == 0))
			{
				ptr	= "M";
				tmp	/= 1024;
			}

			gsc_label_long_comma_buf(tmp, buf);
			strcat(buf, ptr);
			strcat(buf, " Words");
			break;

		case AISS2AO2A2M_QUERY_DEVICE_TYPE:

			if (set == GSC_DEV_TYPE_16AISS2AO2A2M)
			{
				strcpy(buf, "16AISS2AO2A2M");
			}
			else
			{
				errs	= 1;
				sprintf(buf, "INVALID: %ld", (long) set);
			}

			break;
	}

	if (verbose)
	{
		if (errs)
			printf("FAIL <---  (%s)\n", buf);
		else
			printf("%s\n", buf);
	}

	if (get)
		get[0]	= set;

	return(errs);
}


