// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/utils/ioctl.c $
// $Rev: 45184 $
// $Date: 2019-07-01 16:59:04 -0500 (Mon, 01 Jul 2019) $

// 16AISS2AO2A2M: Utilities: source file

#include "main.h"



/*****************************************************************************
*
*	Function:	aiss2ao2a2m_ioctl_util
*
*	Purpose:
*
*		Implement a visual wrapper around the device IOCTL call.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		request	The IOCTL service to request.
*
*		arg		The argument for the IOCTL service.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
*****************************************************************************/

int aiss2ao2a2m_ioctl_util(int fd, int index, int verbose, int request, void *arg)
{
	int	errs;
	int	ret;

	if (verbose)
		gsc_label_index("IOCTL", index);

	ret		= aiss2ao2a2m_ioctl(fd, request, arg);
	errs	= ret ? 1 : 0;

	if (verbose)
	{
		printf(	"%s  (#%d)\n",
				errs ? "FAIL <---" : "PASS",
				(int) OS_IOCTL_INDEX_DECODE(request));
	}

	return(errs);
}


