// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/utils/config_bdo.c $
// $Rev: 43419 $
// $Date: 2018-08-24 17:33:36 -0500 (Fri, 24 Aug 2018) $

// 16AISS2AO2A2M: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aiss2ao2a2m_config_bdo
*
*	Purpose:
*
*		Configure the given board's digital streaming output feature.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the board to access. Ignore if < 0.
*
*		verbose	Work verbosely?
*
*		fsamp	This is the desired Fsamp rate, of -1 to use the default.
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int aiss2ao2a2m_config_bdo(int fd, int index, int verbose, s32 fsamp)
{
	int	errs	= 0;
	s32	ndiv;

	if (verbose)
	{
		gsc_label_index("BDO Config.", index);
		printf("\n");
		gsc_label_level_inc();
	}

	errs	+= aiss2ao2a2m_initialize			(fd, index, verbose);

	errs	+= aiss2ao2a2m_bdo_io_mode			(fd, index, verbose, GSC_IO_MODE_PIO,						NULL);
	errs	+= aiss2ao2a2m_bdo_io_overflow		(fd, index, verbose, AISS2AO2A2M_BDO_IO_OVERFLOW_CHECK,		NULL);
	errs	+= aiss2ao2a2m_bdo_io_timeout		(fd, index, verbose, 30,									NULL);
	errs	+= aiss2ao2a2m_bdo_io_underflow		(fd, index, verbose, AISS2AO2A2M_BDO_IO_UNDERFLOW_IGNORE,	NULL);

	errs	+= aiss2ao2a2m_bdo_access_mode		(fd, index, verbose, AISS2AO2A2M_BDO_ACCESS_MODE_FIFO,		NULL);
	errs	+= aiss2ao2a2m_bdo_buf_enable		(fd, index, verbose, AISS2AO2A2M_BDO_BUF_ENABLE_YES,		NULL);
	errs	+= aiss2ao2a2m_fsamp_bdo_compute	(fd, index, verbose, fsamp, &ndiv,							NULL);
	errs	+= aiss2ao2a2m_bdo_thresh_lvl		(fd, index, verbose, 0xFFFF,								NULL);
	errs	+= aiss2ao2a2m_bdo_clock_source		(fd, index, verbose, AISS2AO2A2M_BDO_CLOCK_SOURCE_INT,		NULL);
	errs	+= aiss2ao2a2m_bdo_clock_enable		(fd, index, verbose, AISS2AO2A2M_BDO_CLOCK_ENABLE_YES,		NULL);
	errs	+= aiss2ao2a2m_bdo_rate_gen_ndiv	(fd, index, verbose, ndiv,									NULL);
	errs	+= aiss2ao2a2m_bdo_rate_gen_enable	(fd, index, verbose, AISS2AO2A2M_BDO_RATE_GEN_ENABLE_YES,	NULL);

	errs	+= aiss2ao2a2m_bdo_buf_clear		(fd, index, verbose);
	errs	+= aiss2ao2a2m_bdo_buf_overflow		(fd, index, verbose, AISS2AO2A2M_BDO_BUF_OVERFLOW_CLEAR,	NULL);
	errs	+= aiss2ao2a2m_bdo_buf_underflow	(fd, index, verbose, AISS2AO2A2M_BDO_BUF_UNDERFLOW_CLEAR,	NULL);

	if (verbose)
		gsc_label_level_dec();

	return(errs);
}


