// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/utils/config_ao.c $
// $Rev: 43419 $
// $Date: 2018-08-24 17:33:36 -0500 (Fri, 24 Aug 2018) $

// 16AISS2AO2A2M: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aiss2ao2a2m_config_ao
*
*	Purpose:
*
*		Configure the given board's analog streaming output feature.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the board to access. Ignore if < 0.
*
*		verbose	Work verbosely?
*
*		fsamp	This is the desired Fsamp rate, of -1 to use the default.
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int aiss2ao2a2m_config_ao(int fd, int index, int verbose, s32 fsamp)
{
	s32		chans	= 0;
	int		errs	= 0;
	s32		ndiv	= 0;

	if (verbose)
	{
		gsc_label_index("Analog Output Config.", index);
		printf("\n");
		gsc_label_level_inc();
	}

	errs	+= aiss2ao2a2m_query				(fd, -1, 0, AISS2AO2A2M_QUERY_AO_CHANS_QTY,					&chans);

	errs	+= aiss2ao2a2m_initialize			(fd, index, verbose);

	errs	+= aiss2ao2a2m_ao_io_mode			(fd, index, verbose, GSC_IO_MODE_PIO,						NULL);
	errs	+= aiss2ao2a2m_ao_io_overflow		(fd, index, verbose, AISS2AO2A2M_AO_IO_OVERFLOW_CHECK,		NULL);
	errs	+= aiss2ao2a2m_ao_io_timeout		(fd, index, verbose, 30,									NULL);

	errs	+= aiss2ao2a2m_ao_chan_sel			(fd, index, verbose, 0x3 >> (2 - chans),					NULL);
	errs	+= aiss2ao2a2m_ao_access_mode		(fd, index, verbose, AISS2AO2A2M_AO_ACCESS_MODE_FIFO,		NULL);
	errs	+= aiss2ao2a2m_ao_buf_mode			(fd, index, verbose, AISS2AO2A2M_AO_BUF_MODE_OPEN,			NULL);
	errs	+= aiss2ao2a2m_ao_burst_enable		(fd, index, verbose, AISS2AO2A2M_AO_BURST_ENABLE_NO,		NULL);
	errs	+= aiss2ao2a2m_ao_clock_source		(fd, index, verbose, AISS2AO2A2M_AO_CLOCK_SOURCE_INT,		NULL);
	errs	+= aiss2ao2a2m_ao_output_mode		(fd, index, verbose, AISS2AO2A2M_AO_OUTPUT_MODE_SIMUL,		NULL);
	errs	+= aiss2ao2a2m_ao_range				(fd, index, verbose, AISS2AO2A2M_AO_RANGE_10V,				NULL);
	errs	+= aiss2ao2a2m_ao_thresh_lvl		(fd, index, verbose, 0xFFFFF,								NULL);
	errs	+= aiss2ao2a2m_cbl_out_clk_io		(fd, index, verbose, AISS2AO2A2M_CBL_OUT_CLK_IO_FUNC,		NULL);
	errs	+= aiss2ao2a2m_irq_enable			(fd, index, verbose, 0,										NULL);
	errs	+= aiss2ao2a2m_data_format			(fd, index, verbose, AISS2AO2A2M_DATA_FORMAT_OFF_BIN,		NULL);
	errs	+= aiss2ao2a2m_fsamp_ao_compute		(fd, index, verbose, fsamp, &ndiv,							NULL);
	errs	+= aiss2ao2a2m_rate_c_gen_ndiv		(fd, index, verbose, ndiv,									NULL);
	errs	+= aiss2ao2a2m_rate_c_gen_enable	(fd, index, verbose, AISS2AO2A2M_RATE_C_GEN_ENABLE_YES,		NULL);
	errs	+= aiss2ao2a2m_ao_clock_enable		(fd, index, verbose, AISS2AO2A2M_AO_CLOCK_ENABLE_YES,		NULL);
	errs	+= aiss2ao2a2m_ao_enable			(fd, index, verbose, AISS2AO2A2M_AO_ENABLE_YES,				NULL);
	errs	+= aiss2ao2a2m_fsamp_ao_report_all	(fd, index, verbose, &fsamp);

	errs	+= aiss2ao2a2m_autocal_all			(fd, index, verbose);
	errs	+= aiss2ao2a2m_ao_buf_clear			(fd, index, verbose);
	errs	+= aiss2ao2a2m_ao_buf_over_data		(fd, index, verbose, AISS2AO2A2M_AO_BUF_OVER_DATA_CLEAR,	NULL);
	errs	+= aiss2ao2a2m_ao_buf_over_frame	(fd, index, verbose, AISS2AO2A2M_AO_BUF_OVER_FRAME_CLEAR,	NULL);

	if (verbose)
		gsc_label_level_dec();

	return(errs);
}


