// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/utils/config_ai.c $
// $Rev: 43419 $
// $Date: 2018-08-24 17:33:36 -0500 (Fri, 24 Aug 2018) $

// 16AISS2AO2A2M: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aiss2ao2a2m_config_ai
*
*	Purpose:
*
*		Configure the given board's analog streaming input feature.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the board to access. Ignore if < 0.
*
*		verbose	Work verbosely?
*
*		fsamp	This is the desired Fsamp rate, of -1 to use the default.
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int aiss2ao2a2m_config_ai(int fd, int index, int verbose, s32 fsamp)
{
	s32		chans	= 0;
	int		errs	= 0;
	s32		ndiv	= 0;

	if (verbose)
	{
		gsc_label_index("Analog Input Config.", index);
		printf("\n");
		gsc_label_level_inc();
	}

	errs	+= aiss2ao2a2m_query				(fd, -1, 0, AISS2AO2A2M_QUERY_AI_CHANS_QTY,					&chans);

	errs	+= aiss2ao2a2m_initialize			(fd, index, verbose);
	errs	+= aiss2ao2a2m_ai_io_mode			(fd, index, verbose, GSC_IO_MODE_PIO,						NULL);
	errs	+= aiss2ao2a2m_ai_io_overflow		(fd, index, verbose, AISS2AO2A2M_AI_IO_OVERFLOW_CHECK,		NULL);
	errs	+= aiss2ao2a2m_ai_io_timeout		(fd, index, verbose, 30,									NULL);
	errs	+= aiss2ao2a2m_ai_io_underflow		(fd, index, verbose, AISS2AO2A2M_AI_IO_UNDERFLOW_CHECK,		NULL);

	errs	+= aiss2ao2a2m_ai_chan_sel			(fd, index, verbose, 0x3 >> (2 - chans),					NULL);
	errs	+= aiss2ao2a2m_ai_chan_0_range		(fd, index, verbose, AISS2AO2A2M_AI_CHAN_0_RANGE_10V,		NULL);
	errs	+= aiss2ao2a2m_ai_chan_1_range		(fd, index, verbose, AISS2AO2A2M_AI_CHAN_1_RANGE_10V,		NULL);
	errs	+= aiss2ao2a2m_ai_mode				(fd, index, verbose, AISS2AO2A2M_AI_MODE_DIFF,				NULL);
	errs	+= aiss2ao2a2m_ai_burst_enable		(fd, index, verbose, AISS2AO2A2M_AI_BURST_ENABLE_NO,		NULL);
	errs	+= aiss2ao2a2m_ai_thresh_lvl		(fd, index, verbose, 0x3FFFF0,								NULL);
	errs	+= aiss2ao2a2m_data_format			(fd, index, verbose, AISS2AO2A2M_DATA_FORMAT_OFF_BIN,		NULL);
	errs	+= aiss2ao2a2m_irq_enable			(fd, index, verbose, 0,										NULL);
	errs	+= aiss2ao2a2m_trigger_dir			(fd, index, verbose, AISS2AO2A2M_TRIGGER_DIR_OUT,			NULL);
	errs	+= aiss2ao2a2m_cbl_io_clk_dir		(fd, index, verbose, AISS2AO2A2M_CBL_IO_CLK_DIR_OUT,		NULL);
	errs	+= aiss2ao2a2m_fsamp_ai_compute		(fd, index, verbose, fsamp, &ndiv,							NULL);
	errs	+= aiss2ao2a2m_rate_a_gen_ndiv		(fd, index, verbose, ndiv,									NULL);
	errs	+= aiss2ao2a2m_rate_a_gen_enable	(fd, index, verbose, AISS2AO2A2M_RATE_A_GEN_ENABLE_YES,		NULL);
	errs	+= aiss2ao2a2m_ai_buf_enable		(fd, index, verbose, AISS2AO2A2M_AI_BUF_ENABLE_YES,			NULL);
	errs	+= aiss2ao2a2m_fsamp_ai_report_all	(fd, index, verbose,										NULL);
	errs	+= aiss2ao2a2m_autocal_all			(fd, index, verbose);
	errs	+= aiss2ao2a2m_ai_buf_clear			(fd, index, verbose);
	errs	+= aiss2ao2a2m_ai_buf_overflow		(fd, index, verbose, AISS2AO2A2M_AI_BUF_OVERFLOW_CLEAR,		NULL);
	errs	+= aiss2ao2a2m_ai_buf_underflow		(fd, index, verbose, AISS2AO2A2M_AI_BUF_UNDERFLOW_CLEAR,	NULL);


	if (verbose)
		gsc_label_level_dec();

	return(errs);
}


