// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/utils/close.c $
// $Rev: 45184 $
// $Date: 2019-07-01 16:59:04 -0500 (Mon, 01 Jul 2019) $

// 16AISS2AO2A2M: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aiss2ao2a2m_close_util
*
*	Purpose:
*
*		Implement a visual wrapper around the device close call.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int aiss2ao2a2m_close_util(int fd, int index, int verbose)
{
	int	errs;
	int	ret;

	if (verbose)
		gsc_label_index("Close", index);

	ret		= aiss2ao2a2m_close(fd);
	errs	= ret ? 1 : 0;

	if (verbose)
		printf("%s\n", errs ? "FAIL <---" : "PASS");

	return(errs);
}


