// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/utils/bdo_io_timeout.c $
// $Rev: 43419 $
// $Date: 2018-08-24 17:33:36 -0500 (Fri, 24 Aug 2018) $

// 16AISS2AO2A2M: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aiss2ao2a2m_bdo_io_timeout
*
*	Purpose:
*
*		Provide a visual wrapper for the AISS2AO2A2M_IOCTL_BDO_IO_TIMEOUT service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the board to access. Ignore if < 0.
*
*		verbose	0: errors only, !0: all output
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int aiss2ao2a2m_bdo_io_timeout(int fd, int index, int verbose, s32 set, s32* get)
{
	int	errs;
	s32	ret;

	if (verbose)
		gsc_label_index("BDO I/O Timeout", index);

	ret		= aiss2ao2a2m_ioctl(fd, AISS2AO2A2M_IOCTL_BDO_IO_TIMEOUT, &set);
	errs	= ret ? 1 : 0;

	if (verbose == 0)
		;
	else if (set == AISS2AO2A2M_BDO_IO_TIMEOUT_INFINITE)
		printf("%s  (Never Timeout)\n", errs ? "FAIL <---" : "PASS");
	else
		printf("%s  (%ld Second%s)\n", errs ? "FAIL <---" : "PASS", (long) set, (set == 1) ? "" : "s");

	if (get)
		get[0]	= set;

	return(errs);
}


