// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/utils/bdo_io_abort.c $
// $Rev: 43419 $
// $Date: 2018-08-24 17:33:36 -0500 (Fri, 24 Aug 2018) $

// 16AISS2AO2A2M: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aiss2ao2a2m_bdo_io_abort
*
*	Purpose:
*
*		Provide a visual wrapper for the AISS2AO2A2M_IOCTL_BDO_IO_ABORT service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the board to access. Ignore if < 0.
*
*		verbose	0: errors only, !0: all output
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int aiss2ao2a2m_bdo_io_abort(int fd, int index, int verbose, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr;
	s32			ret;
	s32			set;

	if (verbose)
		gsc_label_index("BDO I/O Abort", index);

	ret		= aiss2ao2a2m_ioctl(fd, AISS2AO2A2M_IOCTL_BDO_IO_ABORT, &set);
	errs	= ret ? 1 : 0;

	switch (set)
	{
		default:

			errs	= 1;
			ptr		= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case -1:

			ptr	= "This service is not supported by this board.";
			break;

		case AISS2AO2A2M_BDO_IO_ABORT_NO:

			ptr	= "No";
			break;

		case AISS2AO2A2M_BDO_IO_ABORT_YES:

			ptr	= "Yes";
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


