// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/utils/bdo_buf_level.c $
// $Rev: 43419 $
// $Date: 2018-08-24 17:33:36 -0500 (Fri, 24 Aug 2018) $

// 16AISS2AO2A2M: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aiss2ao2a2m_bdo_buf_level
*
*	Purpose:
*
*		Provide a visual wrapper for the AISS2AO2A2M_IOCTL_BDO_BUF_LEVEL service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the board to access. Ignore if < 0.
*
*		verbose	0: errors only, !0: all output
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int aiss2ao2a2m_bdo_buf_level(int fd, int index, int verbose, s32* get)
{
	int	errs;
	s32	ret;
	s32	set;

	if (verbose)
		gsc_label_index("BDO Buffer Level", index);

	ret		= aiss2ao2a2m_ioctl(fd, AISS2AO2A2M_IOCTL_BDO_BUF_LEVEL, &set);
	errs	= ret ? 1 : 0;

	if (verbose)
		printf("%s  (%ld Byte%s)\n", errs ? "FAIL <---" : "PASS", (long) set, (set == 1) ? "" : "s");

	if (get)
		get[0]	= set;

	return(errs);
}


