// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/utils/ao_io_overflow.c $
// $Rev: 43419 $
// $Date: 2018-08-24 17:33:36 -0500 (Fri, 24 Aug 2018) $

// 16AISS2AO2A2M: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aiss2ao2a2m_ao_io_overflow
*
*	Purpose:
*
*		Provide a visual wrapper for the AISS2AO2A2M_IOCTL_AO_IO_OVERFLOW service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the board to access. Ignore if < 0.
*
*		verbose	0: errors only, !0: all output
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int aiss2ao2a2m_ao_io_overflow(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr;
	s32			ret;

	if (verbose)
		gsc_label_index("AO I/O Overflow", index);

	ret		= aiss2ao2a2m_ioctl(fd, AISS2AO2A2M_IOCTL_AO_IO_OVERFLOW, &set);
	errs	= ret ? 1 : 0;

	switch (set)
	{
		default:

			errs	= 1;
			ptr		= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case -1:

			ptr	= "This service is not supported by this board.";
			break;

		case AISS2AO2A2M_AO_IO_OVERFLOW_IGNORE:

			ptr	= "Ignore";
			break;

		case AISS2AO2A2M_AO_IO_OVERFLOW_CHECK:

			ptr	= "Check";
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


