// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/utils/ao_chan_sel.c $
// $Rev: 43419 $
// $Date: 2018-08-24 17:33:36 -0500 (Fri, 24 Aug 2018) $

// 16AISS2AO2A2M: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aiss2ao2a2m_ao_chan_sel
*
*	Purpose:
*
*		Provide a visual wrapper for the AISS2AO2A2M_IOCTL_AO_CHAN_SEL service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the board to access. Ignore if < 0.
*
*		verbose	0: errors only, !0: all output
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int aiss2ao2a2m_ao_chan_sel(int fd, int index, int verbose, s32 set, s32* get)
{
	int	errs;
	s32	ret;

	if (verbose)
		gsc_label_index("AO Chan Sel", index);

	ret		= aiss2ao2a2m_ioctl(fd, AISS2AO2A2M_IOCTL_AO_CHAN_SEL, &set);
	errs	= ret ? 1 : 0;

	if (verbose)
		printf("%s  (0x%lX)\n", errs ? "FAIL <---" : "PASS", (long) set);

	if (get)
		get[0]	= set;

	return(errs);
}


