// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/samples/txrate/bdo.c $
// $Rev: 45188 $
// $Date: 2019-07-01 17:00:50 -0500 (Mon, 01 Jul 2019) $

// 16AISS2AO2A2M: Sample Application: source file

#include "main.h"



// #defines *******************************************************************

#define	_1M	(1024L * 1024L)



// variables *******************************************************************

static u32	_tx[_1M];



//*****************************************************************************
static int _prefill_fifo(int fd)
{
	int	errs	= 0;
	s32	over;

	gsc_label("Pre-Fill Output FIFO");

	for (; errs == 0;)
	{
		errs	+= aiss2ao2a2m_reg_write(fd, -1, 0, AISS2AO2A2M_GSC_BDOBR, 0xF);
		errs	+= aiss2ao2a2m_bdo_buf_overflow(fd, -1, 0, -1, &over);

		if (over == AISS2AO2A2M_BDO_BUF_OVERFLOW_YES)
			break;
	}

	if (errs == 0)
		printf("PASS  (BDO buffer is now full.)\n");

	return(errs);
}



//*****************************************************************************
static int _rate_test(int fd, int seconds, long mb, long send)
{
	struct timeb	begin;
	int				errs		= 0;
	long			sent_acc	= 0;
	long			sent_mb		= 0;
	struct timeb	minimum;
	float			ms;
	struct timeb	now;
	long			sent;
	long long		total;

	gsc_label("Writing");

	ftime(&begin);
	minimum.time	= begin.time + seconds;
	minimum.millitm	= begin.millitm;

	for (;;)
	{
		sent	= aiss2ao2a2m_write_bdo(fd, _tx, send);

		if (sent < 0)
		{
			errs++;
			printf("FAIL <--- (write, errno %d)\n", errno);
			break;
		}

		ftime(&now);
		sent_acc	+= sent;

		if (sent_acc >= _1M)
		{
			for (; sent_acc >= _1M;)
			{
				sent_acc	-= _1M;
				sent_mb++;
			}

			if (((now.time > minimum.time) ||
				((now.time == minimum.time) && (now.millitm >= minimum.millitm))) &&
				(sent_mb >= mb))
			{
				break;
			}
		}
	}

	if (errs == 0)
	{
		long	rate;

		total	= (long long) sent_mb * _1M + sent_acc;
		ms		= ((1.0 * now.time - begin.time) * 1000)
				+ now.millitm - begin.millitm;
		rate	= (total / ms * 1000) / 4;
		printf(	"PASS  (");
		gsc_label_long_comma(total);
		printf(" Bytes, %.3f Seconds, ", ms / 1000);
		gsc_label_long_comma(rate);
		printf(" S/S)\n");
	}

	return(errs);
}



/******************************************************************************
*
*	Function:	bdo_rate_test
*
*	Purpose:
*
*		Perform a BDO Tx Rate test - measure the write throughput.
*
*	Arguments:
*
*		fd		The handle to the board.
*
*		mb		The niminum number of mega-bytes to write.
*
*		io_mode	The I/O mode to use for data retrieval.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int bdo_rate_test(int fd, long mb, int io_mode)
{
	int		errs	= 0;
	s32		fsamp	= 5000000;
	long	send	= sizeof(_tx);
	int		seconds	= 5;

	errs	+= aiss2ao2a2m_config_bdo		(fd, -1, 1, fsamp);
	errs	+= aiss2ao2a2m_bdo_io_mode		(fd, -1, 1, io_mode, NULL);
	errs	+= aiss2ao2a2m_bdo_io_overflow	(fd, -1, 1, AISS2AO2A2M_BDO_IO_OVERFLOW_IGNORE, NULL);
	errs	+= aiss2ao2a2m_bdo_clock_enable	(fd, -1, 1, AISS2AO2A2M_BDO_CLOCK_ENABLE_NO, NULL);
	errs	+= _prefill_fifo(fd);
	errs	+= aiss2ao2a2m_bdo_clock_enable	(fd, -1, 1, AISS2AO2A2M_BDO_CLOCK_ENABLE_YES, NULL);

	gsc_label ("Write Rate");
	printf("(%d second minimum, %ld MB minimum)\n", seconds, mb);
	gsc_label_level_inc();
	errs	+= _rate_test(fd, seconds, mb, send);
	gsc_label_level_dec();

	errs	+= aiss2ao2a2m_bdo_buf_overflow(fd, -1, 1, -1, NULL);
	return(errs);
}



