// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/samples/txrate/ao.c $
// $Rev: 45188 $
// $Date: 2019-07-01 17:00:50 -0500 (Mon, 01 Jul 2019) $

// 16AISS2AO2A2M: Sample Application: source file

#include "main.h"



// #defines *******************************************************************

#define	_1M	(1024L * 1024L)



// variables *******************************************************************

static u32	_tx[_1M];



//*****************************************************************************
static int _channels(int fd, s32* chans)
{
	int	errs	= 0;
	s32	get;
	s32	tmp;

	gsc_label("Output Channels");

	get			= -1;
	errs		+= aiss2ao2a2m_ao_chan_sel(fd, -1, 0, -1, &get);
	chans[0]	= 0;

	for (tmp = get; tmp ; tmp >>= 1)
	{
		if (tmp & 0x1L)
			chans[0]++;
	}

	printf(	"%ld Channel%s  (0x%lX)\n",
			(long) chans[0],
			(chans[0] == 1) ? "" : "s",
			(long) get);
	return(errs);
}



//*****************************************************************************
static int _prefill_fifo(int fd)
{
	int	errs	= 0;
	s32	sts;

	gsc_label("Pre-Fill Output FIFO");

	for (; errs == 0;)
	{
		errs	+= aiss2ao2a2m_reg_write(fd, -1, 0, AISS2AO2A2M_GSC_AOBR, 0x8000);
		errs	+= aiss2ao2a2m_ao_buf_status(fd, -1, 0, &sts);

		if (sts == AISS2AO2A2M_AO_BUF_STATUS_FULL)
			break;
	}

	if (errs == 0)
		printf("PASS  (Analog Output buffer is now full.)\n");

	return(errs);
}



//*****************************************************************************
static int _rate_test(int fd, int seconds, long mb, long send, s32 chans)
{
	struct timeb	begin;
	int				errs		= 0;
	long			sent_acc	= 0;
	long			sent_mb		= 0;
	struct timeb	minimum;
	float			ms;
	struct timeb	now;
	long			sent;
	long long		total;

	gsc_label("Writing");

	ftime(&begin);
	minimum.time	= begin.time + seconds;
	minimum.millitm	= begin.millitm;

	for (;;)
	{
		sent	= aiss2ao2a2m_write_ao(fd, _tx, send);

		if (sent < 0)
		{
			errs++;
			printf("FAIL <--- (write, errno %d)\n", errno);
			break;
		}

		ftime(&now);
		sent_acc	+= sent;

		if (sent_acc >= _1M)
		{
			for (; sent_acc >= _1M;)
			{
				sent_acc	-= _1M;
				sent_mb++;
			}

			if (((now.time > minimum.time) ||
				((now.time == minimum.time) && (now.millitm >= minimum.millitm))) &&
				(sent_mb >= mb))
			{
				break;
			}
		}
	}

	if (errs == 0)
	{
		long	rate;

		total	= (long long) sent_mb * _1M + sent_acc;
		ms		= ((1.0 * now.time - begin.time) * 1000)
				+ now.millitm - begin.millitm;
		rate	= (total / ms * 1000) / 4;
		printf(	"PASS  (");
		gsc_label_long_comma(total);
		printf(" Bytes, %.3f Seconds, ", ms / 1000);
		gsc_label_long_comma(rate);
		printf(" S/S)\n");
	}

	return(errs);
}



/******************************************************************************
*
*	Function:	ao_rate_test
*
*	Purpose:
*
*		Perform an Analog Tx Rate test - measure the write throughput.
*
*	Arguments:
*
*		fd		The handle to the board.
*
*		mb		The niminum number of mega-bytes to write.
*
*		io_mode	The I/O mode to use for data retrieval.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int ao_rate_test(int fd, long mb, int io_mode)
{
	s32		chans;
	int		errs	= 0;
	s32		fsamp	= 2000000;
	long	send	= sizeof(_tx);
	int		seconds	= 5;

	errs	+= aiss2ao2a2m_config_ao		(fd, -1, 1, fsamp);
	errs	+= aiss2ao2a2m_ao_io_mode		(fd, -1, 1, io_mode, NULL);
	errs	+= _channels(fd, &chans);
	errs	+= aiss2ao2a2m_ao_io_overflow	(fd, -1, 1, AISS2AO2A2M_AO_IO_OVERFLOW_IGNORE, NULL);
	errs	+= aiss2ao2a2m_ao_clock_enable	(fd, -1, 1, AISS2AO2A2M_AO_CLOCK_ENABLE_NO, NULL);
	errs	+= _prefill_fifo(fd);
	errs	+= aiss2ao2a2m_ao_clock_enable	(fd, -1, 1, AISS2AO2A2M_AO_CLOCK_ENABLE_YES, NULL);

	gsc_label ("Write Rate");
	printf("(%d second minimum, %ld MB minimum)\n", seconds, mb);
	gsc_label_level_inc();
	errs	+= _rate_test(fd, seconds, mb, send, chans);
	gsc_label_level_dec();

	errs	+= aiss2ao2a2m_ao_buf_over_data	(fd, -1, 1, -1, NULL);
	errs	+= aiss2ao2a2m_ao_buf_over_frame(fd, -1, 1, -1, NULL);
	return(errs);
}



