// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/samples/savedata/savedata.c $
// $Rev: 45177 $
// $Date: 2019-07-01 14:15:18 -0500 (Mon, 01 Jul 2019) $

// 16AISS2AO2A2M: Sample Application: source file

#include "main.h"



// #defines *******************************************************************

#define	_1M		(1024L * 1024L)



// variables *******************************************************************

static	u32	_buffer[_1M];



//*****************************************************************************
static int _channels(int fd, s32* chans)
{
	int	errs	= 0;
	s32	get;
	int	i;
	int	ret;

	gsc_label("Input Channels");

	get			= -1;
	ret			= aiss2ao2a2m_ioctl(fd, AISS2AO2A2M_IOCTL_AI_CHAN_SEL,	&get);
	errs		+= ret ? 1 : 0;
	chans[0]	= 0;

	for (i = 0; i < 31; i++)
	{
		if (get & (0x1L << i))
			chans[0]++;
	}

	printf(	"%ld Channel%s  (0x%lX)\n",
			(long) chans[0],
			(chans[0] == 1) ? "" : "s",
			(long) get);
	return(errs);
}



//*****************************************************************************
static int _read_data(int fd)
{
	int		errs	= 0;
	long	get		= sizeof(_buffer);
	int		got;

	gsc_label("Reading");
	got	= aiss2ao2a2m_read_ai(fd, _buffer, get);

	if (got < 0)
	{
		errs	= 1;
	}
	else if (got != get)
	{
		errs	= 1;
		printf(	"FAIL <---  (got %ld bytes, requested %ld)\n",
				(long) got,
				(long) get);
	}
	else
	{
		errs	= 0;
		printf(	"PASS  (%ld samples)\n",
				(long) get / 4);
	}

	return(errs);
}



//*****************************************************************************
static int _save_data(int fd, int chan, int errs)
{
	FILE*		file;
	int			i;
	long		l;
	const char*	name	= "data.txt";
	long		samples	= sizeof(_buffer) / 4;

	gsc_label("Saving");

	for (;;)
	{
		if (errs)
		{
			printf("SKIPPED  (errors)\n");
			errs	= 0;
			break;
		}

		file	= fopen(name, "w+b");

		if (file == NULL)
		{
			printf("FAIL <---  (unable to create %s)\n", name);
			errs	= 1;
			break;
		}

		for (l = 0; l < samples; l++)
		{
			if ((l) && (_buffer[l] & 0x10000))
			{
				i	= fprintf(file, "\r\n");

				if (i != 2)
				{
					printf("FAIL <---  (fprintf() failure to %s)\n", name);;
					errs	= 1;
					break;
				}
			}

			i	= fprintf(file, "  %08lX", (long) _buffer[l]);

			if (i != 10)
			{
				printf("FAIL <---  (fprintf() failure to %s)\n", name);
				errs	= 1;
				break;
			}
		}

		fclose(file);

		if (errs == 0)
			printf("PASS  (%s)\n", name);

		break;
	}

	return(errs);
}



//*****************************************************************************
int save_data(int fd, s32 io_mode)
{
	s32	chans	= 32;
	int	errs	= 0;

	gsc_label("Capture & Save");
	printf("\n");
	gsc_label_level_inc();

	errs	+= aiss2ao2a2m_config_ai		(fd, -1, 1, 30000);
	errs	+= aiss2ao2a2m_ai_io_mode		(fd, -1, 1, io_mode, NULL);
	errs	+= _channels(fd, &chans);
	errs	+= aiss2ao2a2m_ai_buf_clear		(fd, -1, 1);
	errs	+= _read_data(fd);
	errs	+= aiss2ao2a2m_ai_buf_overflow	(fd, -1, 1, -1, NULL);
	errs	+= aiss2ao2a2m_ai_buf_underflow	(fd, -1, 1, -1, NULL);
	errs	+= _save_data(fd, chans, errs);

	gsc_label_level_dec();
	return(errs);
}



