// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/samples/regs/main_menu.c $
// $Rev: 45175 $
// $Date: 2019-07-01 14:10:05 -0500 (Mon, 01 Jul 2019) $

// 16AISS2AO2A2M: Sample Application: source file

#include "main.h"



/*****************************************************************************
*
*	Function:	_dump_everything
*
*	Purpose:
*
*		Dump all available data to the screen.
*
*	Arguments:
*
*		fd		The handle for the board to access.
*
*	Returned:
*
*		None.
*
*****************************************************************************/

static void _dump_everything(int fd)
{
	os_id_host();
	printf("\n");
	os_id_driver(aiss2ao2a2m_open, aiss2ao2a2m_read_ai, aiss2ao2a2m_close);
	printf("\n");
	aiss2ao2a2m_id_device(fd, -1, 1);
	printf("\n");
	gsc_reg_plx9056_list_pci(fd, aiss2ao2a2m_reg_read);
	printf("\n");
	gsc_reg_plx9056_list_plx(fd, aiss2ao2a2m_reg_read);
	printf("\n");
	aiss2ao2a2m_reg_list(fd, 1);
}



/*****************************************************************************
*
*	Function:	_dump_gsc
*
*	Purpose:
*
*		Dump the GSC registers.
*
*	Arguments:
*
*		fd		The handle for the board to access.
*
*	Returned:
*
*		None.
*
*****************************************************************************/

static void _dump_gsc(int fd)
{
	aiss2ao2a2m_reg_list(fd, 0);
}



/*****************************************************************************
*
*	Function:	_dump_gsc_detail
*
*	Purpose:
*
*		Dump the GSC register details.
*
*	Arguments:
*
*		fd		The handle for the board to access.
*
*	Returned:
*
*		None.
*
*****************************************************************************/

static void _dump_gsc_detail(int fd)
{
	aiss2ao2a2m_reg_list(fd, 1);
}



/*****************************************************************************
*
*	Function:	_dump_pci
*
*	Purpose:
*
*		Dump the PCI registers.
*
*	Arguments:
*
*		fd		The handle for the board to access.
*
*	Returned:
*
*		None.
*
*****************************************************************************/

static void _dump_pci(int fd)
{
	gsc_reg_plx9056_list_pci(fd, aiss2ao2a2m_reg_read);
}



/*****************************************************************************
*
*	Function:	_dump_plx
*
*	Purpose:
*
*		Dump the PLX registers.
*
*	Arguments:
*
*		fd		The handle for the board to access.
*
*	Returned:
*
*		None.
*
*****************************************************************************/

static void _dump_plx(int fd)
{
	gsc_reg_plx9056_list_plx(fd, aiss2ao2a2m_reg_read);
}



/*****************************************************************************
*
*	Function:	_id_board
*
*	Purpose:
*
*		Identify the device being accessed.
*
*	Arguments:
*
*		fd		The handle for the board to access.
*
*	Returned:
*
*		None.
*
*****************************************************************************/

static void _id_board(int fd)
{
	aiss2ao2a2m_id_device(fd, -1, 1);
}



/*****************************************************************************
*
*	Function:	_id_driver
*
*	Purpose:
*
*		Identify the device driver.
*
*	Arguments:
*
*		fd		The handle for the board to access.
*
*	Returned:
*
*		None.
*
*****************************************************************************/

static void _id_driver(int fd)
{
	os_id_driver(aiss2ao2a2m_open, aiss2ao2a2m_read_ai, aiss2ao2a2m_close);
}



/*****************************************************************************
*
*	Function:	_id_host
*
*	Purpose:
*
*		Identify the host OS.
*
*	Arguments:
*
*		fd		The handle for the board to access.
*
*	Returned:
*
*		None.
*
*****************************************************************************/

static void _id_host(int fd)
{
	os_id_host();
}



/*****************************************************************************
*
*	Function:	main_menu
*
*	Purpose:
*
*		Present the main menu.
*
*	Arguments:
*
*		fd		The handle for the board to access.
*
*	Returned:
*
*		None.
*
*****************************************************************************/

void main_menu(int fd)
{
	static const menu_item_t	list[]	=
	{
		// name								desc	func
		{ "Dump Everything",				NULL,	_dump_everything	},
		{ "Host OS Identification",			NULL,	_id_host			},
		{ "Driver Identification",			NULL,	_id_driver			},
		{ "Board Identification",			NULL,	_id_board			},
		{ "PCI Register Dump",				NULL,	_dump_pci			},
		{ "PLX Register Dump",				NULL,	_dump_plx			},
		{ "GSC Register Dump",				NULL,	_dump_gsc			},
		{ "GSC Register Detail Dump",		NULL,	_dump_gsc_detail	},
		{ "Edit GSC Register By Name",		NULL,	reg_mod_by_name		},
		{ "Edit GSC Register By Offset",	NULL,	reg_mod_by_offset	},
		{ NULL,								NULL,	NULL				}
	};

	static const menu_t	menu	=
	{
		/* title	*/	"Main Menu",
		/* list		*/	list
	};

	printf("\n\n");
	printf("Register Access Application\n");
	menu_call(fd, &menu);
}



