// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/samples/irq/service.c $
// $Rev: 45174 $
// $Date: 2019-07-01 14:09:45 -0500 (Mon, 01 Jul 2019) $

// 16AISS2AO2A2M: Sample Application: source file

#include "main.h"



// #defines *******************************************************************

#define	_15_SEC		(15L * 1000L)



// data types *****************************************************************

struct _wait_src_t
{
	int			(*function)(int fd);
	gsc_wait_t	wait;
};



// variables ******************************************************************

static	os_sem_t	_sem_enter;
static	os_sem_t	_sem_exit;
static	gsc_wait_t	_wait_dst;
static	int			_wait_fd;



//*****************************************************************************
static int _wait_thread(void* arg)
{
	int	ret;

	os_sem_unlock(&_sem_enter);
	ret	= aiss2ao2a2m_ioctl(_wait_fd, AISS2AO2A2M_IOCTL_WAIT_EVENT, &_wait_dst);

	if (ret)
		_wait_dst.flags	= 0xFFFFFFFF;

	os_sem_unlock(&_sem_exit);
	return(0);
}



//*****************************************************************************
static int _process_thread(int fd, const struct _wait_src_t* src)
{
	char		buf[64];
	int			errs;
	int			i;
	int			ret;
	os_thread_t	thread;
	gsc_wait_t	wait;

	errs	= aiss2ao2a2m_initialize(fd, -1, 0);

	for (;;)	// A convenience loop.
	{
		os_sem_create_qty(&_sem_enter, 1, 0);
		os_sem_create_qty(&_sem_exit, 1, 0);
		memset(&thread, 0, sizeof(thread));
		sprintf(buf, "wait event");
		_wait_dst	= src->wait;
		errs		+= os_thread_create(&thread, buf, _wait_thread, NULL);

		// Wait for the thread to become waiting.
		os_sem_lock(&_sem_enter);

		if (errs == 0)
		{
			wait	= src->wait;

			for (i = 0;; i++)
			{
				if (i >= 100)
				{
					printf(	"FAIL <---  (%d. thread failed to WAIT)\n",
							__LINE__);
					errs++;
					break;
				}

				ret	= aiss2ao2a2m_ioctl(_wait_fd, AISS2AO2A2M_IOCTL_WAIT_STATUS, &wait);

				if (ret)
				{
					printf(	"FAIL <---  (%d. status request: ret %d)\n",
							__LINE__,
							ret);
					errs++;
					break;
				}

				if (wait.count == 0)
				{
					usleep(100000);
					continue;
				}

				if (wait.count == 1)
					break;

				errs++;
				printf(	"FAIL <---  (%d. invalid wait count: %ld)\n",
						__LINE__,
						(long) wait.count);
				break;
			}
		}

		// Initiate the respective event.
		errs	+= src->function(_wait_fd);

		if (errs)
			break;		// There was an error.

		// Wait for the resumed thread to run.
		os_sem_lock(&_sem_exit);

		for (i = 0;; i++)
		{
			if (_wait_dst.flags)
				break;

			if (i >= 100)
			{
				printf(	"FAIL <---  (%d. thread failed to resume)\n",
						__LINE__);
				errs++;
				break;
			}

			usleep(100000);
		}

		// Verify that the wait ended as expected.

		if (src->wait.flags == 0xFFFFFFFF)
			break;		// There was an error.

		if (errs)
			break;		// There was an error.

		if (src->wait.timeout_ms == _15_SEC)
		{
			if (_wait_dst.flags != GSC_WAIT_FLAG_DONE)
			{
				printf(	"FAIL <---  (%d. flag: expect 0x%lX, got 0x%lX)\n",
						__LINE__,
						(long) GSC_WAIT_FLAG_DONE,
						(long) _wait_dst.flags);
				errs++;
			}

			break;
		}

		printf("FAIL <---  (%d. INTERNAL ERROR)\n", __LINE__);
		errs++;
		break;
	}

	// Force termination, just in case of an error.
	wait.flags			= 0;
	wait.main			= 0xFFFFFFFF;
	wait.gsc			= 0xFFFFFFFF;
	wait.alt			= 0xFFFFFFFF;
	wait.io				= 0xFFFFFFFF;
	wait.timeout_ms		= 0;
	wait.count			= 0;
	ret		= aiss2ao2a2m_ioctl(_wait_fd, AISS2AO2A2M_IOCTL_WAIT_CANCEL, &wait);
	errs	+= ret ? 1 : 0;
	errs	+= os_thread_destroy(&thread);

	// Wait for the thread to end WAITing.
	wait	= src->wait;

	for (i = 0;; i++)
	{

		if (i >= 100)
		{
			errs++;
			printf("FAIL <---  (%d. WAIT failed to end)\n", __LINE__);
			break;
		}

		wait.flags			= 0;
		wait.main			= 0xFFFFFFFF;
		wait.gsc			= 0xFFFFFFFF;
		wait.alt			= 0xFFFFFFFF;
		wait.io				= 0xFFFFFFFF;
		wait.timeout_ms		= 0;
		wait.count			= 0;
		ret	= aiss2ao2a2m_ioctl(_wait_fd, AISS2AO2A2M_IOCTL_WAIT_STATUS, &wait);

		if (ret)
		{
			printf(	"FAIL <---  (%d. status request: ret %d)\n",
					__LINE__,
					ret);
			errs++;
			break;
		}

		if (wait.count == 0)
			break;

		usleep(100000);
		continue;
	}

	errs	+= aiss2ao2a2m_initialize(fd, -1, 0);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}



//*****************************************************************************
int irq_wait_test(int fd, u32 main, u32 gsc, u32 io, int (*callback)(int fd))
{
	int					errs;
	struct _wait_src_t	src;

	memset(&_wait_dst, 0, sizeof(_wait_dst));
	memset(&src, 0, sizeof(src));
	_wait_fd			= fd;
	src.function		= callback;
	src.wait.flags		= 0;
	src.wait.main		= main;
	src.wait.gsc		= gsc;
	src.wait.io			= io;
	src.wait.timeout_ms	= _15_SEC;
	src.wait.count		= 0;
	errs				= _process_thread(fd, &src);
	return(errs);
}


