// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/samples/irq/irq_main.c $
// $Rev: 45174 $
// $Date: 2019-07-01 14:09:45 -0500 (Mon, 01 Jul 2019) $

// 16AISS2AO2A2M: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _dma0_irq(int fd)
{
	u32	buf[1024];
	int	errs	= 0;
	int	ret;

	errs	+= aiss2ao2a2m_config_ai	(fd, -1, 0, 100000);
	errs	+= aiss2ao2a2m_ai_io_mode	(fd, -1, 0, GSC_IO_MODE_DMDMA, NULL);
	ret		= aiss2ao2a2m_read_ai_util	(fd, -1, 0, buf, sizeof(buf));

	if (errs)
	{
		errs	= 1;
		printf("FAIL <---  (setup failure)\n");
	}
	else if (ret <= 0)
	{
		errs	= 1;
		printf("FAIL <---  (aiss2ao2a2m_read_ai() returned %d)\n", ret);
	}

	return(errs);
}




//*****************************************************************************
static int _irq_main_dma0_test(int fd)
{
	int	errs;

	gsc_label("DMA0");
	errs	= irq_wait_test(fd, GSC_WAIT_MAIN_DMA0, 0, 0, _dma0_irq);
	return(errs);
}



//*****************************************************************************
static int _dma1_irq(int fd)
{
	u32	buf[1024];
	int	errs	= 0;
	int	ret;

	memset(buf, 0, sizeof(buf));
	errs	+= aiss2ao2a2m_config_ao		(fd, -1, 0, 100000);
	errs	+= aiss2ao2a2m_ao_io_mode		(fd, -1, 0, GSC_IO_MODE_DMDMA, NULL);
	errs	+= aiss2ao2a2m_ao_clock_enable	(fd, -1, 0, AISS2AO2A2M_AO_CLOCK_ENABLE_NO, NULL);
	ret		= aiss2ao2a2m_write_ao_util		(fd, -1, 0, buf, sizeof(buf));

	if (errs)
	{
		errs	= 1;
		printf("FAIL <---  (setup failure)\n");
	}
	else if (ret <= 0)
	{
		errs	= 1;
		printf("FAIL <---  (aiss2ao2a2m_write_ao_util() returned %d)\n", ret);
	}

	return(errs);
}




//*****************************************************************************
static int _irq_main_dma1_test(int fd)
{
	s32	chans;
	int	errs;

	gsc_label("DMA1");

	errs	= aiss2ao2a2m_query(fd, -1, 0, AISS2AO2A2M_QUERY_AO_CHANS_QTY, &chans);

	if (errs)
	{
		printf("FAIL <---  (query failure)\n");
	}
	else if (chans <= 0)
	{
		printf("SKIPPED  (no output channels on this board)\n");
	}
	else
	{
		errs	= irq_wait_test(fd, GSC_WAIT_MAIN_DMA1, 0, 0, _dma1_irq);
	}

	return(errs);
}



//*****************************************************************************
static int _pci_irq(int fd)
{
	int	errs;

	errs	= _dma0_irq(fd);
	return(errs);
}



//*****************************************************************************
static int _irq_main_pci_test(int fd)
{
	int	errs;

	gsc_label("PCI");
	errs	= irq_wait_test(fd, GSC_WAIT_MAIN_PCI, 0, 0, _pci_irq);
	return(errs);
}



//*****************************************************************************
static int _gsc_irq(int fd)
{
	int	errs;

	errs	= _dma0_irq(fd);
	return(errs);
}



//*****************************************************************************
static int _irq_main_gsc_test(int fd)
{
	int	errs;

	gsc_label("GSC");
	errs	= irq_wait_test(fd, GSC_WAIT_MAIN_GSC, 0, 0, _gsc_irq);
	return(errs);
}




//*****************************************************************************
int irq_main_test(int fd)
{
	int	errs	= 0;

	gsc_label("IRQ MAIN");
	printf("\n");
	gsc_label_level_inc();

	errs	+= _irq_main_dma0_test(fd);
	errs	+= _irq_main_dma1_test(fd);
	errs	+= _irq_main_pci_test(fd);
	errs	+= _irq_main_gsc_test(fd);

	gsc_label_level_dec();
	return(errs);
}


