// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/samples/irq/irq_gsc.c $
// $Rev: 45174 $
// $Date: 2019-07-01 14:09:45 -0500 (Mon, 01 Jul 2019) $

// 16AISS2AO2A2M: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _auto_cal_irq(int fd)
{
	int	errs	= 0;

	errs	+= aiss2ao2a2m_initialize	(fd, -1, 0);
	errs	+= aiss2ao2a2m_autocal_all	(fd, -1, 0);

	if (errs)
	{
		errs	= 1;
		printf("FAIL <---\n");
	}

	return(errs);
}



//*****************************************************************************
static int _auto_cal_test(int fd)
{
	int	errs;

	gsc_label("Auto-Calibrate");
	errs	= irq_wait_test(fd, 0, AISS2AO2A2M_WAIT_GSC_AUTO_CAL_DONE, 0, _auto_cal_irq);
	return(errs);
}



//*****************************************************************************
static int _ai_thresh_h2l_irq(int fd)
{
	int	errs	= 0;

	errs	+= aiss2ao2a2m_config_ai		(fd, -1, 0, 100000);
	os_sleep_ms(250);
	errs	+= aiss2ao2a2m_ai_thresh_lvl	(fd, -1, 0, 16, NULL);
	errs	+= aiss2ao2a2m_rate_a_gen_enable(fd, -1, 0, AISS2AO2A2M_RATE_A_GEN_ENABLE_NO, NULL);
	errs	+= aiss2ao2a2m_irq_enable		(fd, -1, 0, AISS2AO2A2M_IRQ_AI_THRESH_H2L, NULL);
	errs	+= aiss2ao2a2m_ai_buf_clear		(fd, -1, 0);
	os_sleep_ms(250);

	if (errs)
	{
		errs	= 1;
		printf("FAIL <---\n");
	}

	return(errs);
}



//*****************************************************************************
static int _ai_thresh_h2l_test(int fd)
{
	int	errs;

	gsc_label("AI Threshold High-to-Low");
	errs	= irq_wait_test(fd, 0, AISS2AO2A2M_WAIT_GSC_AI_THRESH_H2L, 0, _ai_thresh_h2l_irq);
	return(errs);
}



//*****************************************************************************
static int _ai_thresh_l2h_irq(int fd)
{
	int	errs	= 0;

	errs	+= aiss2ao2a2m_config_ai		(fd, -1, 0, 100000);
	errs	+= aiss2ao2a2m_ai_thresh_lvl	(fd, -1, 0, 16, NULL);
	errs	+= aiss2ao2a2m_rate_a_gen_enable(fd, -1, 0, AISS2AO2A2M_RATE_A_GEN_ENABLE_NO, NULL);
	errs	+= aiss2ao2a2m_ai_buf_clear		(fd, -1, 0);
	errs	+= aiss2ao2a2m_irq_enable		(fd, -1, 0, AISS2AO2A2M_IRQ_AI_THRESH_L2H, NULL);
	errs	+= aiss2ao2a2m_rate_a_gen_enable(fd, -1, 0, AISS2AO2A2M_RATE_A_GEN_ENABLE_YES, NULL);
	os_sleep_ms(250);

	if (errs)
	{
		errs	= 1;
		printf("FAIL <---\n");
	}

	return(errs);
}



//*****************************************************************************
static int _ai_thresh_l2h_test(int fd)
{
	int	errs;

	gsc_label("AI Threshold Low-to-High");
	errs	= irq_wait_test(fd, 0, AISS2AO2A2M_WAIT_GSC_AI_THRESH_L2H, 0, _ai_thresh_l2h_irq);
	return(errs);
}



//*****************************************************************************
static int _ai_fault_irq(int fd)
{
	int	errs	= 0;
	u32	reg;

	errs	+= aiss2ao2a2m_initialize		(fd, -1, 0);
	errs	+= aiss2ao2a2m_rate_a_gen_enable(fd, -1, 0, AISS2AO2A2M_RATE_A_GEN_ENABLE_NO, NULL);
	errs	+= aiss2ao2a2m_ai_buf_clear		(fd, -1, 0);
	errs	+= aiss2ao2a2m_irq_enable		(fd, -1, 0, AISS2AO2A2M_IRQ_AI_FAULT, NULL);
	errs	+= aiss2ao2a2m_reg_read			(fd, -1, 0, AISS2AO2A2M_GSC_AIBR, &reg);
	os_sleep_ms(250);

	if (errs)
	{
		errs	= 1;
		printf("FAIL <---\n");
	}

	return(errs);
}



//*****************************************************************************
static int _ai_fault_test(int fd)
{
	int	errs;

	gsc_label("AI Fault");
	errs	= irq_wait_test(fd, 0, AISS2AO2A2M_WAIT_GSC_AI_FAULT, 0, _ai_fault_irq);
	return(errs);
}



//*****************************************************************************
static int _ai_burst_start_irq(int fd)
{
	int	errs	= 0;

	errs	+= aiss2ao2a2m_config_ai		(fd, -1, 0, 100000);
	errs	+= aiss2ao2a2m_rate_b_gen_enable(fd, -1, 0, AISS2AO2A2M_RATE_B_GEN_ENABLE_NO, NULL);
	errs	+= aiss2ao2a2m_ai_burst_enable	(fd, -1, 0, AISS2AO2A2M_AI_BURST_ENABLE_YES, NULL);
	errs	+= aiss2ao2a2m_ai_burst_size	(fd, -1, 0, 1, NULL);
	errs	+= aiss2ao2a2m_irq_enable		(fd, -1, 0, AISS2AO2A2M_IRQ_AI_BURST_START, NULL);
	errs	+= aiss2ao2a2m_ai_sw_trigger	(fd, -1, 0);
	os_sleep_ms(250);

	if (errs)
	{
		errs	= 1;
		printf("FAIL <---\n");
	}

	return(errs);
}



//*****************************************************************************
static int _ai_burst_start_test(int fd)
{
	int	errs;

	gsc_label("AI Burst Start");
	errs	= irq_wait_test(fd, 0, AISS2AO2A2M_WAIT_GSC_AI_BURST_START, 0, _ai_burst_start_irq);
	return(errs);
}



//*****************************************************************************
static int _ai_burst_done_irq(int fd)
{
	int	errs	= 0;

	errs	+= aiss2ao2a2m_config_ai		(fd, -1, 0, 100000);
	errs	+= aiss2ao2a2m_rate_b_gen_enable(fd, -1, 0, AISS2AO2A2M_RATE_B_GEN_ENABLE_NO, NULL);
	errs	+= aiss2ao2a2m_ai_burst_enable	(fd, -1, 0, AISS2AO2A2M_AI_BURST_ENABLE_YES, NULL);
	errs	+= aiss2ao2a2m_ai_burst_size	(fd, -1, 0, 1, NULL);
	errs	+= aiss2ao2a2m_irq_enable		(fd, -1, 0, AISS2AO2A2M_IRQ_AI_BURST_DONE, NULL);
	errs	+= aiss2ao2a2m_ai_sw_trigger	(fd, -1, 0);
	os_sleep_ms(250);

	if (errs)
	{
		errs	= 1;
		printf("FAIL <---\n");
	}

	return(errs);
}



//*****************************************************************************
static int _ai_burst_done_test(int fd)
{
	int	errs;

	gsc_label("AI Burst Done");
	errs	= irq_wait_test(fd, 0, AISS2AO2A2M_WAIT_GSC_AI_BURST_DONE, 0, _ai_burst_done_irq);
	return(errs);
}



//*****************************************************************************
static int _bdo_thresh_h2l_irq(int fd)
{
	u32	buf[32];
	int	errs	= 0;
	int	ret;

	memset(buf, 0, sizeof(buf));
	errs	+= aiss2ao2a2m_config_bdo			(fd, -1, 0, 100000);
	errs	+= aiss2ao2a2m_bdo_thresh_lvl		(fd, -1, 0, 16, NULL);
	errs	+= aiss2ao2a2m_bdo_rate_gen_enable	(fd, -1, 0, AISS2AO2A2M_BDO_RATE_GEN_ENABLE_NO, NULL);
	ret		= aiss2ao2a2m_write_bdo_util		(fd, -1, 0, buf, sizeof(buf));
	errs	+= (ret < 0) ? 1 : 0;
	errs	+= aiss2ao2a2m_irq_enable			(fd, -1, 0, AISS2AO2A2M_IRQ_BDO_THRESH_H2L, NULL);
	errs	+= aiss2ao2a2m_bdo_buf_clear		(fd, -1, 0);
	os_sleep_ms(250);

	if (errs)
	{
		errs	= 1;
		printf("FAIL <---\n");
	}

	return(errs);
}



//*****************************************************************************
static int _bdo_thresh_h2l_test(int fd)
{
	int	errs;

	gsc_label("BDO Threshold High-to-Low");
	errs	= irq_wait_test(fd, 0, AISS2AO2A2M_WAIT_GSC_BDO_THRESH_H2L, 0, _bdo_thresh_h2l_irq);
	return(errs);
}



//*****************************************************************************
static int _bdo_thresh_l2h_irq(int fd)
{
	u32	buf[32];
	int	errs	= 0;
	int	ret;

	memset(buf, 0, sizeof(buf));
	errs	+= aiss2ao2a2m_config_bdo			(fd, -1, 0, 100000);
	errs	+= aiss2ao2a2m_bdo_thresh_lvl		(fd, -1, 0, 16, NULL);
	errs	+= aiss2ao2a2m_bdo_rate_gen_enable	(fd, -1, 0, AISS2AO2A2M_BDO_RATE_GEN_ENABLE_NO, NULL);
	errs	+= aiss2ao2a2m_irq_enable			(fd, -1, 0, AISS2AO2A2M_IRQ_BDO_THRESH_L2H, NULL);
	ret		= aiss2ao2a2m_write_bdo_util		(fd, -1, 0, buf, sizeof(buf));
	errs	+= (ret < 0) ? 1 : 0;
	os_sleep_ms(250);

	if (errs)
	{
		errs	= 1;
		printf("FAIL <---\n");
	}

	return(errs);
}



//*****************************************************************************
static int _bdo_thresh_l2h_test(int fd)
{
	int	errs;

	gsc_label("BDO Threshold Low-to-High");
	errs	= irq_wait_test(fd, 0, AISS2AO2A2M_WAIT_GSC_BDO_THRESH_L2H, 0, _bdo_thresh_l2h_irq);
	return(errs);
}



//*****************************************************************************
static int _dio_0_l2h_irq(int fd)
{
	int	errs	= 0;

	errs	+= aiss2ao2a2m_initialize	(fd, -1, 0);
	errs	+= aiss2ao2a2m_dio_dir		(fd, -1, 0, AISS2AO2A2M_DIO_DIR_OUT, NULL);
	errs	+= aiss2ao2a2m_dio_write	(fd, -1, 0, 0);
	errs	+= aiss2ao2a2m_irq_enable	(fd, -1, 0, AISS2AO2A2M_IRQ_DIO_0_L2H, NULL);
	errs	+= aiss2ao2a2m_dio_write	(fd, -1, 0, 1);
	os_sleep_ms(250);

	if (errs)
	{
		errs	= 1;
		printf("FAIL <---\n");
	}

	return(errs);
}



//*****************************************************************************
static int _dio_0_l2h_test(int fd)
{
	int	errs;

	gsc_label("DIO 0 Low-to-High");
	errs	= irq_wait_test(fd, 0, AISS2AO2A2M_WAIT_GSC_DIO_0_L2H, 0, _dio_0_l2h_irq);
	return(errs);
}



//*****************************************************************************
static int _ao_thresh_h2l_irq(int fd)
{
	u32	buf[32];
	int	errs	= 0;
	int	ret;

	memset(buf, 0, sizeof(buf));
	errs	+= aiss2ao2a2m_config_ao			(fd, -1, 0, 100000);
	errs	+= aiss2ao2a2m_ao_thresh_lvl		(fd, -1, 0, 16, NULL);
	errs	+= aiss2ao2a2m_rate_c_gen_enable	(fd, -1, 0, AISS2AO2A2M_RATE_C_GEN_ENABLE_NO, NULL);
	ret		= aiss2ao2a2m_write_ao_util			(fd, -1, 0, buf, sizeof(buf));
	errs	+= (ret < 0) ? 1 : 0;
	errs	+= aiss2ao2a2m_irq_enable			(fd, -1, 0, AISS2AO2A2M_IRQ_AO_THRESH_H2L, NULL);
	errs	+= aiss2ao2a2m_ao_buf_clear		(fd, -1, 0);
	os_sleep_ms(250);

	if (errs)
	{
		errs	= 1;
		printf("FAIL <---\n");
	}

	return(errs);
}



//*****************************************************************************
static int _ao_thresh_h2l_test(int fd)
{
	s32	chans;
	int	errs;

	gsc_label("AO Threshold High-to-Low");

	errs	= aiss2ao2a2m_query(fd, -1, 0, AISS2AO2A2M_QUERY_AO_CHANS_QTY, &chans);

	if (errs)
	{
		printf("FAIL <---  (query failure)\n");
	}
	else if (chans <= 0)
	{
		printf("SKIPPED  (no output channels on this board)\n");
	}
	else
	{
		errs	= irq_wait_test(fd, 0, AISS2AO2A2M_WAIT_GSC_AO_THRESH_H2L, 0, _ao_thresh_h2l_irq);
	}

	return(errs);
}



//*****************************************************************************
static int _ao_thresh_l2h_irq(int fd)
{
	u32	buf[32];
	int	errs	= 0;
	int	ret;

	memset(buf, 0, sizeof(buf));
	errs	+= aiss2ao2a2m_config_ao			(fd, -1, 0, 100000);
	errs	+= aiss2ao2a2m_ao_thresh_lvl		(fd, -1, 0, 16, NULL);
	errs	+= aiss2ao2a2m_rate_c_gen_enable	(fd, -1, 0, AISS2AO2A2M_RATE_C_GEN_ENABLE_NO, NULL);
	errs	+= aiss2ao2a2m_irq_enable			(fd, -1, 0, AISS2AO2A2M_IRQ_AO_THRESH_L2H, NULL);
	ret		= aiss2ao2a2m_write_ao_util			(fd, -1, 0, buf, sizeof(buf));
	errs	+= (ret < 0) ? 1 : 0;
	os_sleep_ms(250);

	if (errs)
	{
		errs	= 1;
		printf("FAIL <---\n");
	}

	return(errs);
}



//*****************************************************************************
static int _ao_thresh_l2h_test(int fd)
{
	s32	chans;
	int	errs;

	gsc_label("AO Threshold Low-to-High");

	errs	= aiss2ao2a2m_query(fd, -1, 0, AISS2AO2A2M_QUERY_AO_CHANS_QTY, &chans);

	if (errs)
	{
		printf("FAIL <---  (query failure)\n");
	}
	else if (chans <= 0)
	{
		printf("SKIPPED  (no output channels on this board)\n");
	}
	else
	{
		errs	= irq_wait_test(fd, 0, AISS2AO2A2M_WAIT_GSC_AO_THRESH_L2H, 0, _ao_thresh_l2h_irq);
	}

	return(errs);
}



//*****************************************************************************
static int _ao_load_rdy_h2l_irq(int fd)
{
	u32	data[10]	= { 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x18000 };
	int	errs		= 0;
	int	i;
	int	ret;
	s32	sts;

	errs	+= aiss2ao2a2m_config_ao			(fd, -1, 0, 5);
	errs	+= aiss2ao2a2m_ao_clock_enable		(fd, -1, 0, AISS2AO2A2M_AO_CLOCK_ENABLE_NO, NULL);
	ret		= aiss2ao2a2m_write_ao_util			(fd, -1, 0, data, sizeof(data));
	errs	+= (ret == sizeof(data)) ? 0 : 1;
	errs	+= aiss2ao2a2m_ao_buf_mode			(fd, -1, 0, AISS2AO2A2M_AO_BUF_MODE_CIRC, NULL);
	errs	+= aiss2ao2a2m_ao_buf_load_req		(fd, -1, 0);
	errs	+= aiss2ao2a2m_irq_enable			(fd, -1, 0, AISS2AO2A2M_IRQ_AO_LOAD_RDY_H2L, NULL);
	errs	+= aiss2ao2a2m_ao_clock_enable		(fd, -1, 0, AISS2AO2A2M_AO_CLOCK_ENABLE_YES, NULL);

	for (i = 0;; i++)
	{
		if (i >= 100)
		{
			errs++;
			break;
		}

		errs	+= aiss2ao2a2m_ao_buf_load_sts	(fd, -1, 0, &sts);

		if (sts == AISS2AO2A2M_AO_BUF_LOAD_STS_READY)
			break;

		os_sleep_ms(100);
	}

	for (i = 0;; i++)
	{
		if (i >= 100)
		{
			errs++;
			break;
		}

		errs	+= aiss2ao2a2m_ao_buf_load_sts	(fd, -1, 0, &sts);

		if (sts == AISS2AO2A2M_AO_BUF_LOAD_STS_BUSY)
			break;

		os_sleep_ms(100);
	}

	os_sleep_ms(250);

	if (errs)
	{
		errs	= 1;
		printf("FAIL <---\n");
	}

	return(errs);
}



//*****************************************************************************
static int _ao_load_rdy_h2l_test(int fd)
{
	s32	chans;
	int	errs;

	gsc_label("AO Load Ready High-to-Low");

	errs	= aiss2ao2a2m_query(fd, -1, 0, AISS2AO2A2M_QUERY_AO_CHANS_QTY, &chans);

	if (errs)
	{
		printf("FAIL <---  (query failure)\n");
	}
	else if (chans <= 0)
	{
		printf("SKIPPED  (no output channels on this board)\n");
	}
	else
	{
		errs	= irq_wait_test(fd, 0, AISS2AO2A2M_WAIT_GSC_AO_LOAD_RDY_H2L, 0, _ao_load_rdy_h2l_irq);
	}

	return(errs);
}



//*****************************************************************************
static int _ao_load_rdy_l2h_irq(int fd)
{
	u32	data[10]	= { 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x18000 };
	int	errs		= 0;
	int	i;
	int	ret;
	s32	sts;

	errs	+= aiss2ao2a2m_config_ao			(fd, -1, 0, 5);
	errs	+= aiss2ao2a2m_ao_clock_enable		(fd, -1, 0, AISS2AO2A2M_AO_CLOCK_ENABLE_NO, NULL);
	ret		= aiss2ao2a2m_write_ao_util			(fd, -1, 0, data, sizeof(data));
	errs	+= (ret == sizeof(data)) ? 0 : 1;
	errs	+= aiss2ao2a2m_ao_buf_mode			(fd, -1, 0, AISS2AO2A2M_AO_BUF_MODE_CIRC, NULL);
	errs	+= aiss2ao2a2m_ao_buf_load_req		(fd, -1, 0);
	errs	+= aiss2ao2a2m_irq_enable			(fd, -1, 0, AISS2AO2A2M_IRQ_AO_LOAD_RDY_L2H, NULL);
	errs	+= aiss2ao2a2m_ao_clock_enable		(fd, -1, 0, AISS2AO2A2M_AO_CLOCK_ENABLE_YES, NULL);

	for (i = 0;; i++)
	{
		if (i >= 100)
		{
			errs++;
			break;
		}

		errs	+= aiss2ao2a2m_ao_buf_load_sts	(fd, -1, 0, &sts);

		if (sts == AISS2AO2A2M_AO_BUF_LOAD_STS_READY)
			break;

		os_sleep_ms(100);
	}

	os_sleep_ms(250);

	if (errs)
	{
		errs	= 1;
		printf("FAIL <---\n");
	}

	return(errs);
}



//*****************************************************************************
static int _ao_load_rdy_l2h_test(int fd)
{
	s32	chans;
	int	errs;

	gsc_label("AO Load Ready Low-to-High");

	errs	= aiss2ao2a2m_query(fd, -1, 0, AISS2AO2A2M_QUERY_AO_CHANS_QTY, &chans);

	if (errs)
	{
		printf("FAIL <---  (query failure)\n");
	}
	else if (chans <= 0)
	{
		printf("SKIPPED  (no output channels on this board)\n");
	}
	else
	{
		errs	= irq_wait_test(fd, 0, AISS2AO2A2M_WAIT_GSC_AO_LOAD_RDY_L2H, 0, _ao_load_rdy_l2h_irq);
	}

	return(errs);
}



//*****************************************************************************
static int _ao_burst_ready_irq(int fd)
{
	u32	data[10]	= { 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x18000 };
	int	errs		= 0;
	int	ret;

	errs	+= aiss2ao2a2m_config_ao			(fd, -1, 0, 5);
	errs	+= aiss2ao2a2m_irq_enable			(fd, -1, 0, AISS2AO2A2M_IRQ_AO_BURST_READY, NULL);
	errs	+= aiss2ao2a2m_ao_burst_enable		(fd, -1, 0, AISS2AO2A2M_AO_BURST_ENABLE_YES, NULL);
	ret		= aiss2ao2a2m_write_ao_util			(fd, -1, 0, data, sizeof(data));
	errs	+= (ret == sizeof(data)) ? 0 : 1;
	ret		= aiss2ao2a2m_write_ao_util			(fd, -1, 0, data, sizeof(data));
	errs	+= (ret == sizeof(data)) ? 0 : 1;
	ret		= aiss2ao2a2m_write_ao_util			(fd, -1, 0, data, sizeof(data));
	errs	+= (ret == sizeof(data)) ? 0 : 1;
	errs	+= aiss2ao2a2m_rate_b_gen_enable	(fd, -1, 0, AISS2AO2A2M_RATE_B_GEN_ENABLE_NO, NULL);
	os_sleep_ms(250);

	if (errs)
	{
		errs	= 1;
		printf("FAIL <---\n");
	}

	return(errs);
}



//*****************************************************************************
static int _ao_burst_ready_test(int fd)
{
	s32	chans;
	int	errs;

	gsc_label("AO Burst Ready");

	errs	= aiss2ao2a2m_query(fd, -1, 0, AISS2AO2A2M_QUERY_AO_CHANS_QTY, &chans);

	if (errs)
	{
		printf("FAIL <---  (query failure)\n");
	}
	else if (chans <= 0)
	{
		printf("SKIPPED  (no output channels on this board)\n");
	}
	else
	{
		errs	= irq_wait_test(fd, 0, AISS2AO2A2M_WAIT_GSC_AO_BURST_READY, 0, _ao_burst_ready_irq);
	}

	return(errs);
}



//*****************************************************************************
static int _ao_fault_irq(int fd)
{
	u32	data[10]	= { 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x18000 };
	int	errs		= 0;
	int	ret;

	errs	+= aiss2ao2a2m_config_ao			(fd, -1, 0, 5);
	errs	+= aiss2ao2a2m_ao_clock_enable		(fd, -1, 0, AISS2AO2A2M_AO_CLOCK_ENABLE_NO, NULL);
	ret		= aiss2ao2a2m_write_ao_util			(fd, -1, 0, data, sizeof(data));
	errs	+= (ret == sizeof(data)) ? 0 : 1;
	errs	+= aiss2ao2a2m_ao_buf_mode			(fd, -1, 0, AISS2AO2A2M_AO_BUF_MODE_CIRC, NULL);
	errs	+= aiss2ao2a2m_irq_enable			(fd, -1, 0, AISS2AO2A2M_IRQ_AO_FAULT, NULL);
	errs	+= aiss2ao2a2m_ao_clock_enable		(fd, -1, 0, AISS2AO2A2M_AO_CLOCK_ENABLE_YES, NULL);
	ret		= aiss2ao2a2m_write_ao_util			(fd, -1, 0, data, sizeof(data));
	errs	+= (ret == sizeof(data)) ? 0 : 1;
	os_sleep_ms(250);

	if (errs)
	{
		errs	= 1;
		printf("FAIL <---\n");
	}

	return(errs);
}



//*****************************************************************************
static int _ao_fault_test(int fd)
{
	s32	chans;
	int	errs;

	gsc_label("AO Fault");

	errs	= aiss2ao2a2m_query(fd, -1, 0, AISS2AO2A2M_QUERY_AO_CHANS_QTY, &chans);

	if (errs)
	{
		printf("FAIL <---  (query failure)\n");
	}
	else if (chans <= 0)
	{
		printf("SKIPPED  (no output channels on this board)\n");
	}
	else
	{
		errs	= irq_wait_test(fd, 0, AISS2AO2A2M_WAIT_GSC_AO_FAULT, 0, _ao_fault_irq);
	}

	return(errs);
}



//*****************************************************************************
int irq_gsc_test(int fd)
{
	int	errs	= 0;

	gsc_label("IRQ GSC");
	printf("\n");
	gsc_label_level_inc();

	errs	+= _auto_cal_test(fd);
	errs	+= _ai_thresh_h2l_test(fd);
	errs	+= _ai_thresh_l2h_test(fd);
	errs	+= _ai_fault_test(fd);
	errs	+= _ai_burst_start_test(fd);
	errs	+= _ai_burst_done_test(fd);
	errs	+= _bdo_thresh_h2l_test(fd);
	errs	+= _bdo_thresh_l2h_test(fd);
	errs	+= _dio_0_l2h_test(fd);
	errs	+= _ao_thresh_h2l_test(fd);
	errs	+= _ao_thresh_l2h_test(fd);
	errs	+= _ao_load_rdy_h2l_test(fd);
	errs	+= _ao_load_rdy_l2h_test(fd);
	errs	+= _ao_burst_ready_test(fd);
	errs	+= _ao_fault_test(fd);

	gsc_label_level_dec();
	return(errs);
}


