// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/samples/id/id.c $
// $Rev: 43426 $
// $Date: 2018-08-24 17:36:53 -0500 (Fri, 24 Aug 2018) $

// 16AISS2AO2A2M: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _input_modes(int fd)
{
	gsc_label("Input Modes");
	printf("Differential, Single-Ended, Zero Test, +Vref Test, Chan 0/1 Loopback\n");
	return(0);
}



//*****************************************************************************
static int _voltage_ranges(int fd)
{
	gsc_label("Voltage Ranges");
	printf("+-10V, +-5V, +-2.5V\n");
	return(0);
}



//*****************************************************************************
static int _clocking_sources(int fd)
{
	gsc_label("Clocking Sources");
	printf("Rate Generator, External, Software\n");
	return(0);
}



//*****************************************************************************
static int _sampling_modes(int fd)
{
	gsc_label("AI Sampling Modes");
	printf("Continuous, Burst\n");

	gsc_label("AO Sampling Modes");
	printf("Continuous, Burst\n");

	gsc_label("AO Update Modes");
	printf("Immediate, Synchronous\n");

	gsc_label("AO Modes");
	printf("Buffered, Register\n");

	gsc_label("AO Buffer Modes");
	printf("Open, Closed (recycle)\n");

	gsc_label("BDO Modes");
	printf("Buffered, Register\n");
	return(0);
}



//*****************************************************************************
static int _digital_io(int fd)
{
	gsc_label("Digital I/O");
	printf("8 Bi-Directional Signals, 8 Bufferred/Unbufferd Outputs\n");
	return(0);
}



//*****************************************************************************
static int _id_board_acfgr(int fd)
{
	gsc_reg_def_t	list[2]	= { { NULL }, { NULL } };
	gsc_reg_def_t*	ptr;

	int	errs	= 0;

	printf("\n");
	ptr	= (gsc_reg_def_t*) aiss2ao2a2m_reg_get_def_id(AISS2AO2A2M_GSC_ACFGR);

	if (ptr)
	{
		list[0]	= ptr[0];
		errs	= gsc_reg_list(fd, list, 1, aiss2ao2a2m_reg_read);
	}
	else
	{
		errs++;
		printf(	"FAIL <---  (%d. aiss2ao2a2m_reg_get_def_id, AISS2AO2A2M_GSC_ACFGR)\n",
				__LINE__);
	}

	return(errs);
}



//*****************************************************************************
static int _register_map(int fd)
{
	int	errs	= 0;

	printf("\n");
	errs	= aiss2ao2a2m_reg_list(fd, 0);
	return(errs);
}



/******************************************************************************
*
*	Function:	id_device
*
*		Identify the device and its features.
*
*	Arguments:
*
*		fd		The handle to the board to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int id_device(int fd)
{
	int	errs	= 0;
	int	i;

	gsc_label("Board Features");
	printf("\n");

	gsc_label_level_inc();

	errs	+= _input_modes(fd);
	errs	+= _voltage_ranges(fd);
	errs	+= _clocking_sources(fd);
	errs	+= _sampling_modes(fd);
	errs	+= _digital_io(fd);

	for (i = 0; i < AISS2AO2A2M_IOCTL_QUERY_LAST; i++)
		errs	+= aiss2ao2a2m_query(fd, -1, 1, i, NULL);

	gsc_label_level_dec();

	errs	+= _id_board_acfgr(fd);
	errs	+= _register_map(fd);

	return(errs);
}


