// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/samples/fsamp/fsamp.c $
// $Rev: 45172 $
// $Date: 2019-07-01 14:09:11 -0500 (Mon, 01 Jul 2019) $

// 16AISS2AO2A2M: Sample Application: source file

#include "main.h"



// #defines *******************************************************************

#define	FILE_NAME				"fsamp.txt"



/******************************************************************************
*
*	Function:	fsamp_compute
*
*	Purpose:
*
*		Configure the board, then capture data.
*
*	Arguments:
*
*		fd		The handle for the board to access.
*
*		fsamp	The desired rate, if "range" is zero.
*
*		range	Compute the rate for the entire range of supported rates.
*
*		flags	Processing flags.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int fsamp_compute(int fd, s32 fsamp, int range, int compute, int save)
{
	int		errs	= 0;
	FILE*	file	= NULL;
	s32		max;
	s32		min;
	s32		ndiv;
	double	rate;

	gsc_label("Fsamp Computation");
	printf("\n");
	gsc_label_level_inc();

	if (range == 0)
	{
		min		= fsamp;
		max		= fsamp;
	}
	else if (compute == COMPUTE_BDO)
	{
		errs	+= aiss2ao2a2m_query(fd, -1, 0, AISS2AO2A2M_QUERY_BDO_FSAMP_MAX, &max);
		errs	+= aiss2ao2a2m_query(fd, -1, 0, AISS2AO2A2M_QUERY_BDO_FSAMP_MIN, &min);
	}
	else if (compute == COMPUTE_AO)
	{
		errs	+= aiss2ao2a2m_query(fd, -1, 0, AISS2AO2A2M_QUERY_AO_FSAMP_MAX, &max);
		errs	+= aiss2ao2a2m_query(fd, -1, 0, AISS2AO2A2M_QUERY_AO_FSAMP_MIN, &min);
	}
	else if (compute == COMPUTE_AI)
	{
		errs	+= aiss2ao2a2m_query(fd, -1, 0, AISS2AO2A2M_QUERY_AI_FSAMP_MAX, &max);
		errs	+= aiss2ao2a2m_query(fd, -1, 0, AISS2AO2A2M_QUERY_AI_FSAMP_MIN, &min);
	}

	if (save)
	{
		file	= fopen(FILE_NAME, "w+b");

		if (file == NULL)
		{
			printf("FAIL <---  (unable to create %s)\n", FILE_NAME);
			errs	= 1;
		}
		else
		{
			fprintf(file, "# 16AISS2AO2A2M Scan Rates\n");
			fprintf(file, "# Request   Produced\n");
			fprintf(file, "# ========  ==========\n");
		}
	}

	for (fsamp = min; fsamp <= max; fsamp++)
	{
		if (compute == COMPUTE_BDO)
			errs	+= aiss2ao2a2m_fsamp_bdo_compute(fd, -1, 1, fsamp, &ndiv, &rate);
		else if (compute == COMPUTE_AO)
			errs	+= aiss2ao2a2m_fsamp_ao_compute(fd, -1, 1, fsamp, &ndiv, &rate);
		else if (compute == COMPUTE_AI)
			errs	+= aiss2ao2a2m_fsamp_ai_compute(fd, -1, 1, fsamp, &ndiv, &rate);

		if (file)
			fprintf(file, "%10ld  %10.3f\n", (long) fsamp, (float) rate);
	}

	if (file)
		fclose(file);

	gsc_label_level_dec();
	return(errs);
}


