// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/samples/dout/dio.c $
// $Rev: 43424 $
// $Date: 2018-08-24 17:36:06 -0500 (Fri, 24 Aug 2018) $

// 16AISS2AO2A2M: Sample Application: source file

#include "main.h"



//*****************************************************************************
static void _bin_show(u16 data)
{
	u16	bit		= 0x8000;
	int	i;
	int	nibble;

	for (nibble = 3; nibble >= 0; nibble--)
	{
		for (i = 0; i <= 3; i++, bit /= 2)
		{
			if (bit & data)
				printf("1");
			else
				printf("0");
		}

		printf("  ");
	}
}



//*****************************************************************************
static int _dev_dio_out(int fd, u16 data)
{
	int	errs;
	int	ret;
	u32	val		= data;

	_bin_show(data);
	ret		= aiss2ao2a2m_ioctl(fd, AISS2AO2A2M_IOCTL_DIO_WRITE, &val);
	errs	= ret ? 1 : 0;
	return(errs);
}



//*****************************************************************************
static int _dev_dio_out_16(int fd, u16 data)
{
	int	errs	= 0;

	printf("    ");
	errs	+= _dev_dio_out(fd, data);
	printf("\n");
	usleep(250000L);
	return(errs);
}



/******************************************************************************
*
*	Function:	do_discrete
*
*	Purpose:
*
*		Perform a GPIO output test.
*
*	Arguments:
*
*		fd		The file descriptor for the board to access.
*
*	Returned:
*
*		>= 0	The number of errors seen.
*
******************************************************************************/

int do_discrete(int fd)
{
	int	errs	= 0;
	int	i;

	for (;;)	// A convenience loop
	{
		errs	+= aiss2ao2a2m_initialize		(fd, -1, 1);
		errs	+= aiss2ao2a2m_dio_dir			(fd, -1, 1, AISS2AO2A2M_DIO_DIR_OUT, NULL);
		errs	+= aiss2ao2a2m_bdo_access_mode	(fd, -1, 1, AISS2AO2A2M_BDO_ACCESS_MODE_REG, NULL);

		if (errs)
			break;

		printf("    BDO        DIO Out\n");
		printf("    7654 3210  7654 3210\n");
		printf("    ==== ====  ==== ====\n");

		errs	+= _dev_dio_out_16(fd, 0x0000);
		errs	+= _dev_dio_out_16(fd, 0xFFFF);
		errs	+= _dev_dio_out_16(fd, 0x0000);
		errs	+= _dev_dio_out_16(fd, 0xFFFF);
		errs	+= _dev_dio_out_16(fd, 0x0000);

		for (i = 0; i <= 15; i++)
			errs	+= _dev_dio_out_16(fd, 0x1 << i);

		errs	+= _dev_dio_out_16(fd, 0x0000);

		for (i = 15; i >= 0; i--)
			errs	+= _dev_dio_out_16(fd, 0x1 << i);

		errs	+= _dev_dio_out_16(fd, 0x0000);
		errs	+= _dev_dio_out_16(fd, 0xFFFF);
		errs	+= _dev_dio_out_16(fd, 0x0000);
		errs	+= _dev_dio_out_16(fd, 0xFFFF);
		errs	+= _dev_dio_out_16(fd, 0x0000);

		gsc_label_level_inc();
		errs	+= aiss2ao2a2m_initialize(fd, -1, 1);
		gsc_label("Status");
		printf("%s\n", errs ? "FAIL <---" : "PASS");
		gsc_label_level_dec();
		break;
	}

	return(errs);
}


