// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/samples/dout/bdo.c $
// $Rev: 45171 $
// $Date: 2019-07-01 14:08:35 -0500 (Mon, 01 Jul 2019) $

// 16AISS2AO2A2M: Sample Application: source file

#include "main.h"



// #defines *******************************************************************

#define	PATTERN_SIZE		200



// variables ******************************************************************

static struct
{
	union
	{
		struct
		{
			u32		pat_1[PATTERN_SIZE];
			u32		pat_2[PATTERN_SIZE];
			u32		pat_3[PATTERN_SIZE];
			u32		pat_4[PATTERN_SIZE];
		} init;

		u32	buf[4 * PATTERN_SIZE];
	} u;
} _data;



//*****************************************************************************
static int _init_data(void)
{
	float	f;
	int		i;
	float	pi		= 3.1415962;
	int		sh;

	gsc_label("Initializing Data");

	memset(&_data, 0, sizeof(_data));

	// Rising ramp

	for (i = 0; i < PATTERN_SIZE; i++)
	{
		f	= 7.9 / (PATTERN_SIZE - 1) * i;
		f	= floor(f);
		sh	= (int) f;
		_data.u.init.pat_1[i]	= 0x1 << sh;
	}

	// Falling ramp

	for (i = 0; i < PATTERN_SIZE; i++)
	{
		f	= 7.9 / (PATTERN_SIZE - 1) * i;
		f	= floor(f);
		sh	= (int) f;
		_data.u.init.pat_2[i]	= 0x80 >> sh;
	}

	// Square wave

	for (i = 0; i < (PATTERN_SIZE / 2); i++)
		_data.u.init.pat_3[i]	= 0x01;

	for (; i < PATTERN_SIZE; i++)
		_data.u.init.pat_3[i]	= 0x80;

	// Sine wave

	for (i = 0; i < PATTERN_SIZE; i++)
	{
		f	= 2.0 * pi * i / (PATTERN_SIZE - 1);
		f	= cos(f);
		f	= (f + 1) * 7.9 / 2;
		f	= floor(f);
		sh	= (int) f;
		_data.u.init.pat_4[i]	= 0x01 << sh;
	}

	printf("Done\n");
	return(0);
}



//*****************************************************************************
static int _write_data(int fd)
{
	int	errs		= 0;
	int	i;
	s32	lvl;
	s32	lvl_last	= 999999999;
	int	ret;
	int	size		= (int) sizeof(_data);
	int	total		= 0;

	gsc_label("Writing Data");

	for (i = 0; i < 10; i++)
	{
		ret		= aiss2ao2a2m_write_bdo(fd, &_data, size);
		errs	+= (ret == size) ? 0 : 1;
		total	+= (ret > 0) ? ret / 4 : 0;
	}

	printf("%s  (", errs ? "FAIL <---" : "PASS");
	gsc_label_long_comma(total);
	printf(" Sample%s)\n", (total == 1) ? "" : "s");

	//********************************************************

	gsc_label("Wait For Completion");
	lvl_last	= -1;

	for (i = 0; (errs == 0) && (total > 0); i++)
	{
		ret	= aiss2ao2a2m_ioctl(fd, AISS2AO2A2M_IOCTL_BDO_BUF_LEVEL, &lvl);

		if (ret)
		{
			errs	= 1;
			printf("FAIL <---  (access error)\n");
			break;
		}

		if (lvl == 0)
		{
			printf("PASS\n");
			break;
		}

		if (lvl != lvl_last)
			i	= 0;

		if (i >= 200)
		{
			errs	= 1;
			printf(	"FAIL <---  (AO FIFO didn't empty. %ld sample%s left.)\n",
					(long) lvl,
					(lvl == 1) ? "" : "s");
			break;
		}

		os_sleep_ms(50);
		lvl_last	= lvl;
	}

	return(errs);
}



/******************************************************************************
*
*	Function:	bdo_stream
*
*	Purpose:
*
*		Perform a GPIO output test.
*
*	Arguments:
*
*		fd		The file descriptor for the board to access.
*
*		io_mode	The I/O Mode to use.
*
*	Returned:
*
*		>= 0	The number of errors seen.
*
******************************************************************************/

int bdo_stream(int fd, s32 io_mode)
{
	int	errs	= 0;

	gsc_label("Streaming Output");
	printf("\n");
	gsc_label_level_inc();

	errs	+= aiss2ao2a2m_config_bdo	(fd, -1, 1, PATTERN_SIZE);
	errs	+= aiss2ao2a2m_bdo_io_mode	(fd, -1, 1, io_mode, NULL);
	errs	+= _init_data();
	errs	+= _write_data(fd);

	gsc_label("Status");
	printf("%s\n", errs ? "FAIL <---" : "PASS");

	gsc_label_level_dec();
	return(errs);
}


