// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/samples/din/dio.c $
// $Rev: 43423 $
// $Date: 2018-08-24 17:35:27 -0500 (Fri, 24 Aug 2018) $

// 16AISS2AO2A2M: Sample Application: source file

#include "main.h"



/******************************************************************************
*
*	Function:	_bin_show
*
*	Purpose:
*
*		Display the given data in binary.
*
*	Arguments:
*
*		data	The data to show.
*
*	Returned:
*
*		None.
*
******************************************************************************/

static void _bin_show(u8 data)
{
	u8	bit;

	for (bit = 0x80; bit >= 0x01; bit /= 2)
	{
		if (bit & data)
			printf("1");
		else
			printf("0");
	}
}



/******************************************************************************
*
*	Function:	_dev_dio_in
*
*	Purpose:
*
*		Read from the GPIO input.
*
*	Arguments:
*
*		fd		The file descriptor for the board to access.
*
*	Returned:
*
*		>= 0	The number of errors seen.
*
******************************************************************************/

static int _dev_dio_in(int fd)
{
	u8	data;
	int	errs	= 0;
	u32	val;

	errs	= aiss2ao2a2m_ioctl(fd, AISS2AO2A2M_IOCTL_DIO_READ, &val);
	errs	= (errs == -1) ? 1 : 0;
	data	= (u8) (0xFF & val);
	_bin_show(data);
	return(errs);
}



/******************************************************************************
*
*	Function:	dio_in
*
*	Purpose:
*
*		Perform a GPIO input test.
*
*	Arguments:
*
*		fd		The file descriptor for the board to access.
*
*	Returned:
*
*		>= 0	The number of errors seen.
*
******************************************************************************/

int dio_in(int fd)
{
	int	errs	= 0;
	int	i;

	for (;;)
	{
		errs	+= aiss2ao2a2m_initialize	(fd, -1, 1);
		errs	+= aiss2ao2a2m_dio_dir		(fd, -1, 1, AISS2AO2A2M_DIO_DIR_IN, NULL);

		if (errs)
			break;

		printf("    DIO In\n");
		printf("    76543210\n");
		printf("    ========\n");

		for (i = 0; i < 16; i++)
		{
			printf("    ");
			errs	+= _dev_dio_in(fd);
			printf("\n");
			usleep(250000);
		}

		gsc_label_level_inc();
		errs	+= aiss2ao2a2m_initialize(fd, -1, 0);
		gsc_label("Status");
		printf("%s\n", errs ? "FAIL <---" : "PASS");
		gsc_label_level_dec();
		break;
	}

	return(errs);
}



