// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/driver/gsc_pci9656.h $
// $Rev: 43587 $
// $Date: 2018-10-12 13:41:55 -0500 (Fri, 12 Oct 2018) $

// PCI9656: OS & Device Independent: Device Driver: header file

#ifndef	__GSC_PCI9656_H__
#define	__GSC_PCI9656_H__

#include "gsc_common.h"



// #defines *******************************************************************

#define	GSC_PCI_9656_ENCODE(s,o)	GSC_REG_ENCODE(GSC_REG_TYPE_PCI,(s),(o))
#define	GSC_PLX_9656_ENCODE(s,o)	GSC_REG_ENCODE(GSC_REG_TYPE_BAR0,(s),(o))

// PLX PCI9656 PCI Configuration Registers
#define	GSC_PCI_9656_VIDR			GSC_PCI_9656_ENCODE(2, 0x00)
#define	GSC_PCI_9656_DIDR			GSC_PCI_9656_ENCODE(2, 0x02)
#define	GSC_PCI_9656_CR				GSC_PCI_9656_ENCODE(2, 0x04)
#define	GSC_PCI_9656_SR				GSC_PCI_9656_ENCODE(2, 0x06)
#define	GSC_PCI_9656_REV			GSC_PCI_9656_ENCODE(1, 0x08)
#define	GSC_PCI_9656_CCR			GSC_PCI_9656_ENCODE(3, 0x09)
#define	GSC_PCI_9656_CLSR			GSC_PCI_9656_ENCODE(1, 0x0C)
#define	GSC_PCI_9656_LTR			GSC_PCI_9656_ENCODE(1, 0x0D)
#define	GSC_PCI_9656_HTR			GSC_PCI_9656_ENCODE(1, 0x0E)
#define	GSC_PCI_9656_BISTR			GSC_PCI_9656_ENCODE(1, 0x0F)
#define	GSC_PCI_9656_BAR0			GSC_PCI_9656_ENCODE(4, 0x10)
#define	GSC_PCI_9656_BAR1			GSC_PCI_9656_ENCODE(4, 0x14)
#define	GSC_PCI_9656_BAR2			GSC_PCI_9656_ENCODE(4, 0x18)
#define	GSC_PCI_9656_BAR3			GSC_PCI_9656_ENCODE(4, 0x1C)
#define	GSC_PCI_9656_BAR4			GSC_PCI_9656_ENCODE(4, 0x20)
#define	GSC_PCI_9656_BAR5			GSC_PCI_9656_ENCODE(4, 0x24)
#define	GSC_PCI_9656_CIS			GSC_PCI_9656_ENCODE(4, 0x28)
#define	GSC_PCI_9656_SVID			GSC_PCI_9656_ENCODE(2, 0x2C)
#define	GSC_PCI_9656_SID			GSC_PCI_9656_ENCODE(2, 0x2E)
#define	GSC_PCI_9656_ERBAR			GSC_PCI_9656_ENCODE(4, 0x30)
#define	GSC_PCI_9656_ILR			GSC_PCI_9656_ENCODE(1, 0x3C)
#define	GSC_PCI_9656_IPR			GSC_PCI_9656_ENCODE(1, 0x3D)
#define	GSC_PCI_9656_MGR			GSC_PCI_9656_ENCODE(1, 0x3E)
#define	GSC_PCI_9656_MLR			GSC_PCI_9656_ENCODE(1, 0x3F)

#define	GSC_PCI_9656_CAP_PTR		GSC_PCI_9656_ENCODE(1, 0x34)
#define	GSC_PCI_9656_PMCAPID		GSC_PCI_9656_ENCODE(1, 0x40)
#define	GSC_PCI_9656_PMNEXT			GSC_PCI_9656_ENCODE(1, 0x41)
#define	GSC_PCI_9656_PMC			GSC_PCI_9656_ENCODE(2, 0x42)
#define	GSC_PCI_9656_PMCSR			GSC_PCI_9656_ENCODE(2, 0x44)
#define	GSC_PCI_9656_PMCSR_BSE		GSC_PCI_9656_ENCODE(1, 0x46)
#define	GSC_PCI_9656_PMDATA			GSC_PCI_9656_ENCODE(1, 0x47)
#define	GSC_PCI_9656_HS_CNTL		GSC_PCI_9656_ENCODE(1, 0x48)
#define	GSC_PCI_9656_HS_NEXT		GSC_PCI_9656_ENCODE(1, 0x49)
#define	GSC_PCI_9656_HS_CSR			GSC_PCI_9656_ENCODE(1, 0x4A)
#define	GSC_PCI_9656_VPDIDR			GSC_PCI_9656_ENCODE(1, 0x4C)
#define	GSC_PCI_9656_VPD_NEXT		GSC_PCI_9656_ENCODE(1, 0x4D)
#define	GSC_PCI_9656_VPDAD			GSC_PCI_9656_ENCODE(2, 0x4E)
#define	GSC_PCI_9656_VPDATA			GSC_PCI_9656_ENCODE(4, 0x50)


// PLX PCI9656 feature set registers: Local Configuration Registers
#define	GSC_PLX_9656_LAS0RR			GSC_PLX_9656_ENCODE(4, 0x00)
#define	GSC_PLX_9656_LAS0BA			GSC_PLX_9656_ENCODE(4, 0x04)
#define	GSC_PLX_9656_MARBR			GSC_PLX_9656_ENCODE(4, 0x08)
#define	GSC_PLX_9656_BIGEND			GSC_PLX_9656_ENCODE(4, 0x0C)
#define	GSC_PLX_9656_EROMRR			GSC_PLX_9656_ENCODE(4, 0x10)
#define	GSC_PLX_9656_EROMBA			GSC_PLX_9656_ENCODE(4, 0x14)
#define	GSC_PLX_9656_LBRD0			GSC_PLX_9656_ENCODE(4, 0x18)
#define	GSC_PLX_9656_DMRR			GSC_PLX_9656_ENCODE(4, 0x1C)
#define	GSC_PLX_9656_DMLBAM			GSC_PLX_9656_ENCODE(4, 0x20)
#define	GSC_PLX_9656_DMLBAI			GSC_PLX_9656_ENCODE(4, 0x24)
#define	GSC_PLX_9656_DMPBAM			GSC_PLX_9656_ENCODE(4, 0x28)
#define	GSC_PLX_9656_DMCFGA			GSC_PLX_9656_ENCODE(4, 0x2C)
#define	GSC_PLX_9656_LAS1RR			GSC_PLX_9656_ENCODE(4, 0xF0)
#define	GSC_PLX_9656_LAS1BA			GSC_PLX_9656_ENCODE(4, 0xF4)
#define	GSC_PLX_9656_LBRD1			GSC_PLX_9656_ENCODE(4, 0xF8)

#define	GSC_PLX_9656_LMISC1			GSC_PLX_9656_ENCODE(1, 0x0D)
#define	GSC_PLX_9656_PROT_AREA		GSC_PLX_9656_ENCODE(1, 0x0E)
#define	GSC_PLX_9656_LMISC2			GSC_PLX_9656_ENCODE(1, 0x0F)
#define	GSC_PLX_9656_DMDAC			GSC_PLX_9656_ENCODE(4, 0xFC)
#define	GSC_PLX_9656_ARB			GSC_PLX_9656_ENCODE(1, 0x100)
#define	GSC_PLX_9656_ABTADR			GSC_PLX_9656_ENCODE(4, 0x104)

// PLX PCI9656 feature set registers: Runtime Registers
#define	GSC_PLX_9656_MBOX0			GSC_PLX_9656_ENCODE(4, 0x40)
#define	GSC_PLX_9656_MBOX1			GSC_PLX_9656_ENCODE(4, 0x44)
#define	GSC_PLX_9656_MBOX2			GSC_PLX_9656_ENCODE(4, 0x48)
#define	GSC_PLX_9656_MBOX3			GSC_PLX_9656_ENCODE(4, 0x4C)
#define	GSC_PLX_9656_MBOX4			GSC_PLX_9656_ENCODE(4, 0x50)
#define	GSC_PLX_9656_MBOX5			GSC_PLX_9656_ENCODE(4, 0x54)
#define	GSC_PLX_9656_MBOX6			GSC_PLX_9656_ENCODE(4, 0x58)
#define	GSC_PLX_9656_MBOX7			GSC_PLX_9656_ENCODE(4, 0x5C)
#define	GSC_PLX_9656_P2LDBELL		GSC_PLX_9656_ENCODE(4, 0x60)
#define	GSC_PLX_9656_L2PDBELL		GSC_PLX_9656_ENCODE(4, 0x64)
#define	GSC_PLX_9656_INTCSR			GSC_PLX_9656_ENCODE(4, 0x68)
#define	GSC_PLX_9656_CNTRL			GSC_PLX_9656_ENCODE(4, 0x6C)
#define	GSC_PLX_9656_VIDR			GSC_PLX_9656_ENCODE(2, 0x70)	// PCI offset 0x00
#define	GSC_PLX_9656_DIDR			GSC_PLX_9656_ENCODE(2, 0x72)	// PCI offset 0x02
#define	GSC_PLX_9656_REV			GSC_PLX_9656_ENCODE(1, 0x74)	// PCI offset 0x08

// PLX PCI9656 feature set registers: DMA Registers
#define	GSC_PLX_9656_DMAMODE0		GSC_PLX_9656_ENCODE(4, 0x80)
#define	GSC_PLX_9656_DMAPADR0		GSC_PLX_9656_ENCODE(4, 0x84)
#define	GSC_PLX_9656_DMALADR0		GSC_PLX_9656_ENCODE(4, 0x88)
#define	GSC_PLX_9656_DMASIZ0		GSC_PLX_9656_ENCODE(4, 0x8C)
#define	GSC_PLX_9656_DMADPR0		GSC_PLX_9656_ENCODE(4, 0x90)
#define	GSC_PLX_9656_DMAMODE1		GSC_PLX_9656_ENCODE(4, 0x94)
#define	GSC_PLX_9656_DMAPADR1		GSC_PLX_9656_ENCODE(4, 0x98)
#define	GSC_PLX_9656_DMALADR1		GSC_PLX_9656_ENCODE(4, 0x9C)
#define	GSC_PLX_9656_DMASIZ1		GSC_PLX_9656_ENCODE(4, 0xA0)
#define	GSC_PLX_9656_DMADPR1		GSC_PLX_9656_ENCODE(4, 0xA4)
#define	GSC_PLX_9656_DMACSR0		GSC_PLX_9656_ENCODE(1, 0xA8)
#define	GSC_PLX_9656_DMACSR1		GSC_PLX_9656_ENCODE(1, 0xA9)
#define	GSC_PLX_9656_DMAARB			GSC_PLX_9656_ENCODE(4, 0xAC)
#define	GSC_PLX_9656_DMATHR			GSC_PLX_9656_ENCODE(4, 0xB0)

#define	GSC_PLX_9656_DMADAC0		GSC_PLX_9656_ENCODE(4, 0xB4)
#define	GSC_PLX_9656_DMADAC1		GSC_PLX_9656_ENCODE(4, 0xB8)

// PLX PCI9656 feature set registers: Messaging Queue Registers
#define	GSC_PLX_9656_OPLFIS			GSC_PLX_9656_ENCODE(4, 0x30)
#define	GSC_PLX_9656_OPLFIM			GSC_PLX_9656_ENCODE(4, 0x34)
#define	GSC_PLX_9656_IQP			GSC_PLX_9656_ENCODE(4, 0x40)
#define	GSC_PLX_9656_OQP			GSC_PLX_9656_ENCODE(4, 0x44)
#define	GSC_PLX_9656_MQCR			GSC_PLX_9656_ENCODE(4, 0xC0)
#define	GSC_PLX_9656_QBAR			GSC_PLX_9656_ENCODE(4, 0xC4)
#define	GSC_PLX_9656_IFHPR			GSC_PLX_9656_ENCODE(4, 0xC8)
#define	GSC_PLX_9656_IFTPR			GSC_PLX_9656_ENCODE(4, 0xCC)
#define	GSC_PLX_9656_IPHPR			GSC_PLX_9656_ENCODE(4, 0xD0)
#define	GSC_PLX_9656_IPTPR			GSC_PLX_9656_ENCODE(4, 0xD4)
#define	GSC_PLX_9656_OFHPR			GSC_PLX_9656_ENCODE(4, 0xD8)
#define	GSC_PLX_9656_OFTPR			GSC_PLX_9656_ENCODE(4, 0xDC)
#define	GSC_PLX_9656_OPHPR			GSC_PLX_9656_ENCODE(4, 0xE0)
#define	GSC_PLX_9656_OPTPR			GSC_PLX_9656_ENCODE(4, 0xE4)
#define	GSC_PLX_9656_QSR			GSC_PLX_9656_ENCODE(4, 0xE8)



#endif
