// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/include/16aiss2ao2a2m_utils.h $
// $Rev: 45185 $
// $Date: 2019-07-01 16:59:31 -0500 (Mon, 01 Jul 2019) $

// 16AISS2AO2A2M: Utilities: header file

#ifndef	__16AISS2AO2A2M_UTILS_H__
#define	__16AISS2AO2A2M_UTILS_H__

#include "16aiss2ao2a2m_api.h"
#include "gsc_utils.h"



// prototypes *****************************************************************

// API utility services

int	aiss2ao2a2m_read_ai_util		(int fd, int index, int verbose, void* dst, size_t bytes);
int	aiss2ao2a2m_write_ao_util		(int fd, int index, int verbose, const void* src, size_t bytes);
int	aiss2ao2a2m_write_bdo_util		(int fd, int index, int verbose, const void* src, size_t bytes);
int aiss2ao2a2m_init_util			(int verbose);	// Must be first call to API Library.
int	aiss2ao2a2m_open_util			(int device, int share, int index, int verbose, int* fd);
int	aiss2ao2a2m_close_util			(int fd, int index, int verbose);
int aiss2ao2a2m_ioctl_util			(int fd, int index, int verbose, int request, void* arg);

// IOCTL utility services

int	aiss2ao2a2m_ai_buf_clear		(int fd, int index, int verbose);								// AISS2AO2A2M_IOCTL_AI_BUF_CLEAR
int	aiss2ao2a2m_ai_buf_enable		(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_AI_BUF_ENABLE
int	aiss2ao2a2m_ai_buf_level		(int fd, int index, int verbose, s32* get);						// AISS2AO2A2M_IOCTL_AI_BUF_LEVEL
int	aiss2ao2a2m_ai_buf_overflow		(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_AI_BUF_OVERFLOW
int	aiss2ao2a2m_ai_buf_underflow	(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_AI_BUF_UNDERFLOW
int	aiss2ao2a2m_ai_burst_enable		(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_AI_BURST_ENABLE
int	aiss2ao2a2m_ai_burst_size		(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_AI_BURST_SIZE
int	aiss2ao2a2m_ai_burst_status		(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_AI_BURST_STATUS
int	aiss2ao2a2m_ai_chan_0_range		(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_AI_CHAN_0_RANGE
int	aiss2ao2a2m_ai_chan_1_range		(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_AI_CHAN_1_RANGE
int	aiss2ao2a2m_ai_chan_sel			(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_AI_CHAN_SEL
int	aiss2ao2a2m_ai_io_abort			(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_AI_IO_ABORT
int	aiss2ao2a2m_ai_io_mode			(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_AI_IO_MODE
int	aiss2ao2a2m_ai_io_overflow		(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_AI_IO_OVERFLOW
int	aiss2ao2a2m_ai_io_timeout		(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_AI_IO_TIMEOUT
int	aiss2ao2a2m_ai_io_underflow		(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_AI_IO_UNDERFLOW
int	aiss2ao2a2m_ai_mode				(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_AI_MODE
int	aiss2ao2a2m_ai_sw_clock			(int fd, int index, int verbose);								// AISS2AO2A2M_IOCTL_AI_SW_CLOCK
int	aiss2ao2a2m_ai_sw_trigger		(int fd, int index, int verbose);								// AISS2AO2A2M_IOCTL_AI_SW_TRIGGER
int	aiss2ao2a2m_ai_thresh_lvl		(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_AI_THRESH_LVL
int	aiss2ao2a2m_ai_thresh_sts		(int fd, int index, int verbose, s32* get);						// AISS2AO2A2M_IOCTL_AI_THRESH_STS
int	aiss2ao2a2m_ao_access_mode		(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_AO_ACCESS_MODE
int	aiss2ao2a2m_ao_buf_clear		(int fd, int index, int verbose);								// AISS2AO2A2M_IOCTL_AO_BUF_CLEAR
int	aiss2ao2a2m_ao_buf_level		(int fd, int index, int verbose, s32* get);						// AISS2AO2A2M_IOCTL_AO_BUF_LEVEL
int	aiss2ao2a2m_ao_buf_load_req		(int fd, int index, int verbose);								// AISS2AO2A2M_IOCTL_AO_BUF_LOAD_REQ
int	aiss2ao2a2m_ao_buf_load_sts		(int fd, int index, int verbose, s32* get);						// AISS2AO2A2M_IOCTL_AO_BUF_LOAD_STS
int	aiss2ao2a2m_ao_buf_mode			(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_AO_BUF_MODE
int	aiss2ao2a2m_ao_buf_over_data	(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_AO_BUF_OVER_DATA
int	aiss2ao2a2m_ao_buf_over_frame	(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_AO_BUF_OVER_FRAME
int	aiss2ao2a2m_ao_buf_status		(int fd, int index, int verbose, s32* get);						// AISS2AO2A2M_IOCTL_AO_BUF_STATUS
int	aiss2ao2a2m_ao_burst_enable		(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_AO_BURST_ENABLE
int	aiss2ao2a2m_ao_burst_status		(int fd, int index, int verbose, s32* get);						// AISS2AO2A2M_IOCTL_AO_BURST_STATUS
int	aiss2ao2a2m_ao_burst_sync_ai	(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_AO_BURST_SYNC_AI
int	aiss2ao2a2m_ao_chan_sel			(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_AO_CHAN_SEL
int	aiss2ao2a2m_ao_clock_enable		(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_AO_CLOCK_ENABLE
int	aiss2ao2a2m_ao_clock_source		(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_AO_CLOCK_SOURCE
int	aiss2ao2a2m_ao_clock_status		(int fd, int index, int verbose, s32* get);						// AISS2AO2A2M_IOCTL_AO_CLOCK_STATUS
int	aiss2ao2a2m_ao_enable			(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_AO_ENABLE
int	aiss2ao2a2m_ao_io_abort			(int fd, int index, int verbose, s32* get);						// AISS2AO2A2M_IOCTL_AO_IO_ABORT
int	aiss2ao2a2m_ao_io_mode			(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_AO_IO_MODE
int	aiss2ao2a2m_ao_io_overflow		(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_AO_IO_OVERFLOW
int	aiss2ao2a2m_ao_io_timeout		(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_AO_IO_TIMEOUT
int	aiss2ao2a2m_ao_output_mode		(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_AO_OUTPUT_MODE
int	aiss2ao2a2m_ao_range			(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_AO_RANGE
int	aiss2ao2a2m_ao_sw_clock			(int fd, int index, int verbose);								// AISS2AO2A2M_IOCTL_AO_SW_CLOCK
int	aiss2ao2a2m_ao_sw_trigger		(int fd, int index, int verbose);								// AISS2AO2A2M_IOCTL_AO_SW_TRIGGER
int	aiss2ao2a2m_ao_thresh_lvl		(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_AO_THRESH_LVL
int	aiss2ao2a2m_ao_thresh_sts		(int fd, int index, int verbose, s32* get);						// AISS2AO2A2M_IOCTL_AO_THRESH_STS
int	aiss2ao2a2m_autocal_ai			(int fd, int index, int verbose);								// AISS2AO2A2M_IOCTL_AUTOCAL_AI
int	aiss2ao2a2m_autocal_all			(int fd, int index, int verbose);								// AISS2AO2A2M_IOCTL_AUTOCAL_ALL
int	aiss2ao2a2m_autocal_sts			(int fd, int index, int verbose, s32* get);						// AISS2AO2A2M_IOCTL_AUTOCAL_STS
int	aiss2ao2a2m_bdo_access_mode		(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_BDO_ACCESS_MODE
int	aiss2ao2a2m_bdo_buf_clear		(int fd, int index, int verbose);								// AISS2AO2A2M_IOCTL_BDO_BUF_CLEAR
int	aiss2ao2a2m_bdo_buf_enable		(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_BDO_BUF_ENABLE
int	aiss2ao2a2m_bdo_buf_level		(int fd, int index, int verbose, s32* get);						// AISS2AO2A2M_IOCTL_BDO_BUF_LEVEL
int	aiss2ao2a2m_bdo_buf_overflow	(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_BDO_BUF_OVERFLOW
int	aiss2ao2a2m_bdo_buf_underflow	(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_BDO_BUF_UNDERFLOW
int	aiss2ao2a2m_bdo_clock_enable	(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_BDO_CLOCK_ENABLE
int	aiss2ao2a2m_bdo_clock_source	(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_BDO_CLOCK_SOURCE
int	aiss2ao2a2m_bdo_io_abort		(int fd, int index, int verbose, s32* get);						// AISS2AO2A2M_IOCTL_BDO_IO_ABORT
int	aiss2ao2a2m_bdo_io_mode			(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_BDO_IO_MODE
int	aiss2ao2a2m_bdo_io_overflow		(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_BDO_IO_OVERFLOW
int	aiss2ao2a2m_bdo_io_timeout		(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_BDO_IO_TIMEOUT
int	aiss2ao2a2m_bdo_io_underflow	(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_BDO_IO_UNDERFLOW
int	aiss2ao2a2m_bdo_rate_gen_enable	(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_BDO_RATE_GEN_ENABLE
int	aiss2ao2a2m_bdo_rate_gen_ndiv	(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_BDO_RATE_GEN_NDIV
int	aiss2ao2a2m_bdo_sw_clock		(int fd, int index, int verbose);								// AISS2AO2A2M_IOCTL_BDO_SW_CLOCK
int	aiss2ao2a2m_bdo_thresh_lvl		(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_BDO_THRESH_LVL
int	aiss2ao2a2m_bdo_thresh_sts		(int fd, int index, int verbose, s32* get);						// AISS2AO2A2M_IOCTL_BDO_THRESH_STS
int	aiss2ao2a2m_cbl_in_clk_io		(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_CBL_IN_CLK_IO
int	aiss2ao2a2m_cbl_io_clk_dir		(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_CBL_IO_CLK_DIR
int	aiss2ao2a2m_cbl_out_clk_io		(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_CBL_OUT_CLK_IO
int	aiss2ao2a2m_cbl_trig_io			(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_CBL_TRIG_IO
int	aiss2ao2a2m_data_format			(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_DATA_FORMAT
int	aiss2ao2a2m_dio_dir				(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_DIO_DIR
int	aiss2ao2a2m_dio_read			(int fd, int index, int verbose, s32* get);						// AISS2AO2A2M_IOCTL_DIO_READ
int	aiss2ao2a2m_dio_write			(int fd, int index, int verbose, s32 set);						// AISS2AO2A2M_IOCTL_DIO_WRITE
int	aiss2ao2a2m_initialize			(int fd, int index, int verbose);								// AISS2AO2A2M_IOCTL_INITIALIZE
int	aiss2ao2a2m_irq_enable			(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_IRQ_ENABLE
int	aiss2ao2a2m_query				(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_QUERY
int	aiss2ao2a2m_rate_a_gen_enable	(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_RATE_A_GEN_ENABLE
int	aiss2ao2a2m_rate_a_gen_ndiv		(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_RATE_A_GEN_NDIV
int	aiss2ao2a2m_rate_b_gen_enable	(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_RATE_B_GEN_ENABLE
int	aiss2ao2a2m_rate_a_gen_ndiv		(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_RATE_B_GEN_NDIV
int	aiss2ao2a2m_rate_c_gen_enable	(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_RATE_C_GEN_ENABLE
int	aiss2ao2a2m_rate_c_gen_ndiv		(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_RATE_C_GEN_NDIV
int	aiss2ao2a2m_reg_mod				(int fd, int index, int verbose, u32 reg, u32 value, u32 mask);	// AISS2AO2A2M_IOCTL_REG_MOD
int	aiss2ao2a2m_reg_read			(int fd, int index, int verbose, u32 reg, u32* value);			// AISS2AO2A2M_IOCTL_REG_READ
int	aiss2ao2a2m_reg_write			(int fd, int index, int verbose, u32 reg, u32 value);			// AISS2AO2A2M_IOCTL_REG_WRITE
int	aiss2ao2a2m_trigger_dir			(int fd, int index, int verbose, s32 set, s32* get);			// AISS2AO2A2M_IOCTL_TRIGGER_DIR
int	aiss2ao2a2m_wait_cancel			(int fd, int index, int verbose, gsc_wait_t* wait);				// AISS2AO2A2M_IOCTL_WAIT_CANCEL
int	aiss2ao2a2m_wait_event			(int fd, int index, int verbose, gsc_wait_t* wait);				// AISS2AO2A2M_IOCTL_WAIT_EVENT
int	aiss2ao2a2m_wait_status			(int fd, int index, int verbose, gsc_wait_t* wait);				// AISS2AO2A2M_IOCTL_WAIT_STATUS

// Auxiliary utility services

int	aiss2ao2a2m_config_ai			(int fd, int index, int verbose, s32 fsamp);
int	aiss2ao2a2m_config_ao			(int fd, int index, int verbose, s32 fsamp);
int	aiss2ao2a2m_config_bdo			(int fd, int index, int verbose, s32 fsamp);
int	aiss2ao2a2m_fsamp_ai_compute	(int fd, int index, int verbose, s32 fsamp, s32* ndiv, double* rate);
int	aiss2ao2a2m_fsamp_ai_report		(int fd, int index, int verbose, int chan, s32* fsamp);
int	aiss2ao2a2m_fsamp_ai_report_all	(int fd, int index, int verbose, s32* fsamp);
int	aiss2ao2a2m_fsamp_ao_compute	(int fd, int index, int verbose, s32 fsamp, s32* ndiv, double* rate);
int	aiss2ao2a2m_fsamp_ao_report		(int fd, int index, int verbose, int chan, s32* fsamp);
int	aiss2ao2a2m_fsamp_ao_report_all	(int fd, int index, int verbose, s32* fsamp);
int	aiss2ao2a2m_fsamp_bdo_compute	(int fd, int index, int verbose, s32 fsamp, s32* ndiv, double* rate);
int	aiss2ao2a2m_id_device			(int fd, int index, int verbose);

int	aiss2ao2a2m_count_boards		(int verbose, s32* get);
int	aiss2ao2a2m_reg_list			(int fd, int detail);

const gsc_reg_def_t*				aiss2ao2a2m_reg_get_def_id		(u32 reg);
const gsc_reg_def_t*				aiss2ao2a2m_reg_get_def_index	(int index);
const char*							aiss2ao2a2m_reg_get_desc		(u32 reg);
const char*							aiss2ao2a2m_reg_get_name		(u32 reg);



#endif
