// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/driver/16aiss2ao2a2m.h $
// $Rev: 43415 $
// $Date: 2018-08-24 17:31:42 -0500 (Fri, 24 Aug 2018) $

// 16AISS2AO2A2M: Device Driver: header file

#ifndef	__16AISS2AO2A2M_H__
#define	__16AISS2AO2A2M_H__

#include "gsc_common.h"
#include "gsc_pci9056.h"



// #defines *******************************************************************

#define	AISS2AO2A2M_BASE_NAME				"16aiss2ao2a2m"

// IOCTL command codes
#define	AISS2AO2A2M_IOCTL_REG_READ				OS_IOCTL_RW( 0, 12, gsc_reg_t)
#define	AISS2AO2A2M_IOCTL_REG_WRITE				OS_IOCTL_W ( 1, 12, gsc_reg_t)
#define	AISS2AO2A2M_IOCTL_REG_MOD				OS_IOCTL_W ( 2, 12, gsc_reg_t)
#define	AISS2AO2A2M_IOCTL_QUERY					OS_IOCTL_RW( 3,  4, s32)
#define	AISS2AO2A2M_IOCTL_INITIALIZE			OS_IOCTL   ( 4)
#define	AISS2AO2A2M_IOCTL_AUTOCAL_ALL			OS_IOCTL   ( 5)
#define	AISS2AO2A2M_IOCTL_AUTOCAL_AI			OS_IOCTL   ( 6)
#define	AISS2AO2A2M_IOCTL_AUTOCAL_STS			OS_IOCTL_R ( 7,  4, s32)
#define	AISS2AO2A2M_IOCTL_AI_BUF_CLEAR			OS_IOCTL   ( 8)
#define	AISS2AO2A2M_IOCTL_AI_BUF_ENABLE			OS_IOCTL_RW( 9,  4, s32)
#define	AISS2AO2A2M_IOCTL_AI_BUF_LEVEL			OS_IOCTL_R (10,  4, s32)
#define	AISS2AO2A2M_IOCTL_AI_BUF_OVERFLOW		OS_IOCTL_RW(11,  4, s32)
#define	AISS2AO2A2M_IOCTL_AI_BUF_UNDERFLOW		OS_IOCTL_RW(12,  4, s32)
#define	AISS2AO2A2M_IOCTL_AI_BURST_ENABLE		OS_IOCTL_RW(13,  4, s32)
#define	AISS2AO2A2M_IOCTL_AI_BURST_SIZE			OS_IOCTL_RW(14,  4, s32)
#define	AISS2AO2A2M_IOCTL_AI_BURST_STATUS		OS_IOCTL_RW(15,  4, s32)
#define	AISS2AO2A2M_IOCTL_AI_CHAN_0_RANGE		OS_IOCTL_RW(16,  4, s32)
#define	AISS2AO2A2M_IOCTL_AI_CHAN_1_RANGE		OS_IOCTL_RW(17,  4, s32)
#define	AISS2AO2A2M_IOCTL_AI_CHAN_SEL			OS_IOCTL_RW(18,  4, s32)
#define	AISS2AO2A2M_IOCTL_AI_IO_ABORT			OS_IOCTL_R (19,  4, s32)
#define	AISS2AO2A2M_IOCTL_AI_IO_MODE			OS_IOCTL_RW(20,  4, s32)
#define	AISS2AO2A2M_IOCTL_AI_IO_OVERFLOW		OS_IOCTL_RW(21,  4, s32)
#define	AISS2AO2A2M_IOCTL_AI_IO_TIMEOUT			OS_IOCTL_RW(22,  4, s32)
#define	AISS2AO2A2M_IOCTL_AI_IO_UNDERFLOW		OS_IOCTL_RW(23,  4, s32)
#define	AISS2AO2A2M_IOCTL_AI_MODE				OS_IOCTL_RW(24,  4, s32)
#define	AISS2AO2A2M_IOCTL_AI_SW_CLOCK			OS_IOCTL   (25)
#define	AISS2AO2A2M_IOCTL_AI_SW_TRIGGER			OS_IOCTL   (26)
#define	AISS2AO2A2M_IOCTL_AI_THRESH_LVL			OS_IOCTL_RW(27,  4, s32)
#define	AISS2AO2A2M_IOCTL_AI_THRESH_STS			OS_IOCTL_R (28,  4, s32)
#define	AISS2AO2A2M_IOCTL_AO_ACCESS_MODE		OS_IOCTL_RW(29,  4, s32)
#define	AISS2AO2A2M_IOCTL_AO_BUF_CLEAR			OS_IOCTL   (30)
#define	AISS2AO2A2M_IOCTL_AO_BUF_LEVEL			OS_IOCTL_R (31,  4, s32)
#define	AISS2AO2A2M_IOCTL_AO_BUF_LOAD_REQ		OS_IOCTL   (32)
#define	AISS2AO2A2M_IOCTL_AO_BUF_LOAD_STS		OS_IOCTL_R (33,  4, s32)
#define	AISS2AO2A2M_IOCTL_AO_BUF_MODE			OS_IOCTL_RW(34,  4, s32)
#define	AISS2AO2A2M_IOCTL_AO_BUF_OVER_DATA		OS_IOCTL_RW(35,  4, s32)
#define	AISS2AO2A2M_IOCTL_AO_BUF_OVER_FRAME		OS_IOCTL_RW(36,  4, s32)
#define	AISS2AO2A2M_IOCTL_AO_BUF_STATUS			OS_IOCTL_R (37,  4, s32)
#define	AISS2AO2A2M_IOCTL_AO_BURST_ENABLE		OS_IOCTL_RW(38,  4, s32)
#define	AISS2AO2A2M_IOCTL_AO_BURST_STATUS		OS_IOCTL_R (39,  4, s32)
#define	AISS2AO2A2M_IOCTL_AO_BURST_SYNC_AI		OS_IOCTL_RW(40,  4, s32)
#define	AISS2AO2A2M_IOCTL_AO_CHAN_SEL			OS_IOCTL_RW(41,  4, s32)
#define	AISS2AO2A2M_IOCTL_AO_CLOCK_ENABLE		OS_IOCTL_RW(42,  4, s32)
#define	AISS2AO2A2M_IOCTL_AO_CLOCK_SOURCE		OS_IOCTL_RW(43,  4, s32)
#define	AISS2AO2A2M_IOCTL_AO_CLOCK_STATUS		OS_IOCTL_R (44,  4, s32)
#define	AISS2AO2A2M_IOCTL_AO_ENABLE				OS_IOCTL_RW(45,  4, s32)
#define	AISS2AO2A2M_IOCTL_AO_IO_ABORT			OS_IOCTL_R (46,  4, s32)
#define	AISS2AO2A2M_IOCTL_AO_IO_MODE			OS_IOCTL_RW(47,  4, s32)
#define	AISS2AO2A2M_IOCTL_AO_IO_OVERFLOW		OS_IOCTL_RW(48,  4, s32)
#define	AISS2AO2A2M_IOCTL_AO_IO_TIMEOUT			OS_IOCTL_RW(49,  4, s32)
#define	AISS2AO2A2M_IOCTL_AO_OUTPUT_MODE		OS_IOCTL_RW(50,  4, s32)
#define	AISS2AO2A2M_IOCTL_AO_RANGE				OS_IOCTL_RW(51,  4, s32)
#define	AISS2AO2A2M_IOCTL_AO_SW_CLOCK			OS_IOCTL   (52)
#define	AISS2AO2A2M_IOCTL_AO_SW_TRIGGER			OS_IOCTL   (53)
#define	AISS2AO2A2M_IOCTL_AO_THRESH_LVL			OS_IOCTL_RW(54,  4, s32)
#define	AISS2AO2A2M_IOCTL_AO_THRESH_STS			OS_IOCTL_R (55,  4, s32)
#define	AISS2AO2A2M_IOCTL_BDO_ACCESS_MODE		OS_IOCTL_RW(56,  4, s32)
#define	AISS2AO2A2M_IOCTL_BDO_BUF_CLEAR			OS_IOCTL   (57)
#define	AISS2AO2A2M_IOCTL_BDO_BUF_ENABLE		OS_IOCTL_RW(58,  4, s32)
#define	AISS2AO2A2M_IOCTL_BDO_BUF_LEVEL			OS_IOCTL_R (59,  4, s32)
#define	AISS2AO2A2M_IOCTL_BDO_BUF_OVERFLOW		OS_IOCTL_RW(60,  4, s32)
#define	AISS2AO2A2M_IOCTL_BDO_BUF_UNDERFLOW		OS_IOCTL_RW(61,  4, s32)
#define	AISS2AO2A2M_IOCTL_BDO_CLOCK_ENABLE		OS_IOCTL_RW(62,  4, s32)
#define	AISS2AO2A2M_IOCTL_BDO_CLOCK_SOURCE		OS_IOCTL_RW(63,  4, s32)
#define	AISS2AO2A2M_IOCTL_BDO_IO_ABORT			OS_IOCTL_R (64,  4, s32)
#define	AISS2AO2A2M_IOCTL_BDO_IO_MODE			OS_IOCTL_RW(65,  4, s32)
#define	AISS2AO2A2M_IOCTL_BDO_IO_OVERFLOW		OS_IOCTL_RW(66,  4, s32)
#define	AISS2AO2A2M_IOCTL_BDO_IO_TIMEOUT		OS_IOCTL_RW(67,  4, s32)
#define	AISS2AO2A2M_IOCTL_BDO_IO_UNDERFLOW		OS_IOCTL_RW(68,  4, s32)
#define	AISS2AO2A2M_IOCTL_BDO_RATE_GEN_ENABLE	OS_IOCTL_RW(69,  4, s32)
#define	AISS2AO2A2M_IOCTL_BDO_RATE_GEN_NDIV		OS_IOCTL_RW(70,  4, s32)
#define	AISS2AO2A2M_IOCTL_BDO_SW_CLOCK			OS_IOCTL   (71)
#define	AISS2AO2A2M_IOCTL_BDO_THRESH_LVL		OS_IOCTL_RW(72,  4, s32)
#define	AISS2AO2A2M_IOCTL_BDO_THRESH_STS		OS_IOCTL_R (73,  4, s32)
#define	AISS2AO2A2M_IOCTL_CBL_IN_CLK_IO			OS_IOCTL_RW(74,  4, s32)
#define	AISS2AO2A2M_IOCTL_CBL_IO_CLK_DIR		OS_IOCTL_RW(75,  4, s32)
#define	AISS2AO2A2M_IOCTL_CBL_OUT_CLK_IO		OS_IOCTL_RW(76,  4, s32)
#define	AISS2AO2A2M_IOCTL_CBL_TRIG_IO			OS_IOCTL_RW(77,  4, s32)
#define	AISS2AO2A2M_IOCTL_DATA_FORMAT			OS_IOCTL_RW(78,  4, s32)
#define	AISS2AO2A2M_IOCTL_DIO_DIR				OS_IOCTL_RW(79,  4, s32)
#define	AISS2AO2A2M_IOCTL_DIO_READ				OS_IOCTL_R (80,  4, s32)
#define	AISS2AO2A2M_IOCTL_DIO_WRITE				OS_IOCTL_W (81,  4, s32)
#define	AISS2AO2A2M_IOCTL_IRQ_ENABLE			OS_IOCTL_RW(82,  4, s32)
#define	AISS2AO2A2M_IOCTL_RATE_A_GEN_ENABLE		OS_IOCTL_RW(83,  4, s32)
#define	AISS2AO2A2M_IOCTL_RATE_A_GEN_NDIV		OS_IOCTL_RW(84,  4, s32)
#define	AISS2AO2A2M_IOCTL_RATE_B_GEN_ENABLE		OS_IOCTL_RW(85,  4, s32)
#define	AISS2AO2A2M_IOCTL_RATE_B_GEN_NDIV		OS_IOCTL_RW(86,  4, s32)
#define	AISS2AO2A2M_IOCTL_RATE_C_GEN_ENABLE		OS_IOCTL_RW(87,  4, s32)
#define	AISS2AO2A2M_IOCTL_RATE_C_GEN_NDIV		OS_IOCTL_RW(88,  4, s32)
#define	AISS2AO2A2M_IOCTL_TRIGGER_DIR			OS_IOCTL_RW(89,  4, s32)
#define	AISS2AO2A2M_IOCTL_WAIT_CANCEL			OS_IOCTL_RW(90, 28, gsc_wait_t)
#define	AISS2AO2A2M_IOCTL_WAIT_EVENT			OS_IOCTL_RW(91, 28, gsc_wait_t)
#define	AISS2AO2A2M_IOCTL_WAIT_STATUS			OS_IOCTL_RW(92, 28, gsc_wait_t)

//*****************************************************************************
// AISS2AO2A2M_IOCTL_REG_READ
// AISS2AO2A2M_IOCTL_REG_WRITE
// AISS2AO2A2M_IOCTL_REG_MOD
//
// Parameter:	gsc_reg_t*
//
#define	AISS2AO2A2M_REG_ENCODE(s,o)			GSC_REG_ENCODE(GSC_REG_TYPE_BAR2,(s),(o))

#define	AISS2AO2A2M_GSC_BCR					AISS2AO2A2M_REG_ENCODE(4,0x00)// Board Control Register
#define	AISS2AO2A2M_GSC_DIOPR				AISS2AO2A2M_REG_ENCODE(4,0x04)// Digital I/O Port Register
#define	AISS2AO2A2M_GSC_AOC0R				AISS2AO2A2M_REG_ENCODE(4,0x08)// Analog Output Channel 0 Register
#define	AISS2AO2A2M_GSC_AOC1R				AISS2AO2A2M_REG_ENCODE(4,0x0C)// Analog Output Channel 1 Register

#define	AISS2AO2A2M_GSC_AIBR				AISS2AO2A2M_REG_ENCODE(4,0x18)// Analog Input Buffer Register
#define	AISS2AO2A2M_GSC_RAGR				AISS2AO2A2M_REG_ENCODE(4,0x1C)// Rate-A Generator Register
#define	AISS2AO2A2M_GSC_RBGR				AISS2AO2A2M_REG_ENCODE(4,0x20)// Rate-B Generator Register
#define	AISS2AO2A2M_GSC_ICR					AISS2AO2A2M_REG_ENCODE(4,0x24)// Input Configuration Register
#define	AISS2AO2A2M_GSC_IBSR				AISS2AO2A2M_REG_ENCODE(4,0x28)// Input Buffer Size Register
#define	AISS2AO2A2M_GSC_IBTR				AISS2AO2A2M_REG_ENCODE(4,0x2C)// Input Buffer Threshold Register
#define	AISS2AO2A2M_GSC_PSR					AISS2AO2A2M_REG_ENCODE(4,0x30)// Primary Status Register
#define	AISS2AO2A2M_GSC_ACFGR				AISS2AO2A2M_REG_ENCODE(4,0x34)// Assembly Configuration Register
#define	AISS2AO2A2M_GSC_AVR					AISS2AO2A2M_REG_ENCODE(4,0x38)// Autocal Values Register
#define	AISS2AO2A2M_GSC_BOOR				AISS2AO2A2M_REG_ENCODE(4,0x3C)// Buffered Output Operations Register
#define	AISS2AO2A2M_GSC_OBTR				AISS2AO2A2M_REG_ENCODE(4,0x40)// Output Buffer Threshold Register
#define	AISS2AO2A2M_GSC_OBSR				AISS2AO2A2M_REG_ENCODE(4,0x44)// Output Buffer Size Register
#define	AISS2AO2A2M_GSC_AOBR				AISS2AO2A2M_REG_ENCODE(4,0x48)// Analog Output Buffer Register
#define	AISS2AO2A2M_GSC_RCGR				AISS2AO2A2M_REG_ENCODE(4,0x4C)// Rate-C Generator Register
#define	AISS2AO2A2M_GSC_BDOBSR				AISS2AO2A2M_REG_ENCODE(4,0x50)// BDO Buffer Size Register
#define	AISS2AO2A2M_GSC_BDOBCR				AISS2AO2A2M_REG_ENCODE(4,0x54)// BDO Buffer Control Register
#define	AISS2AO2A2M_GSC_BDOBR				AISS2AO2A2M_REG_ENCODE(4,0x58)// BDO Buffer Register
#define	AISS2AO2A2M_GSC_BDORGR				AISS2AO2A2M_REG_ENCODE(4,0x5C)// BDO Rate Generator Register
#define	AISS2AO2A2M_GSC_ACR					AISS2AO2A2M_REG_ENCODE(4,0x60)// Ancillary Control Register

//*****************************************************************************
// AISS2AO2A2M_IOCTL_QUERY
//
//	Parameter:	s32
//		Pass in a value from the list below.
//		The value returned is the answer to the query.

typedef enum
{
	AISS2AO2A2M_QUERY_AUTOCAL_MS,			// BCR D3, D28
	AISS2AO2A2M_QUERY_COUNT,				// How many query options are supported?
	AISS2AO2A2M_QUERY_DEVICE_TYPE,			// from gsc_dev_type_t
	AISS2AO2A2M_QUERY_INITIALIZE_MS,
	AISS2AO2A2M_QUERY_MASTER_CLOCK,			// ACFGR D18-D19
	AISS2AO2A2M_QUERY_RATE_GEN_QTY,

	AISS2AO2A2M_QUERY_AI_CHANS_MAX,
	AISS2AO2A2M_QUERY_AI_CHANS_QTY,			// ACFGR D16
	AISS2AO2A2M_QUERY_AI_FIFO_SIZE,
	AISS2AO2A2M_QUERY_AI_FSAMP_MAX,
	AISS2AO2A2M_QUERY_AI_FSAMP_MIN,
	AISS2AO2A2M_QUERY_AI_NDIV_MAX,
	AISS2AO2A2M_QUERY_AI_NDIV_MIN,

	AISS2AO2A2M_QUERY_AO_CHANS_MAX,
	AISS2AO2A2M_QUERY_AO_CHANS_QTY,			// ACFGR D17
	AISS2AO2A2M_QUERY_AO_FIFO_SIZE,
	AISS2AO2A2M_QUERY_AO_FSAMP_MAX,
	AISS2AO2A2M_QUERY_AO_FSAMP_MIN,
	AISS2AO2A2M_QUERY_AO_NDIV_MAX,
	AISS2AO2A2M_QUERY_AO_NDIV_MIN,

	AISS2AO2A2M_QUERY_BDO_FIFO_SIZE,
	AISS2AO2A2M_QUERY_BDO_FSAMP_MAX,
	AISS2AO2A2M_QUERY_BDO_FSAMP_MIN,
	AISS2AO2A2M_QUERY_BDO_NDIV_MAX,
	AISS2AO2A2M_QUERY_BDO_NDIV_MIN,

	AISS2AO2A2M_IOCTL_QUERY_LAST
} aiss2ao2a2m_query_t;

#define	AISS2AO2A2M_IOCTL_QUERY_ERROR		(-1)

//*****************************************************************************
// AISS2AO2A2M_IOCTL_INITIALIZE				BCR D31
//
//	Parameter:	None

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AUTOCAL_ALL			BCR D28, D29
//
//	Parameter:	None

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AUTOCAL_AI				BCR D3, D29
//
//	Parameter:	None

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AUTOCAL_STS			BCR D29, D3, D28
//
//	Parameter:	s32*
//		One of the below values is returned.
#define	AISS2AO2A2M_AUTOCAL_STS_ACTIVE		0
#define	AISS2AO2A2M_AUTOCAL_STS_FAIL		1
#define	AISS2AO2A2M_AUTOCAL_STS_PASS		2

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AI_BUF_CLEAR			BCR D13
//
//	Parameter:	None.

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AI_BUF_ENABLE			BCR D12
//
//	Parameter:	s32*
//		Pass in any valid option below, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_AI_BUF_ENABLE_NO		0	// Disable the buffer.
#define	AISS2AO2A2M_AI_BUF_ENABLE_YES		1	// Enable the buffer.

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AI_BUF_LEVEL			IBSR D0-D21
//
//	Parameter:	s32*
//		The value returned is the current buffer fill level.

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AI_BUF_OVERFLOW		BCR D15
//
//	Parameter:	s32*
//		Pass in any valid option below, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_AI_BUF_OVERFLOW_CLEAR	0
#define	AISS2AO2A2M_AI_BUF_OVERFLOW_CHECK	(-1)

// For queries the following values are returned.
#define	AISS2AO2A2M_AI_BUF_OVERFLOW_NO		0
#define	AISS2AO2A2M_AI_BUF_OVERFLOW_YES		1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AI_BUF_UNDERFLOW		BCR D23
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_AI_BUF_UNDERFLOW_CLEAR	0
#define	AISS2AO2A2M_AI_BUF_UNDERFLOW_CHECK	(-1)

// For queries the following values are returned.
#define	AISS2AO2A2M_AI_BUF_UNDERFLOW_NO		0
#define	AISS2AO2A2M_AI_BUF_UNDERFLOW_YES	1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AI_BURST_ENABLE		BCR D9
//
//	Parameter:	s32*
//		The value returned is one of the following.
#define	AISS2AO2A2M_AI_BURST_ENABLE_NO		0
#define	AISS2AO2A2M_AI_BURST_ENABLE_YES		1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AI_BURST_SIZE			ICR D0-D23
//
//	Parameter:	s32*
//		Pass in any value between the below inclusive limits, or
//		-1 to read the current setting.
//		At this time the valid range is 0-0xFFFFFF.

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AI_BURST_STATUS		BCR D10
//
//	Parameter:	s32*
//		The value returned is one of the following.
#define	AISS2AO2A2M_AI_BURST_STATUS_IDLE	0
#define	AISS2AO2A2M_AI_BURST_STATUS_BUSY	1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AI_CHAN_SEL			ICR D24-D25
//
//	Parameter:	s32*
//		Pass in a bitmap of the channels to enable, or
//		-1 to read the current setting.
//		A valid bitmap is dependent on the AI selection and the
//		number of corresponding input channels on the board.

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AI_CHAN_0_RANGE		BCR D4-D5
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_AI_CHAN_0_RANGE_2_5V	0	// +- 2.5 volts
#define	AISS2AO2A2M_AI_CHAN_0_RANGE_5V		1	// +- 5 volts
#define	AISS2AO2A2M_AI_CHAN_0_RANGE_10V		2	// +- 10 volts

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AI_CHAN_1_RANGE		BCR D6-D7
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_AI_CHAN_1_RANGE_2_5V	0	// +- 2.5 volts
#define	AISS2AO2A2M_AI_CHAN_1_RANGE_5V		1	// +- 5 volts
#define	AISS2AO2A2M_AI_CHAN_1_RANGE_10V		2	// +- 10 volts

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AI_IO_ABORT
//
//	Parameter:	s32*
//		The returned value is one of the below options.
#define	AISS2AO2A2M_AI_IO_ABORT_NO			0
#define	AISS2AO2A2M_AI_IO_ABORT_YES			1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AI_IO_MODE
//
//	Parameter:	s32*
//		Pass in any of the gsc_io_mode_t options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_AI_IO_MODE_DEFAULT		GSC_IO_MODE_PIO

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AI_IO_OVERFLOW
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_AI_IO_OVERFLOW_DEFAULT	AISS2AO2A2M_AI_IO_OVERFLOW_CHECK
#define	AISS2AO2A2M_AI_IO_OVERFLOW_IGNORE	0
#define	AISS2AO2A2M_AI_IO_OVERFLOW_CHECK	1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AI_IO_TIMEOUT (in seconds)
//
//	Parameter:	s32*
//		Pass in any value from the minimim to the maximim, the infinite option,
//		or -1 to read the current setting. The value -1 is returned if the
//		feature is not supported, but this should never happen.
#define	AISS2AO2A2M_AI_IO_TIMEOUT_DEFAULT	10
#define	AISS2AO2A2M_AI_IO_TIMEOUT_NO_SLEEP	0
#define	AISS2AO2A2M_AI_IO_TIMEOUT_MIN		0
#define	AISS2AO2A2M_AI_IO_TIMEOUT_MAX		GSC_IO_TIMEOUT_MAX
#define	AISS2AO2A2M_AI_IO_TIMEOUT_INFINITE	GSC_IO_TIMEOUT_INFINITE

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AI_IO_UNDERFLOW
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_AI_IO_UNDERFLOW_DEFAULT	AISS2AO2A2M_AI_IO_UNDERFLOW_CHECK
#define	AISS2AO2A2M_AI_IO_UNDERFLOW_IGNORE	0
#define	AISS2AO2A2M_AI_IO_UNDERFLOW_CHECK	1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AI_MODE				BCR D0-D2
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_AI_MODE_DIFF			0	// Differential
#define	AISS2AO2A2M_AI_MODE_SINGLE			1	// Single-Ended
#define	AISS2AO2A2M_AI_MODE_ZERO			2	// Zero test
#define	AISS2AO2A2M_AI_MODE_VREF			3	// Vref test
#define	AISS2AO2A2M_AI_MODE_AO_0			4	// Analog Output Channel 0
#define	AISS2AO2A2M_AI_MODE_AO_1			5	// Analog Output Channel 1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AI_SW_CLOCK			BCR D8
//
//	Parameter:	None.

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AI_SW_TRIGGER			BCR D11
//
//	Parameter:	None.

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AI_THRESH_LVL			IBTR D0-D21
//
//	Parameter:	s32*
//		Pass in any valid value from 0x0 to 0x3FFFFF, or
//		-1 to read the current setting.

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AI_THRESH_STS			BCR D14, IBTR D24
//
//	Parameter:	s32*
//		The value returned is one of the following.
#define	AISS2AO2A2M_AI_THRESH_STS_CLEAR		0
#define	AISS2AO2A2M_AI_THRESH_STS_SET		1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AO_ACCESS_MODE			BCR D19
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_AO_ACCESS_MODE_REG		0
#define	AISS2AO2A2M_AO_ACCESS_MODE_FIFO		1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AO_BUF_CLEAR			BOOR D11
//
//	Parameter:	None.

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AO_BUF_LEVEL			OBSR D0-D21
//
//	Parameter:	s32*
//		The value returned is the current buffer fill level.

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AO_BUF_LOAD_REQ		BOOR D9
//
//	Parameter:	None.

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AO_BUF_LOAD_STS		BOOR D10
//
//	Parameter:	s32*
//		The value returned is one of the following.
#define	AISS2AO2A2M_AO_BUF_LOAD_STS_BUSY	0
#define	AISS2AO2A2M_AO_BUF_LOAD_STS_READY	1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AO_BUF_MODE			BOOR D8
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_AO_BUF_MODE_OPEN		0
#define	AISS2AO2A2M_AO_BUF_MODE_CIRC		1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AO_BUF_OVER_DATA		BOOR D16
//
//	Parameter:	s32*
//		Pass in any valid option below, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_AO_BUF_OVER_DATA_CLEAR	0
#define	AISS2AO2A2M_AO_BUF_OVER_DATA_CHECK	(-1)

// For queries the following values are returned.
#define	AISS2AO2A2M_AO_BUF_OVER_DATA_NO		0
#define	AISS2AO2A2M_AO_BUF_OVER_DATA_YES	1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AO_BUF_OVER_FRAME		BOOR D17
//
//	Parameter:	s32*
//		Pass in any valid option below, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_AO_BUF_OVER_FRAME_CLEAR	0
#define	AISS2AO2A2M_AO_BUF_OVER_FRAME_CHECK	(-1)

// For queries the following values are returned.
#define	AISS2AO2A2M_AO_BUF_OVER_FRAME_NO	0
#define	AISS2AO2A2M_AO_BUF_OVER_FRAME_YES	1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AO_BUF_STATUS			BOOR D12, D13, D15
//
//	Parameter:	s32*
//		The value returned is one of the following.

#define	AISS2AO2A2M_AO_BUF_STATUS_EMPTY		0
#define	AISS2AO2A2M_AO_BUF_STATUS_AT_LOW	1
#define	AISS2AO2A2M_AO_BUF_STATUS_ABOVE		2
#define	AISS2AO2A2M_AO_BUF_STATUS_FULL		3

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AO_BURST_ENABLE		BOOR D19
//
//	Parameter:	s32*
//		The value returned is one of the following.
#define	AISS2AO2A2M_AO_BURST_ENABLE_NO		0
#define	AISS2AO2A2M_AO_BURST_ENABLE_YES		1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AO_BURST_STATUS		BOOR D18
//
//	Parameter:	s32*
//		The value returned is one of the following.
#define	AISS2AO2A2M_AO_BURST_STATUS_BUSY	0
#define	AISS2AO2A2M_AO_BURST_STATUS_READY	1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AO_BURST_SYNC_AI		BOOR D21
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_AO_BURST_SYNC_AI_NO		0
#define	AISS2AO2A2M_AO_BURST_SYNC_AI_YES	1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AO_CHAN_SEL			BOOR D0-D1
//
//	Parameter:	s32*
//		Pass in a bitmap of the channels to enable, or
//		-1 to read the current setting.
//		A valid bitmap is dependent on the AO selection and the
//		number of corresponding output channels on the board.

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AO_CLOCK_ENABLE		BOOR D5
//
//	Parameter:	s32*
//		Pass in any valid option below, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_AO_CLOCK_ENABLE_NO		0	// Disable the clock.
#define	AISS2AO2A2M_AO_CLOCK_ENABLE_YES		1	// Enable the clock.

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AO_CLOCK_SOURCE		BOOR D4
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_AO_CLOCK_SOURCE_EXT		0
#define	AISS2AO2A2M_AO_CLOCK_SOURCE_INT		1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AO_CLOCK_STATUS		BOOR D6
//
//	Parameter:	s32*
//		The value returned is one of the following.
#define	AISS2AO2A2M_AO_CLOCK_STATUS_BUSY	0
#define	AISS2AO2A2M_AO_CLOCK_STATUS_READY	1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AO_ENABLE				BOOR D14
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_AO_ENABLE_NO			0
#define	AISS2AO2A2M_AO_ENABLE_YES			1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AO_IO_ABORT
//
//	Parameter:	s32*
//		The returned value is one of the below options.
#define	AISS2AO2A2M_AO_IO_ABORT_NO				0
#define	AISS2AO2A2M_AO_IO_ABORT_YES			1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AO_IO_MODE
//
//	Parameter:	s32*
//		Pass in any of the gsc_io_mode_t options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_AO_IO_MODE_DEFAULT		GSC_IO_MODE_PIO

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AO_IO_OVERFLOW
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_AO_IO_OVERFLOW_DEFAULT	AISS2AO2A2M_AO_IO_OVERFLOW_CHECK
#define	AISS2AO2A2M_AO_IO_OVERFLOW_IGNORE	0
#define	AISS2AO2A2M_AO_IO_OVERFLOW_CHECK	1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AO_IO_TIMEOUT (in seconds)
//
//	Parameter:	s32*
//		Pass in any value from the minimim to the maximim, the infinite option,
//		or -1 to read the current setting. The value -1 is returned if the
//		feature is not supported, but this should never happen.
#define	AISS2AO2A2M_AO_IO_TIMEOUT_DEFAULT	10
#define	AISS2AO2A2M_AO_IO_TIMEOUT_NO_SLEEP	0
#define	AISS2AO2A2M_AO_IO_TIMEOUT_MIN		0
#define	AISS2AO2A2M_AO_IO_TIMEOUT_MAX		GSC_IO_TIMEOUT_MAX
#define	AISS2AO2A2M_AO_IO_TIMEOUT_INFINITE	GSC_IO_TIMEOUT_INFINITE

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AO_OUTPUT_MODE			BCR D18
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_AO_OUTPUT_MODE_SEQ		0
#define	AISS2AO2A2M_AO_OUTPUT_MODE_SIMUL	1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AO_RANGE				BCR D16-D17
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_AO_RANGE_2_5V			0	// +- 2.5 volts
#define	AISS2AO2A2M_AO_RANGE_5V				1	// +- 5 volts
#define	AISS2AO2A2M_AO_RANGE_10V			2	// +- 10 volts

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AO_SW_CLOCK			BCR D20, BOOR D7
//
//	Parameter:	None.

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AO_SW_TRIGGER			BOOR D20
//
//	Parameter:	None.

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AO_THRESH_LVL			OBTR D0-D21
//
//	Parameter:	s32*
//		Pass in any valid value from 0x0 to 0x3FFFFF, or
//		-1 to read the current setting.

//*****************************************************************************
// AISS2AO2A2M_IOCTL_AO_THRESH_STS			OBTR D24
//
//	Parameter:	s32*
//		The value returned is one of the following.
#define	AISS2AO2A2M_AO_THRESH_STS_CLEAR		0
#define	AISS2AO2A2M_AO_THRESH_STS_SET		1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_BDO_ACCESS_MODE		BDOBCR D27
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_BDO_ACCESS_MODE_FIFO	0
#define	AISS2AO2A2M_BDO_ACCESS_MODE_REG		1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_BDO_BUF_CLEAR			BDOBCR D20
//
//	Parameter:	None.

//*****************************************************************************
// AISS2AO2A2M_IOCTL_BDO_BUF_ENABLE			BDOBCR D21
//
//	Parameter:	s32*
//		Pass in any valid option below, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_BDO_BUF_ENABLE_NO		0	// Disable the buffer.
#define	AISS2AO2A2M_BDO_BUF_ENABLE_YES		1	// Enable the buffer.

//*****************************************************************************
// AISS2AO2A2M_IOCTL_BDO_BUF_LEVEL			BDOBSR D0-D17
//
//	Parameter:	s32*
//		The value returned is the current buffer fill level.

//*****************************************************************************
// AISS2AO2A2M_IOCTL_BDO_BUF_OVERFLOW		BDOBCR D29
//
//	Parameter:	s32*
//		Pass in any valid option below, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_BDO_BUF_OVERFLOW_CLEAR	0
#define	AISS2AO2A2M_BDO_BUF_OVERFLOW_CHECK	(-1)

// For queries the following values are returned.
#define	AISS2AO2A2M_BDO_BUF_OVERFLOW_NO		0
#define	AISS2AO2A2M_BDO_BUF_OVERFLOW_YES	1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_BDO_BUF_UNDERFLOW		BDOBCR D28
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_BDO_BUF_UNDERFLOW_CLEAR	0
#define	AISS2AO2A2M_BDO_BUF_UNDERFLOW_CHECK	(-1)

// For queries the following values are returned.
#define	AISS2AO2A2M_BDO_BUF_UNDERFLOW_NO	0
#define	AISS2AO2A2M_BDO_BUF_UNDERFLOW_YES	1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_BDO_CLOCK_ENABLE		BDOBCR D22
//
//	Parameter:	s32*
//		Pass in any valid option below, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_BDO_CLOCK_ENABLE_NO		0	// Disable the clock.
#define	AISS2AO2A2M_BDO_CLOCK_ENABLE_YES	1	// Enable the clock.

//*****************************************************************************
// AISS2AO2A2M_IOCTL_BDO_CLOCK_SOURCE		BDOBCR D25
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_BDO_CLOCK_SOURCE_INT	0
#define	AISS2AO2A2M_BDO_CLOCK_SOURCE_EXT	1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_BDO_IO_ABORT
//
//	Parameter:	s32*
//		The returned value is one of the below options.
#define	AISS2AO2A2M_BDO_IO_ABORT_NO			0
#define	AISS2AO2A2M_BDO_IO_ABORT_YES		1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_BDO_IO_MODE
//
//	Parameter:	s32*
//		Pass in any of the gsc_io_mode_t options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_BDO_IO_MODE_DEFAULT		GSC_IO_MODE_PIO

//*****************************************************************************
// AISS2AO2A2M_IOCTL_BDO_IO_OVERFLOW
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_BDO_IO_OVERFLOW_DEFAULT	AISS2AO2A2M_BDO_IO_OVERFLOW_CHECK
#define	AISS2AO2A2M_BDO_IO_OVERFLOW_IGNORE	0
#define	AISS2AO2A2M_BDO_IO_OVERFLOW_CHECK	1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_BDO_IO_TIMEOUT (in seconds)
//
//	Parameter:	s32*
//		Pass in any value from the minimim to the maximim, the infinite option,
//		or -1 to read the current setting. The value -1 is returned if the
//		feature is not supported, but this should never happen.
#define	AISS2AO2A2M_BDO_IO_TIMEOUT_DEFAULT	10
#define	AISS2AO2A2M_BDO_IO_TIMEOUT_NO_SLEEP	0
#define	AISS2AO2A2M_BDO_IO_TIMEOUT_MIN		0
#define	AISS2AO2A2M_BDO_IO_TIMEOUT_MAX		GSC_IO_TIMEOUT_MAX
#define	AISS2AO2A2M_BDO_IO_TIMEOUT_INFINITE	GSC_IO_TIMEOUT_INFINITE

//*****************************************************************************
// AISS2AO2A2M_IOCTL_BDO_IO_UNDERFLOW
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_BDO_IO_UNDERFLOW_DEFAULT	AISS2AO2A2M_BDO_IO_UNDERFLOW_CHECK
#define	AISS2AO2A2M_BDO_IO_UNDERFLOW_IGNORE		0
#define	AISS2AO2A2M_BDO_IO_UNDERFLOW_CHECK		1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_BDO_RATE_GEN_ENABLE	BDOBCR D26
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_BDO_RATE_GEN_ENABLE_NO	0
#define	AISS2AO2A2M_BDO_RATE_GEN_ENABLE_YES	1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_BDO_RATE_GEN_NDIV		BDORGR D0-D23
//
//	Parameter:	s32*
//		Pass in any value in the range of 8 to 0xFFFFFF, or
//		-1 to read the current setting.

//*****************************************************************************
// AISS2AO2A2M_IOCTL_BDO_SW_CLOCK			BDOBCR D23
//
//	Parameter:	None.

//*****************************************************************************
// AISS2AO2A2M_IOCTL_BDO_THRESH_LVL			BDOBCR D0-D19
//
//	Parameter:	s32*
//		Pass in any valid value from 0x0 to 0xFFFFF, or
//		-1 to read the current setting.

//*****************************************************************************
// AISS2AO2A2M_IOCTL_BDO_THRESH_STS			BDOBCR D24
//
//	Parameter:	s32*
//		The value returned is one of the following.
#define	AISS2AO2A2M_BDO_THRESH_STS_CLEAR	0
#define	AISS2AO2A2M_BDO_THRESH_STS_SET		1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_CBL_IN_CLK_IO			ACR D0
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_CBL_IN_CLK_IO_FUNC		0
#define	AISS2AO2A2M_CBL_IN_CLK_IO_OUT_0		1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_CBL_IO_CLK_DIR			BCR D24
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_CBL_IO_CLK_DIR_IN		0
#define	AISS2AO2A2M_CBL_IO_CLK_DIR_OUT		1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_CBL_OUT_CLK_IO			ACR D2
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_CBL_OUT_CLK_IO_FUNC		0
#define	AISS2AO2A2M_CBL_OUT_CLK_IO_OUT_0	1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_CBL_TRIG_IO			ACR D1
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_CBL_TRIG_IO_FUNC		0
#define	AISS2AO2A2M_CBL_TRIG_IO_OUT_0		1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_DATA_FORMAT			BCR D25
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_DATA_FORMAT_2S_COMP		0	// Twos Compliment
#define	AISS2AO2A2M_DATA_FORMAT_OFF_BIN		1	// Offset Binary

//*****************************************************************************
// AISS2AO2A2M_IOCTL_DIO_DIR				DIOPR D8
//
//	Parameter:	s32*
//		One of the below values is returned.
#define	AISS2AO2A2M_DIO_DIR_IN				0
#define	AISS2AO2A2M_DIO_DIR_OUT				1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_DIO_READ				DIOPR D0-D7
//
//	Parameter:	s32*
//		The value returned is in the range of 0 to 0xFF.

//*****************************************************************************
// AISS2AO2A2M_IOCTL_DIO_WRITE				DIOPR D0-D7, BDOBR D0-D7
//
//	Parameter:	s32*
//		Pass in any value in the range of 0 to 0xFFFF.

//*****************************************************************************
// AISS2AO2A2M_IOCTL_IRQ_ENABLE				PSR D0-D14
//
//	Parameter:	s32*
//		Pass in any combination of the below options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_IRQ_AUTO_CAL_DONE		0x0001
#define	AISS2AO2A2M_IRQ_AI_THRESH_H2L		0x0002
#define	AISS2AO2A2M_IRQ_AI_THRESH_L2H		0x0004
#define	AISS2AO2A2M_IRQ_AI_FAULT			0x0008
#define	AISS2AO2A2M_IRQ_AI_BURST_START		0x0010
#define	AISS2AO2A2M_IRQ_AI_BURST_DONE		0x0020
#define	AISS2AO2A2M_IRQ_BDO_THRESH_H2L		0x0040
#define	AISS2AO2A2M_IRQ_BDO_THRESH_L2H		0x0080
#define	AISS2AO2A2M_IRQ_DIO_0_L2H			0x0100
#define	AISS2AO2A2M_IRQ_AO_THRESH_H2L		0x0200
#define	AISS2AO2A2M_IRQ_AO_THRESH_L2H		0x0400
#define	AISS2AO2A2M_IRQ_AO_LOAD_RDY_H2L		0x0800
#define	AISS2AO2A2M_IRQ_AO_LOAD_RDY_L2H		0x1000
#define	AISS2AO2A2M_IRQ_AO_BURST_READY		0x2000
#define	AISS2AO2A2M_IRQ_AO_FAULT			0x4000
#define	AISS2AO2A2M_IRQ_ALL					0x7FFF

//*****************************************************************************
// AISS2AO2A2M_IOCTL_RATE_A_GEN_ENABLE		BCR D26
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_RATE_A_GEN_ENABLE_NO	0
#define	AISS2AO2A2M_RATE_A_GEN_ENABLE_YES	1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_RATE_A_GEN_NDIV		RAGR D0-D23
//
//	Parameter:	s32*
//		Pass in any value in the range of 20 to 0xFFFFFF, or
//		-1 to read the current setting.

//*****************************************************************************
// AISS2AO2A2M_IOCTL_RATE_B_GEN_ENABLE		BCR D27
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_RATE_B_GEN_ENABLE_NO	0
#define	AISS2AO2A2M_RATE_B_GEN_ENABLE_YES	1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_RATE_B_GEN_NDIV		RBGR D0-D23
//
//	Parameter:	s32*
//		Pass in any value in the range of 20 to 0xFFFFFF, or
//		-1 to read the current setting.

//*****************************************************************************
// AISS2AO2A2M_IOCTL_RATE_C_GEN_ENABLE		BCR D22
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_RATE_C_GEN_ENABLE_NO	0
#define	AISS2AO2A2M_RATE_C_GEN_ENABLE_YES	1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_RATE_C_GEN_NDIV		RCGR D0-D23
//
//	Parameter:	s32*
//		Pass in any value in the range of 20 to 0xFFFFFF, or
//		-1 to read the current setting.

//*****************************************************************************
// AISS2AO2A2M_IOCTL_TRIGGER_DIR			BCR D21
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS2AO2A2M_TRIGGER_DIR_IN			0
#define	AISS2AO2A2M_TRIGGER_DIR_OUT			1

//*****************************************************************************
// AISS2AO2A2M_IOCTL_WAIT_CANCEL			fields need not be valid
// AISS2AO2A2M_IOCTL_WAIT_EVENT				all fields must be valid
// AISS2AO2A2M_IOCTL_WAIT_STATUS			fields need not be valid
//
//	Parameter:	gsc_wait_t*
// gsc_wait_t.flags - see gsc_common.h
// gsc_wait_t.main - see gsc_common.h
// gsc_wait_t.gsc

#define	AISS2AO2A2M_WAIT_GSC_AUTO_CAL_DONE		AISS2AO2A2M_IRQ_AUTO_CAL_DONE
#define	AISS2AO2A2M_WAIT_GSC_AI_THRESH_H2L		AISS2AO2A2M_IRQ_AI_THRESH_H2L
#define	AISS2AO2A2M_WAIT_GSC_AI_THRESH_L2H		AISS2AO2A2M_IRQ_AI_THRESH_L2H
#define	AISS2AO2A2M_WAIT_GSC_AI_FAULT			AISS2AO2A2M_IRQ_AI_FAULT
#define	AISS2AO2A2M_WAIT_GSC_AI_BURST_START		AISS2AO2A2M_IRQ_AI_BURST_START
#define	AISS2AO2A2M_WAIT_GSC_AI_BURST_DONE		AISS2AO2A2M_IRQ_AI_BURST_DONE
#define	AISS2AO2A2M_WAIT_GSC_BDO_THRESH_H2L		AISS2AO2A2M_IRQ_BDO_THRESH_H2L
#define	AISS2AO2A2M_WAIT_GSC_BDO_THRESH_L2H		AISS2AO2A2M_IRQ_BDO_THRESH_L2H
#define	AISS2AO2A2M_WAIT_GSC_DIO_0_L2H			AISS2AO2A2M_IRQ_DIO_0_L2H
#define	AISS2AO2A2M_WAIT_GSC_AO_THRESH_H2L		AISS2AO2A2M_IRQ_AO_THRESH_H2L
#define	AISS2AO2A2M_WAIT_GSC_AO_THRESH_L2H		AISS2AO2A2M_IRQ_AO_THRESH_L2H
#define	AISS2AO2A2M_WAIT_GSC_AO_LOAD_RDY_H2L	AISS2AO2A2M_IRQ_AO_LOAD_RDY_H2L
#define	AISS2AO2A2M_WAIT_GSC_AO_LOAD_RDY_L2H	AISS2AO2A2M_IRQ_AO_LOAD_RDY_L2H
#define	AISS2AO2A2M_WAIT_GSC_AO_BURST_READY		AISS2AO2A2M_IRQ_AO_BURST_READY
#define	AISS2AO2A2M_WAIT_GSC_AO_FAULT			AISS2AO2A2M_IRQ_AO_FAULT
#define	AISS2AO2A2M_WAIT_GSC_ALL				AISS2AO2A2M_IRQ_ALL
// gsc_wait_t.alt flags
#define	AISS2AO2A2M_WAIT_ALT_ALL				0x0000
// gsc_wait_t.io
#define	AISS2AO2A2M_WAIT_IO_AI_RX_ABORT			0x0001
#define	AISS2AO2A2M_WAIT_IO_AI_RX_DONE			0x0002
#define	AISS2AO2A2M_WAIT_IO_AI_RX_ERROR			0x0004
#define	AISS2AO2A2M_WAIT_IO_AI_RX_TIMEOUT		0x0008

#define	AISS2AO2A2M_WAIT_IO_AO_TX_ABORT			0x0010
#define	AISS2AO2A2M_WAIT_IO_AO_TX_DONE			0x0020
#define	AISS2AO2A2M_WAIT_IO_AO_TX_ERROR			0x0040
#define	AISS2AO2A2M_WAIT_IO_AO_TX_TIMEOUT		0x0080

#define	AISS2AO2A2M_WAIT_IO_BDO_TX_ABORT		0x0100
#define	AISS2AO2A2M_WAIT_IO_BDO_TX_DONE			0x0200
#define	AISS2AO2A2M_WAIT_IO_BDO_TX_ERROR		0x0400
#define	AISS2AO2A2M_WAIT_IO_BDO_TX_TIMEOUT		0x0800

#define	AISS2AO2A2M_WAIT_IO_ALL					0x0FFF



#endif
