// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/driver/main.h $
// $Rev: 45168 $
// $Date: 2019-07-01 13:41:01 -0500 (Mon, 01 Jul 2019) $

// 16AISS2AO2A2M: Device Driver: header file

#ifndef	__MAIN_H__
#define	__MAIN_H__

#include "16aiss2ao2a2m.h"

#define	DEV_BAR_SHOW						0
#define	DEV_PCI_ID_SHOW						0
#define	DEV_SUPPORTS_IRQ
#define	DEV_SUPPORTS_READ
#define	DEV_SUPPORTS_WAIT
#define	DEV_SUPPORTS_WRITE
#define	GSC_ALT_DEV_GET(a)					(a)
#define	GSC_ALT_STRUCT_GET(i,d)				(d)
#define	GSC_ALT_STRUCT_T					dev_data_t
#define	GSC_DEVS_PER_BOARD					1

typedef struct _dev_data_t					dev_data_t;

#define	GSC_RX_IO_DEBUG						0
#define	GSC_TX_IO_DEBUG						0
#define	OS_DMA_ACQUIRE_METRICS				0
#define	OS_REG_IO_DEBUG						0

#include "gsc_main.h"



// #defines *******************************************************************

#define	DEV_MODEL							"16AISS2AO2A2M"	// Upper case form of the below.
#define	DEV_NAME							"16aiss2ao2a2m"	// MUST AGREE WITH AISS2AO2A2M_BASE_NAME

#define	DEV_VERSION							"1.1"			// FOR DEVICE SPECIFIC CODE ONLY!
// 1.1	Removed BDO's DMA code as it doesn't support DMA.
//		Added support for the 5.x kernel series.
//		Added Endianness support.
//		Some minor code reorganization.
//		Some whitespace cleanup.
//		Renamed the I/O source files.
// 1.0	Initial release.

// I/O services
#define	DEV_IO_STREAM_QTY					(DEV_IO_RX_STREAM_QTY + DEV_IO_TX_STREAM_QTY)
#define	DEV_IO_RX_STREAM_QTY				1
#define	DEV_IO_TX_STREAM_QTY				2

#define	GSC_READ_PIO_WORK_32_BIT
#define	GSC_WRITE_PIO_WORK_32_BIT

// WAIT services
#define	DEV_WAIT_GSC_ALL					AISS2AO2A2M_WAIT_GSC_ALL
#define	DEV_WAIT_ALT_ALL					AISS2AO2A2M_WAIT_ALT_ALL
#define	DEV_WAIT_IO_ALL						AISS2AO2A2M_WAIT_IO_ALL



// data types *****************************************************************

struct _dev_io_t
{
	// Initialized by open and IOCTL services (initialize and/or service specific).

	s32					io_mode;			// PIO, BMDMA, DMDMA
	s32					overflow_check;		// Check for overflows?
	s32					pio_threshold;		// Use PIO if samples <= this.
	s32					timeout_s;			// I/O timeout in seconds.
	s32					underflow_check;	// Check for underflows?

	// Initialized by I/O service at time of use.

	int					abort;				// Also set via IOCTL service.
	gsc_dma_ch_t*		dma_channel;		// Use this channel for DMA.
	int					non_blocking;		// Is this non-blocking I/O?

	// Initialized by device specific I/O create code.

	int					bytes_per_sample;	// Sample size in bytes.
	u32					io_reg_offset;		// Offset of board's I/O FIFO.
	VADDR_T				io_reg_vaddr;		// Address of board's I/O FIFO.

	void				(*dev_io_sw_init)		(GSC_ALT_STRUCT_T* alt, dev_io_t* io);
	void				(*dev_io_close)			(GSC_ALT_STRUCT_T* alt, dev_io_t* io);
	void				(*dev_io_open)			(GSC_ALT_STRUCT_T* alt, dev_io_t* io);
	int					(*dev_io_startup)		(GSC_ALT_STRUCT_T* alt, dev_io_t* io);
	long				(*dev_pio_available)	(GSC_ALT_STRUCT_T* alt, dev_io_t* io, size_t count);
	long				(*dev_bmdma_available)	(GSC_ALT_STRUCT_T* alt, dev_io_t* io, size_t count);
	long				(*dev_dmdma_available)	(GSC_ALT_STRUCT_T* alt, dev_io_t* io, size_t count);
	long				(*dev_pio_xfer)			(GSC_ALT_STRUCT_T* alt, dev_io_t* io, const os_mem_t* mem, size_t count, os_time_tick_t st_end);
	long				(*dev_bmdma_xfer)		(GSC_ALT_STRUCT_T* alt, dev_io_t* io, const os_mem_t* mem, size_t count, os_time_tick_t st_end);
	long				(*dev_dmdma_xfer)		(GSC_ALT_STRUCT_T* alt, dev_io_t* io, const os_mem_t* mem, size_t count, os_time_tick_t st_end);

	struct
	{
		u32				abort;		// ...WAIT_IO_XXX_ABORT
		u32				done;		// ...WAIT_IO_XXX_DONE
		u32				error;		// ...WAIT_IO_XXX_ERROR
		u32				timeout;	// ...WAIT_IO_XXX_TIMEOUT
	} wait;

	// Initialize by GSC commone create code.

	os_mem_t			mem;				// I/O buffer.
	os_sem_t			sem;				// Only one Tx or Rx at a time.
};

struct _dev_data_t
{
	os_pci_t			pci;			// The kernel PCI device descriptor.
	os_data_t			os;				// OS specific data.
	os_spinlock_t		spinlock;		// Control ISR access.
	os_sem_t			sem;			// Control thread access.
	gsc_dev_type_t		board_type;		// Corresponds to basic board type.
	const char*			model;			// Base model number in upper case.
	int					board_index;	// Index of the board being accessed.
	int					users;			// Number of currently active open() requests.
	int					share;			// Were we opened in shared mode?

	gsc_bar_t			bar;			// device register mappings
	gsc_dma_t			dma;			// For DMA based I/O.
	gsc_irq_t			irq;			// For interrupts.
	gsc_wait_node_t*	wait_list;

	struct
	{					// This is for streaming I/O
		dev_io_t		ai_rx;			// Analog Input read
		dev_io_t		ao_tx;			// Analog Output write
		dev_io_t		bdo_tx;			// BDO write
		dev_io_t*		io_streams[DEV_IO_STREAM_QTY];
	} io;

	struct
	{
		VADDR_T			plx_intcsr_32;	// Interrupt Control/Status Register
		VADDR_T			plx_dmaarb_32;	// DMA Arbitration Register
		VADDR_T			plx_dmathr_32;	// DMA Threshold Register

		VADDR_T			gsc_aobr_32;	// Analog Output Buffer Register
		VADDR_T			gsc_aoc0r_32;	// Anlog Output Channel 0 Register
		VADDR_T			gsc_aoc1r_32;	// Anlog Output Channel 1 Register
		VADDR_T			gsc_acfgr_32;	// Assymbly Configuration Register
		VADDR_T			gsc_acr_32;		// Ancillary Control Register
		VADDR_T			gsc_aibr_32;	// Analog Input Buffer Register
		VADDR_T			gsc_avr_32;		// Autocal Values Register

		VADDR_T			gsc_bcr_32;		// Board Control Register
		VADDR_T			gsc_bdobcr_32;	// BDO Control Register
		VADDR_T			gsc_bdobr_32;	// BDO Buffer Register
		VADDR_T			gsc_bdobsr_32;	// BDO Buffer Size Register
		VADDR_T			gsc_bdorgr_32;	// BDO Rate Generator Register
		VADDR_T			gsc_boor_32;	// Buffered Output Operations Register

		VADDR_T			gsc_diopr_32;	// Digital I/O Port Register

		VADDR_T			gsc_ibsr_32;	// Input Buffer Size Register
		VADDR_T			gsc_ibtr_32;	// Input Buffer Threshold Register
		VADDR_T			gsc_icr_32;		// Input Configuration Register

		VADDR_T			gsc_obsr_32;	// Output Buffer Size Register
		VADDR_T			gsc_obtr_32;	// Output Buffer Threshold Register

		VADDR_T			gsc_psr_32;		// Primary Status Register

		VADDR_T			gsc_ragr_32;	// Rate-A Generator Register
		VADDR_T			gsc_rbgr_32;	// Rate-B Generator Register
		VADDR_T			gsc_rcgr_32;	// Rate-C Generator Register

	} vaddr;

	struct
	{
		s32				ai_chans_max;
		s32				ai_chans_qty;	// ACR.D16
		u32				ai_fifo_size;
		s32				ai_fsamp_max;
		s32				ai_fsamp_min;
		s32				ai_ndiv_max;
		s32				ai_ndiv_min;

		s32				ao_chans_max;
		s32				ao_chans_qty;	// ACR.D17
		u32				ao_fifo_size;
		s32				ao_fsamp_max;
		s32				ao_fsamp_min;
		s32				ao_ndiv_max;
		s32				ao_ndiv_min;

		s32				autocal_ms;		// BCR D28, D3

		u32				bdo_fifo_size;
		s32				bdo_fsamp_max;
		s32				bdo_fsamp_min;
		s32				bdo_ndiv_max;
		s32				bdo_ndiv_min;

		u32				gsc_acr_32;		// Assembly Configuration Register

		s32				initialize_ms;

		s32				master_clock;	// ACR.D18-D19

		s32				rate_gen_qty;

	} cache;
};



// prototypes *****************************************************************

int			dev_read_ai_create(dev_data_t* dev, dev_io_t* io);
int			dev_write_ao_create(dev_data_t* dev, dev_io_t* io);
int			dev_write_bdo_create(dev_data_t* dev, dev_io_t* io);
void		dev_io_close(dev_data_t* dev);
int			dev_io_create(dev_data_t* dev);
void		dev_io_destroy(dev_data_t* dev);
int			dev_io_open(dev_data_t* dev);
dev_io_t*	dev_io_read_select(dev_data_t* dev, size_t count);
dev_io_t*	dev_io_write_select(dev_data_t* dev, size_t count);
int			dev_irq_create(dev_data_t* dev);
void		dev_irq_destroy(dev_data_t* dev);

int			initialize_ioctl(dev_data_t* dev, void* arg);



#endif
