// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/driver/irq.c $
// $Rev: 43415 $
// $Date: 2018-08-24 17:31:42 -0500 (Fri, 24 Aug 2018) $

// 16AISS2AO2A2M: Device Driver: source file

#include "main.h"



//*****************************************************************************
void dev_irq_isr_local_handler(dev_data_t* dev)
{
	u32	alt;
	u32	mask;
	u32	psr;

	psr	= os_reg_mem_rx_u32(NULL, dev->vaddr.gsc_psr_32);
	alt	= psr & (psr >> 16) & 0x7FFF;

	if (alt)
	{
		// Service the active interrupts.
		mask	= alt << 16;
		os_reg_mem_mx_u32(NULL, dev->vaddr.gsc_psr_32, 0, mask);

		// Resume any threads awiting any of these interrupts.
		gsc_wait_resume_irq_gsc(dev, alt);
	}
	else
	{
		// We don't know the source of the interrupt.
		gsc_wait_resume_irq_main(dev, GSC_WAIT_MAIN_SPURIOUS);
	}
}



//*****************************************************************************
int dev_irq_create(dev_data_t* dev)
{
	int	ret;

	os_reg_mem_tx_u32(dev, dev->vaddr.gsc_psr_32, 0);
	ret	= gsc_irq_create(dev);
	return(ret);
}



//*****************************************************************************
void dev_irq_destroy(dev_data_t* dev)
{
	if (dev->vaddr.gsc_psr_32)
		os_reg_mem_tx_u32(dev, dev->vaddr.gsc_psr_32, 0);

	gsc_irq_destroy(dev);
}


