// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AISS2AO2A2M/api/read_ai.c $
// $Rev: 45181 $
// $Date: 2019-07-01 16:56:07 -0500 (Mon, 01 Jul 2019) $

// 16AISS2AO2A2M: API Library: source file

#include "main.h"



//*****************************************************************************
// Return Values:
//	>=0	= success, the number of bytes transferred
//	<0  = failure, value is -errno or -GetLastError (Windows only)
int aiss2ao2a2m_read_ai(int fd, void* dst, size_t bytes)
{
	int	ret;

	if (bytes > GSC_IO_SIZE_QTY_MASK)
		bytes	= GSC_IO_SIZE_QTY_MASK & ~0x3;

	bytes	|= STREAM_ID_AI;
	ret		= gsc_api_read(fd, dst, bytes);
	return(ret);
}


