// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AICS32/utils/wait_event.c $
// $Rev: 56657 $
// $Date: 2025-09-19 11:05:56 -0500 (Fri, 19 Sep 2025) $

// 16AICS32: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aics32_wait_event
*
*	Purpose:
*
*		Provide a visual wrapper for the AICS32_IOCTL_WAIT_EVENT service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*
*		verbose	Work verbosely? 0 = no, !0 = yes
*
*		wait	This is the crieteria to use.
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int aics32_wait_event(int fd, int index, int verbose, gsc_wait_t* wait)
{
	int	errs;
	int	ret;

	if (verbose)
		gsc_label_index("Wait Event", index);

	ret		= aics32_ioctl(fd, AICS32_IOCTL_WAIT_EVENT, wait);
	errs	= ret ? 1 : 0;

	if (verbose)
		printf("%s\n", errs ? "FAIL <---" : "PASS");

	return(errs);
}



